/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.piccolo.CursorFactory;
import com.hp.hpl.guess.piccolo.util.SerEllipse;
import com.hp.hpl.guess.piccolo.util.SerLine;
import com.hp.hpl.guess.piccolo.util.SerRectangle;
import com.hp.hpl.guess.piccolo.util.SerRoundRectangle;
import com.hp.hpl.guess.ui.DrawWindow;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.FontDialog;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

public class DrawZoomHandler
extends PBasicInputEventHandler {
    protected PPath rectangle;
    protected SerLine myLine;
    protected Point2D pressPoint;
    protected Point2D dragPoint;
    private PLayer layer = null;
    private PCamera camera = null;
    static final int DASH_WIDTH = 5;
    static final int NUM_STROKES = 10;
    private float strokeNum = 0.0f;
    private BasicStroke[] strokes = null;
    FrameListener fl = null;
    public static final Color transparent = new Color(255, 255, 255, 0);
    public static final int RECT = 0;
    public static final int LINE = 1;
    public static final int ELL = 2;
    public static final int RRECT = 3;
    public static final int TEXT = 4;

    public DrawZoomHandler(PLayer layer, PCamera cam) {
        this.layer = layer;
        this.camera = cam;
        float[] dash = new float[]{5.0f, 5.0f};
        this.strokes = new BasicStroke[10];
        for (int i = 0; i < 10; ++i) {
            this.strokes[i] = new BasicStroke(1.0f, 0, 0, 1.0f, dash, i);
        }
        this.fl = VisFactory.getFactory().getDisplay();
    }

    public void mousePressed(PInputEvent e) {
        if (!e.isLeftMouseButton()) {
            return;
        }
        this.dragPoint = this.pressPoint = e.getPosition();
        if (DrawWindow.getTool() != 4 && DrawWindow.getTool() != 6) {
            this.rectangle = new PPath();
            this.rectangle.setStroke((Stroke)new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
            Color c = this.fl.getDisplayBackground();
            double lum = (299 * c.getRed() + 587 * c.getGreen() + 114 * c.getBlue()) / 1000;
            if (lum < 127.0) {
                this.rectangle.setStrokePaint((Paint)Color.white);
            } else {
                this.rectangle.setStrokePaint((Paint)Color.black);
            }
            this.layer.addChild((PNode)this.rectangle);
            this.updateRectangle();
        } else if (DrawWindow.getTool() == 6) {
            this.myLine = new SerLine();
            this.layer.addChild((PNode)this.myLine);
        }
    }

    public void mouseDragged(PInputEvent e) {
        if (!e.isLeftMouseButton()) {
            return;
        }
        if (this.rectangle != null) {
            float origStrokeNum = this.strokeNum;
            this.strokeNum = (this.strokeNum + 0.5f) % 10.0f;
            if ((int)this.strokeNum != (int)origStrokeNum) {
                this.rectangle.setStroke((Stroke)this.strokes[(int)this.strokeNum]);
            }
            this.dragPoint = e.getPosition();
            this.updateRectangle();
        } else if (this.myLine != null) {
            this.dragPoint = e.getPosition();
            this.updateLine();
        }
    }

    public void mouseReleased(PInputEvent e) {
        if (!e.isLeftMouseButton()) {
            return;
        }
        try {
            e.popCursor();
        }
        catch (Exception ex) {
            e.pushCursor(CursorFactory.getCursor(1));
        }
        this.updateRectangle();
        this.updateLine();
        Object nPath = null;
        if (DrawWindow.getTool() == 2) {
            nPath = new SerEllipse(this.rectangle.getX(), this.rectangle.getY(), this.rectangle.getWidth(), this.rectangle.getHeight());
            ((PPath)nPath).setStrokePaint((Paint)DrawWindow.getDrawColor());
            ((PPath)nPath).setStroke(DrawWindow.getStroke());
            this.layer.addChild((PNode)nPath);
        } else if (DrawWindow.getTool() == 3) {
            nPath = new SerRoundRectangle(this.rectangle.getX(), this.rectangle.getY(), this.rectangle.getWidth(), this.rectangle.getHeight(), this.rectangle.getWidth() * 0.1, this.rectangle.getHeight() * 0.1);
            this.layer.addChild((PNode)nPath);
            ((PPath)nPath).setStrokePaint((Paint)DrawWindow.getDrawColor());
            ((PPath)nPath).setStroke(DrawWindow.getStroke());
        } else if (DrawWindow.getTool() == 4) {
            nPath = new PText();
            nPath.setX((double)((float)this.pressPoint.getX()));
            nPath.setY((double)((float)this.pressPoint.getY()));
            nPath.setTextPaint((Paint)DrawWindow.getDrawColor());
            this.layer.addChild((PNode)nPath);
            FontDialog.getDialog(nPath);
        } else if (DrawWindow.getTool() == 6) {
            if (this.myLine != null) {
                this.myLine.setStrokePaint(DrawWindow.getDrawColor());
                this.myLine.setStroke(DrawWindow.getStroke());
            }
        } else {
            nPath = new SerRectangle(this.rectangle.getX(), this.rectangle.getY(), this.rectangle.getWidth(), this.rectangle.getHeight());
            this.layer.addChild((PNode)nPath);
            ((PPath)nPath).setStrokePaint((Paint)DrawWindow.getDrawColor());
            ((PPath)nPath).setStroke(DrawWindow.getStroke());
        }
        if (nPath != null) {
            nPath.setPaint(null);
        }
        if (this.rectangle != null) {
            this.layer.removeChild((PNode)this.rectangle);
        }
        this.rectangle = null;
        this.myLine = null;
    }

    public void updateRectangle() {
        if (this.rectangle != null) {
            PBounds b = new PBounds();
            b.add(this.pressPoint);
            b.add(this.dragPoint);
            this.rectangle.setPathTo((Shape)b);
        }
    }

    public void updateLine() {
        if (this.myLine != null) {
            this.myLine.setPathTo(this.pressPoint.getX(), this.pressPoint.getY(), this.dragPoint.getX(), this.dragPoint.getY());
        }
    }

    public void saveState(ObjectOutputStream oos) {
        try {
            Collection col = this.layer.getAllNodes();
            oos.writeInt(col.size());
            for (Object o : col) {
                if (o instanceof SerLine) {
                    oos.writeInt(1);
                    ((SerLine)o).writeObject(oos);
                    continue;
                }
                if (o instanceof SerEllipse) {
                    oos.writeInt(2);
                    ((SerEllipse)o).writeObject(oos);
                    continue;
                }
                if (o instanceof SerRectangle) {
                    oos.writeInt(0);
                    ((SerRectangle)o).writeObject(oos);
                    continue;
                }
                if (o instanceof SerRoundRectangle) {
                    oos.writeInt(3);
                    ((SerRoundRectangle)o).writeObject(oos);
                    continue;
                }
                if (o instanceof PText) {
                    oos.writeInt(4);
                    oos.writeObject(((PText)o).getText());
                    oos.writeObject(((PText)o).getFont());
                    oos.writeObject(((PText)o).getTextPaint());
                    oos.writeObject(((PText)o).getBounds());
                    continue;
                }
                oos.writeInt(-1);
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public void loadState(ObjectInputStream ois) {
        try {
            int toRead = ois.readInt();
            for (int i = 0; i < toRead; ++i) {
                PPath o;
                int type = ois.readInt();
                if (type == 4) {
                    PText newText = new PText();
                    newText.setText((String)ois.readObject());
                    newText.setFont((Font)ois.readObject());
                    newText.setTextPaint((Paint)ois.readObject());
                    newText.setBounds((Rectangle2D)((PBounds)ois.readObject()));
                    newText.setPaint(null);
                    this.layer.addChild((PNode)newText);
                    continue;
                }
                if (type == 1) {
                    o = new SerLine();
                    o.readObject(ois);
                    this.layer.addChild((PNode)o);
                    continue;
                }
                if (type == 2) {
                    o = new SerEllipse();
                    o.readObject(ois);
                    this.layer.addChild((PNode)o);
                    continue;
                }
                if (type == 0) {
                    o = new SerRectangle();
                    o.readObject(ois);
                    this.layer.addChild((PNode)o);
                    continue;
                }
                if (type != 3) continue;
                o = new SerRoundRectangle();
                o.readObject(ois);
                this.layer.addChild((PNode)o);
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }
}

