/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.freehep.HEPWriter;
import com.hp.hpl.guess.piccolo.ConvexHullNode;
import com.hp.hpl.guess.piccolo.CursorFactory;
import com.hp.hpl.guess.piccolo.DrawZoomHandler;
import com.hp.hpl.guess.piccolo.GPLayer;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.piccolo.JpegImagesToMovie;
import com.hp.hpl.guess.piccolo.KeyBoardManager;
import com.hp.hpl.guess.piccolo.RectZoomHandler;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.DrawWindow;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.FrameListener;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.MyPanHandler;
import edu.umd.cs.piccolo.event.MyZoomHandler;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.event.MySelectionHandler;
import edu.umd.cs.piccolox.handles.PHandle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.freehep.graphics2d.VectorGraphics;
import org.python.core.PyInstance;
import org.python.core.PySequence;

public class GFrame
extends PCanvas
implements FrameListener {
    boolean frozen = false;
    JpegImagesToMovie jitm = null;
    Vector frameBuffer = new Vector();
    public int fileCounter = 0;
    private boolean auto = true;
    private boolean movieMode = false;
    public static final int BROWSE_MODE = 0;
    public static final int NODE_EDIT_MODE = 1;
    public static final int EDGE_EDIT_MODE = 2;
    public static final int HULL_EDIT_MODE = 3;
    public static final int DRAW_CREATE_MODE = 4;
    public static final int DRAW_EDIT_MODE = 5;
    private int currentMode = 0;
    protected PLayer bImage = new GPLayer();
    protected PLayer hulls = new GPLayer();
    protected PLayer nodes = new GPLayer();
    protected PLayer edges = new GPLayer();
    protected PLayer labels = new GPLayer();
    protected PLayer draw = new GPLayer();
    protected PLayer extra = new GPLayer();
    RectZoomHandler rceh = null;
    MySelectionHandler pseh = null;
    DrawZoomHandler dseh = null;
    MyPanHandler mph = null;
    private static PText pt = new PText();
    private static boolean testMode = true;
    public static int ZOOM_SIZE = 40;
    private boolean fs = false;

    public GFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GFrame.this.initialize();
                GFrame.this.repaint();
            }
        });
    }

    @Override
    public void setFrozen(boolean state) {
        this.frozen = state;
        if (!state) {
            ListIterator it = this.hulls.getChildrenIterator();
            while (it.hasNext()) {
                ConvexHullNode chn = (ConvexHullNode)it.next();
                chn.setFrozen(state);
            }
            this.repaint();
        }
    }

    public void paintImmediately() {
        if (this.frozen) {
            return;
        }
        super.paintImmediately();
    }

    public void paintImmediately(int x, int y, int width, int height) {
        if (this.frozen) {
            return;
        }
        super.paintImmediately(x, y, width, height);
    }

    public void paintImmediately(Rectangle r) {
        if (this.frozen) {
            return;
        }
        super.paintImmediately(r);
    }

    public void startMovie(int fps, String filename) {
        this.startMovie(fps, filename, true);
    }

    public void startMovie(int fps, String filename, boolean auto) {
        this.movieMode = true;
        if (true) {
            this.stopMovie();
        }
        this.auto = auto;
        this.movieMode = true;
        Rectangle b = this.getBounds();
        this.jitm = new JpegImagesToMovie(b.width, b.height, fps, filename);
        Thread th = new Thread(this.jitm);
        th.start();
    }

    public void stopMovie() {
        if (this.jitm != null) {
            System.out.println("Stopping movie...");
            this.flushBuffer();
            this.jitm.getISS().stopMovie();
        }
        this.movieMode = false;
        this.jitm = null;
    }

    public void flushBuffer() {
        for (int i = 0; i < this.frameBuffer.size(); ++i) {
            byte[] b = (byte[])this.frameBuffer.elementAt(i);
            if (this.jitm == null) continue;
            this.jitm.getISS().loadBuffer(b);
        }
        this.frameBuffer.clear();
    }

    private synchronized void click() {
        this.click(false);
    }

    private synchronized void click(boolean pause) {
        try {
            Rectangle b = this.getBounds();
            BufferedImage image = new BufferedImage(b.width, b.height, 1);
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint((Graphics)g2);
            if (pause) {
                Thread.sleep(1000L);
            }
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            ++this.fileCounter;
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fos);
            JPEGEncodeParam jpegParams = encoder.getDefaultJPEGEncodeParam(image);
            jpegParams.setQuality(1.0f, false);
            encoder.setJPEGEncodeParam(jpegParams);
            encoder.encode(image);
            fos.close();
            this.frameBuffer.addElement(fos.toByteArray());
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public void paint(Graphics g) {
        if (this.frozen) {
            return;
        }
        super.paint(g);
        if (this.movieMode) {
            this.click();
        }
    }

    public int getMode() {
        return this.currentMode;
    }

    public void returnToRegular() {
        this.unselectAll();
        this.removeInputEventListener((PInputEventListener)this.dseh);
        this.removeInputEventListener((PInputEventListener)this.pseh);
        this.removeInputEventListener((PInputEventListener)this.rceh);
        this.removeInputEventListener((PInputEventListener)this.mph);
        this.addInputEventListener((PInputEventListener)this.rceh);
        this.addInputEventListener((PInputEventListener)this.mph);
        DrawWindow.uncreate();
        this.currentMode = 0;
    }

    public void switchHandler(int i) {
        this.returnToRegular();
        if (i == 1) {
            this.removeInputEventListener((PInputEventListener)this.rceh);
            this.addInputEventListener((PInputEventListener)this.pseh);
            this.pseh.switchTo(this.nodes);
        } else if (i == 2) {
            this.removeInputEventListener((PInputEventListener)this.rceh);
            this.addInputEventListener((PInputEventListener)this.pseh);
            this.pseh.switchTo(this.edges, false);
        } else if (i == 3) {
            this.removeInputEventListener((PInputEventListener)this.rceh);
            this.addInputEventListener((PInputEventListener)this.pseh);
            this.pseh.switchTo(this.hulls, false);
        } else if (i == 5) {
            this.removeInputEventListener((PInputEventListener)this.rceh);
            this.addInputEventListener((PInputEventListener)this.pseh);
            this.pseh.switchTo(this.draw);
            DrawWindow.create();
        } else if (i == 4) {
            this.removeInputEventListener((PInputEventListener)this.mph);
            this.removeInputEventListener((PInputEventListener)this.rceh);
            this.addInputEventListener((PInputEventListener)this.dseh);
            DrawWindow.create();
        } else {
            return;
        }
        this.currentMode = i;
    }

    public PLayer getNodes() {
        return this.nodes;
    }

    public PLayer getEdges() {
        return this.edges;
    }

    public PLayer getHulls() {
        return this.hulls;
    }

    public PLayer getDraw() {
        return this.draw;
    }

    public synchronized PCamera getGCamera() {
        return this.getCamera();
    }

    @Override
    public void center() {
        this.center(new Integer(1));
    }

    public void centerFast() {
        this.center(new Integer(1), 100L);
    }

    @Override
    public void center(Object o) {
        this.center(o, 2000L);
    }

    public void center(Object o, long t) {
        if (o == null) {
            return;
        }
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        if (o instanceof Integer) {
            int tcount = 0;
            if ((Integer)o == 1) {
                ListIterator li = this.nodes.getChildrenIterator();
                while (li.hasNext()) {
                    PNode n = (PNode)li.next();
                    if (!n.getVisible()) continue;
                    ++tcount;
                    if (n.getX() < minx) {
                        minx = n.getX();
                    }
                    if (n.getY() < miny) {
                        miny = n.getY();
                    }
                    if (n.getY() + n.getHeight() > maxy) {
                        maxy = n.getY() + ((GuessPNode)n).getDrawHeight();
                    }
                    if (!(n.getX() + n.getWidth() > maxx)) continue;
                    maxx = n.getX() + ((GuessPNode)n).getDrawWidth();
                }
            }
            if (tcount > 0) {
                this.center(minx, miny, maxx, maxy, t);
            }
            return;
        }
        if (o instanceof Node) {
            this.centerOn((GuessPNode)((Node)o).getRep());
            return;
        }
        if (o instanceof Edge) {
            this.centerOn((GuessPNode)((Edge)o).getNode1().getRep(), (GuessPNode)((Edge)o).getNode2().getRep());
            return;
        }
        if (o instanceof PySequence) {
            PySequence q = (PySequence)o;
            int len = q.__len__();
            for (int i = 0; i < len; ++i) {
                GuessPNode n;
                if (!(q.__getitem__(i) instanceof PyInstance)) continue;
                Object elem = ((PyInstance)q.__getitem__(i)).__tojava__(Object.class);
                if (elem instanceof Node) {
                    n = (GuessPNode)((Node)elem).getRep();
                    if (n.getX() < minx) {
                        minx = n.getX();
                    }
                    if (n.getY() < miny) {
                        miny = n.getY();
                    }
                    if (n.getY() + n.getHeight() > maxy) {
                        maxy = n.getY() + n.getDrawHeight();
                    }
                    if (!(n.getX() + n.getWidth() > maxx)) continue;
                    maxx = n.getX() + n.getDrawWidth();
                    continue;
                }
                if (!(elem instanceof Edge)) continue;
                n = (GuessPNode)((Edge)elem).getNode1().getRep();
                if (n.getX() < minx) {
                    minx = n.getX();
                }
                if (n.getY() < miny) {
                    miny = n.getY();
                }
                if (n.getY() + n.getHeight() > maxy) {
                    maxy = n.getY() + n.getDrawHeight();
                }
                if (n.getX() + n.getWidth() > maxx) {
                    maxx = n.getX() + n.getDrawWidth();
                }
                if ((n = (GuessPNode)((Edge)elem).getNode2().getRep()).getX() < minx) {
                    minx = n.getX();
                }
                if (n.getY() < miny) {
                    miny = n.getY();
                }
                if (n.getY() + n.getHeight() > maxy) {
                    maxy = n.getY() + n.getDrawHeight();
                }
                if (!(n.getX() + n.getWidth() > maxx)) continue;
                maxx = n.getX() + n.getDrawWidth();
            }
            this.center(minx, miny, maxx, maxy, t);
            return;
        }
        if (o instanceof Collection) {
            for (Object elem : (Collection)o) {
                GuessPNode n;
                if (elem instanceof Node) {
                    n = (GuessPNode)((Node)elem).getRep();
                    if (n.getX() < minx) {
                        minx = n.getX();
                    }
                    if (n.getY() < miny) {
                        miny = n.getY();
                    }
                    if (n.getY() + n.getHeight() > maxy) {
                        maxy = n.getY() + n.getDrawHeight();
                    }
                    if (!(n.getX() + n.getWidth() > maxx)) continue;
                    maxx = n.getX() + n.getDrawWidth();
                    continue;
                }
                if (!(elem instanceof Edge)) continue;
                n = (GuessPNode)((Edge)elem).getNode1().getRep();
                if (n.getX() < minx) {
                    minx = n.getX();
                }
                if (n.getY() < miny) {
                    miny = n.getY();
                }
                if (n.getY() + n.getHeight() > maxy) {
                    maxy = n.getY() + n.getDrawHeight();
                }
                if (n.getX() + n.getWidth() > maxx) {
                    maxx = n.getX() + n.getDrawWidth();
                }
                if ((n = (GuessPNode)((Edge)elem).getNode2().getRep()).getX() < minx) {
                    minx = n.getX();
                }
                if (n.getY() < miny) {
                    miny = n.getY();
                }
                if (n.getY() + n.getHeight() > maxy) {
                    maxy = n.getY() + n.getDrawHeight();
                }
                if (!(n.getX() + n.getWidth() > maxx)) continue;
                maxx = n.getX() + n.getDrawWidth();
            }
            this.center(minx, miny, maxx, maxy, t);
            return;
        }
        throw new Error("center() on " + o.getClass().toString() + " not implemented");
    }

    public void center(double minx, double miny, double maxx, double maxy) {
        this.center(minx, miny, maxx, maxy, 2000L);
    }

    public void center(double minx, double miny, double maxx, double maxy, long t) {
        if (minx == Double.MAX_VALUE || maxx == Double.MIN_VALUE || miny == Double.MAX_VALUE || maxy == Double.MIN_VALUE) {
            return;
        }
        Rectangle2D.Double r2d = new Rectangle2D.Double(minx -= 10.0, miny -= 10.0, (maxx += 10.0) - minx, (maxy += 10.0) - miny);
        this.center(r2d, t);
    }

    public void center(Rectangle2D r2, long t) {
        final Rectangle2D r2d = r2;
        final long tm = t;
        if (Guess.getSynchronous()) {
            try {
                PTransformActivity pta = this.getGCamera().animateViewToCenterBounds(r2d, true, tm);
                if (pta == null) {
                    return;
                }
                SimpDelegate sd = new SimpDelegate();
                pta.setDelegate((PActivity.PActivityDelegate)sd);
                while (sd.running()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception inte) {
                        System.out.println(inte);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionWindow.getExceptionWindow(ex);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PTransformActivity pta = GFrame.this.getGCamera().animateViewToCenterBounds(r2d, true, tm);
                }
            });
        }
    }

    @Override
    public void setBackgroundImage(String filename) {
        this.setBackgroundImage(filename, 0.0, 0.0);
    }

    @Override
    public void setBackgroundImage(String filename, double x, double y) {
        try {
            this.removeBackgroundImage();
            PImage backgroundNode = new PImage(filename);
            backgroundNode.setX(x);
            backgroundNode.setY(y);
            this.bImage.addChild((PNode)backgroundNode);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    @Override
    public void removeBackgroundImage() {
        this.bImage.removeAllChildren();
    }

    public void initialize() {
        while (this.hulls == null || this.nodes == null || this.edges == null || this.labels == null) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {}
        }
        this.getLayer().addChild((PNode)this.bImage);
        this.getLayer().addChild((PNode)this.hulls);
        this.getLayer().addChild((PNode)this.edges);
        this.getLayer().addChild((PNode)this.nodes);
        this.getLayer().addChild((PNode)this.labels);
        this.getLayer().addChild((PNode)this.draw);
        this.getLayer().addChild((PNode)this.extra);
        this.rceh = new RectZoomHandler(this.extra, this.getGCamera());
        this.addInputEventListener((PInputEventListener)this.rceh);
        this.pseh = new MySelectionHandler(this.extra, this.nodes);
        this.dseh = new DrawZoomHandler(this.draw, this.getGCamera());
        KeyBoardManager kbm = new KeyBoardManager(this);
        this.getRoot().getDefaultInputManager().setKeyboardFocus((PInputEventListener)kbm);
        this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
        this.mph = new MyPanHandler(this);
        this.addInputEventListener((PInputEventListener)this.mph);
        this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        this.addInputEventListener((PInputEventListener)new MyZoomHandler(this));
        CursorFactory.init(this);
        PHandle.DEFAULT_HANDLE_SHAPE = new Ellipse2D.Float(0.0f, 0.0f, 2.0f, 2.0f);
    }

    @Override
    public BufferedImage getFullImage() {
        return this.getFullImage(null, 1.0);
    }

    public BufferedImage getFullImage(double scale) {
        return this.getFullImage(null, scale);
    }

    public BufferedImage getFullImage(Rectangle2D fis) {
        return this.getFullImage(fis, 1.0);
    }

    public BufferedImage getFullImage(double maxWidth, double maxHeight) {
        return this.getFullImage(null, maxWidth, maxHeight);
    }

    public BufferedImage getFullImage(Rectangle2D fis, double maxWidth, double maxHeight) {
        if (fis == null) {
            fis = this.getFullImageSize();
        }
        double scaleX = maxWidth / fis.getWidth();
        double scaleY = maxHeight / fis.getHeight();
        return this.getFullImage(fis, Math.min(scaleX, scaleY));
    }

    public Dimension getFullImageDimensions() {
        return this.getFullImageDimensions(1.0);
    }

    public Dimension getFullImageDimensions(double scale) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxW = Double.MIN_VALUE;
        double maxH = Double.MIN_VALUE;
        for (int i = 0; i < this.getGCamera().getLayerCount(); ++i) {
            PLayer l = this.getGCamera().getLayer(i);
            PBounds pb = l.getFullBounds();
            if (pb.getX() < minX) {
                minX = pb.getX();
            }
            if (pb.getY() < minY) {
                minY = pb.getY();
            }
            if (pb.getWidth() > maxW) {
                maxW = pb.getWidth();
            }
            if (!(pb.getHeight() > maxH)) continue;
            maxH = pb.getHeight();
        }
        return new Dimension((int)(maxW *= scale), (int)(maxH *= scale));
    }

    public Rectangle2D getFullImageSize() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxW = Double.MIN_VALUE;
        double maxH = Double.MIN_VALUE;
        for (int i = 0; i < this.getGCamera().getLayerCount(); ++i) {
            PLayer l = this.getGCamera().getLayer(i);
            PBounds pb = l.getFullBounds();
            if (pb.getX() < minX) {
                minX = pb.getX();
            }
            if (pb.getY() < minY) {
                minY = pb.getY();
            }
            if (pb.getWidth() > maxW) {
                maxW = pb.getWidth();
            }
            if (!(pb.getHeight() > maxH)) continue;
            maxH = pb.getHeight();
        }
        return new Rectangle2D.Double(minX, minY, maxW, maxH);
    }

    public BufferedImage getFullImage(Rectangle2D trans, double scale) {
        if (trans == null) {
            trans = this.getFullImageSize();
        }
        double minX = trans.getX() * scale;
        double minY = trans.getY() * scale;
        double maxW = trans.getWidth() * scale;
        double maxH = trans.getHeight() * scale;
        if (maxW <= Double.MIN_VALUE || maxH <= Double.MIN_VALUE) {
            return null;
        }
        BufferedImage img = new BufferedImage((int)maxW, (int)maxH, 4);
        Graphics2D g = img.createGraphics();
        Paint temp = g.getPaint();
        g.setPaint(this.getDisplayBackground());
        g.fill(new Rectangle(0, 0, (int)maxW, (int)maxH));
        g.setPaint(temp);
        for (int i = 0; i < this.getGCamera().getLayerCount(); ++i) {
            PLayer l = this.getGCamera().getLayer(i);
            PBounds pb = l.getFullBounds();
            Image timage = null;
            timage = scale == 1.0 ? l.toImage() : l.toImage((int)(pb.getWidth() * scale), (int)(pb.getHeight() * scale), null);
            int moveX = (int)(pb.getX() * scale) - (int)minX;
            int moveY = (int)(pb.getY() * scale) - (int)minY;
            g.drawImage(timage, moveX, moveY, (ImageObserver)((Object)this));
        }
        return img;
    }

    public Point2D getLastClickedPosition() {
        return this.mph.getLastClickedPosition();
    }

    public Collection getSelected() {
        return this.pseh.getSelection();
    }

    public void unselectAll() {
        this.pseh.unselectAll();
    }

    public void overlayText(String s) {
        pt.setText(s);
        pt.setTextPaint((Paint)Color.yellow);
        pt.setPaint((Paint)Color.black);
        pt.setX(0.0);
        pt.setY(0.0);
        this.getGCamera().addChild((PNode)pt);
        try {
            this.repaint();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getGCamera().removeChild((PNode)pt);
    }

    @Override
    public void setDisplayBackground(Color bg) {
        this.setBackground(bg);
    }

    public void setDisplayBackground(String bg) {
        this.setBackground(Colors.getColor(bg, this.getDisplayBackground()));
    }

    @Override
    public Color getDisplayBackground() {
        return this.getBackground();
    }

    @Override
    public void exportGIF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 0);
    }

    @Override
    public void exportJPG(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 1);
    }

    @Override
    public void exportPDF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 2);
    }

    @Override
    public void exportPS(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 3);
    }

    @Override
    public void exportEPS(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 3);
    }

    @Override
    public void exportSVG(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 4);
    }

    @Override
    public void exportSWF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 5);
    }

    @Override
    public void exportJAVA(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 6);
    }

    @Override
    public void exportCGM(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 7);
    }

    @Override
    public void exportEMF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 8);
    }

    @Override
    public void exportPNG(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 9);
    }

    public void centerOn(GuessPNode gpn) {
        float centerX = (float)gpn.getX() + (float)gpn.getWidth() / 2.0f;
        float centerY = (float)gpn.getY() + (float)gpn.getHeight() / 2.0f;
        float zs = (float)Math.max(gpn.getWidth(), Math.max(gpn.getHeight(), (double)ZOOM_SIZE));
        if (zs > (float)ZOOM_SIZE) {
            zs += 10.0f;
        }
        final Rectangle2D.Float r2d = new Rectangle2D.Float(centerX - zs / 2.0f, centerY - zs / 2.0f, zs, zs);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PTransformActivity pta = GFrame.this.getGCamera().animateViewToCenterBounds(r2d, true, 2000L);
            }
        });
    }

    public void centerOn(GuessPNode n1, GuessPNode n2) {
        if (n1 == n2) {
            this.centerOn(n1);
            return;
        }
        float minX = (float)Math.min(n1.getX(), n2.getX());
        float maxX = (float)Math.max(n1.getX() + n1.getWidth(), n2.getX() + n2.getWidth());
        float minY = (float)Math.min(n1.getY(), n2.getY());
        float maxY = (float)Math.max(n1.getY() + n1.getHeight(), n2.getY() + n2.getHeight());
        float zs = Math.max(maxY - minY, maxX - minX);
        if (zs > (float)ZOOM_SIZE) {
            zs += 10.0f;
            minX -= 10.0f;
            minY -= 10.0f;
        }
        final Rectangle2D.Float r2d = new Rectangle2D.Float(minX, minY, zs, zs);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PTransformActivity pta = GFrame.this.getGCamera().animateViewToCenterBounds(r2d, true, 2000L);
            }
        });
    }

    public void saveState(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject("_BACKGROUND_DISPLAY_COLOR");
            oos.writeObject(this.getDisplayBackground());
            oos.writeObject("_DRAW_LAYER");
            this.dseh.saveState(oos);
            oos.close();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public void loadState(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            String tag = (String)ois.readObject();
            if (tag.equals("_BACKGROUND_DISPLAY_COLOR")) {
                this.setDisplayBackground((Color)ois.readObject());
            }
            if ((tag = (String)ois.readObject()).equals("_DRAW_LAYER")) {
                this.dseh.loadState(ois);
            }
            ois.close();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public void writeFullImage(String name, int itype, Properties props) {
        this.writeFullImage(name, itype, null, 1.0, props);
    }

    public void writeFullImage(String name, int itype, double scale, Properties props) {
        this.writeFullImage(name, itype, null, scale, props);
    }

    public void writeFullImage(String name, int itype, Rectangle2D fis, Properties props) {
        this.writeFullImage(name, itype, fis, 1.0, props);
    }

    public void writeFullImage(String name, int itype, double maxWidth, double maxHeight, Properties props) {
        this.writeFullImage(name, itype, null, maxWidth, maxHeight, props);
    }

    public void writeFullImage(String name, int itype, Rectangle2D fis, double maxWidth, double maxHeight, Properties props) {
        if (fis == null) {
            fis = this.getFullImageSize();
        }
        double scaleX = maxWidth / fis.getWidth();
        double scaleY = maxHeight / fis.getHeight();
        this.writeFullImage(name, itype, fis, Math.min(scaleX, scaleY), props);
    }

    public void writeFullImage(String name, int itype, Rectangle2D trans, double scale, Properties props) {
        if (trans == null) {
            trans = this.getFullImageSize();
        }
        double minX = trans.getX() * scale;
        double minY = trans.getY() * scale;
        double maxW = trans.getWidth() * scale;
        double maxH = trans.getHeight() * scale;
        if (maxW <= Double.MIN_VALUE || maxH <= Double.MIN_VALUE) {
            return;
        }
        PageFormat pf = new PageFormat();
        Paper pg = new Paper();
        pg.setSize(maxW, maxH);
        pg.setImageableArea(0.0, 0.0, maxW, maxH);
        pf.setPaper(pg);
        Graphics2D g = HEPWriter.getGraphics2D(name, itype, (int)maxW, (int)maxH);
        if (g instanceof VectorGraphics) {
            ((VectorGraphics)g).startExport();
        }
        Paint temp = g.getPaint();
        g.setPaint(this.getDisplayBackground());
        g.fill(new Rectangle(0, 0, (int)maxW, (int)maxH));
        g.setPaint(temp);
        for (int i = 0; i < this.getGCamera().getLayerCount(); ++i) {
            PLayer l = this.getGCamera().getLayer(i);
            l.print((Graphics)g, pf, 0);
        }
        if (g instanceof VectorGraphics) {
            ((VectorGraphics)g).endExport();
        }
    }

    class SimpDelegate
    implements PActivity.PActivityDelegate {
        private boolean runn = false;

        SimpDelegate() {
        }

        public boolean running() {
            return this.runn;
        }

        public void activityFinished(PActivity activity) {
            this.runn = false;
        }

        public void activityStarted(PActivity activity) {
            this.runn = true;
        }

        public void activityStepped(PActivity activity) {
            this.runn = true;
        }
    }
}

