/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.freehep.HEPDialog;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.GuessJFrame;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class GradientLegend
extends JPanel
implements Dockable {
    DumbCanvas myCanvas = new DumbCanvas();
    private double majorTicks = 5.0;
    private double min = 0.0;
    private double max = 10.0;
    private JPopupMenu jp = new JPopupMenu("Options");
    private Vector tickMarks = null;
    private Vector textMarks = null;
    private PNode gradNode = null;
    private Color foregroundColor = Color.black;
    private Color startColor = null;
    private Color endColor = null;
    private Font anno = null;
    private Rectangle2D bounds = null;
    private int direction = 2;
    private GuessJFrame myParent = null;

    private void generateTickMarks() {
        if (this.tickMarks == null) {
            this.tickMarks = new Vector();
            this.textMarks = new Vector();
            for (double val = this.min; val <= this.max; val += this.majorTicks) {
                PPath tickMark = new PPath();
                this.tickMarks.add(tickMark);
                PText txt = new PText("" + val);
                if (this.anno == null) {
                    this.anno = txt.getFont();
                    this.anno = this.direction == 2 ? this.anno.deriveFont((float)Math.min(20.0, 600.0 / this.majorTicks)) : this.anno.deriveFont(20);
                }
                txt.setFont(this.anno);
                this.textMarks.add(txt);
                this.myCanvas.dLayer.addChild((PNode)tickMark);
                this.myCanvas.dLayer.addChild((PNode)txt);
            }
        }
        double maxX = 0.0;
        double maxY = 0.0;
        if (this.direction == 2) {
            double startY = 0.0;
            double increment = 600.0 * this.majorTicks / (this.max - this.min);
            maxY = 600.0;
            for (int i = 0; i < this.tickMarks.size(); ++i) {
                PPath ln = (PPath)this.tickMarks.elementAt(i);
                PText txt = (PText)this.textMarks.elementAt(i);
                ln.setStrokePaint((Paint)this.foregroundColor);
                txt.setTextPaint((Paint)this.foregroundColor);
                ln.setPathTo((Shape)new Line2D.Double(33.0, startY, 60.0, startY));
                txt.setX(65.0);
                txt.setY(startY - (double)(this.anno.getSize() / 2));
                startY += increment;
                maxX = Math.max(maxX, txt.getBounds().getX() + txt.getBounds().getWidth());
                maxY = Math.max(maxY, txt.getBounds().getY() + txt.getBounds().getHeight());
            }
        }
        this.bounds = new Rectangle2D.Float(-10.0f, -10.0f, (float)maxX + 20.0f, (float)maxY + 20.0f);
        this.recenter();
    }

    private void generateGradNode() {
        double y2;
        double y1;
        double x2;
        double x1;
        if (this.gradNode == null) {
            this.gradNode = new PPath((Shape)new Rectangle2D.Double(10.0, 10.0, 100.0, 500.0));
            this.myCanvas.dLayer.addChild(this.gradNode);
        }
        if (this.direction == 2) {
            this.gradNode.setBounds(0.0, -1.0, 30.0, 602.0);
        } else {
            this.gradNode.setBounds(0.0, 0.0, 600.0, 30.0);
        }
        ((PPath)this.gradNode).setStrokePaint((Paint)this.foregroundColor);
        if (this.direction == 2) {
            x2 = x1 = this.gradNode.getX() + this.gradNode.getWidth() / 2.0;
            y1 = this.gradNode.getY();
            y2 = this.gradNode.getY() + this.gradNode.getHeight();
        } else {
            x1 = this.gradNode.getX();
            x2 = this.gradNode.getX() + this.gradNode.getWidth();
            y2 = y1 = this.gradNode.getY() + this.gradNode.getHeight() / 2.0;
        }
        this.gradNode.setPaint((Paint)new GradientPaint((float)x1, (float)y1, this.startColor, (float)x2, (float)y2, this.endColor, false));
    }

    public GradientLegend(Color startC, Color endC, double min, double max, double ticks) {
        this(startC, endC, min, max, ticks, 2);
    }

    public GradientLegend(String startC, String endC, double min, double max, double ticks) {
        this(Colors.getColor(startC, Color.red), Colors.getColor(endC, Color.blue), min, max, ticks, 2);
    }

    public GradientLegend(String startC, String endC, double min, double max, double ticks, int direction) {
        this(Colors.getColor(startC, Color.red), Colors.getColor(endC, Color.blue), min, max, ticks, direction);
    }

    public GradientLegend(Color startC, Color endC, double min, double max, double ticks, int direction) {
        this.direction = direction;
        this.startColor = startC;
        this.endColor = endC;
        this.min = min;
        this.max = max;
        this.majorTicks = ticks;
        Guess.getMainUIWindow().dock(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)((Object)this.myCanvas), c);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent().getWidth() > 0) {
                    GradientLegend.this.recenter();
                }
            }
        });
        JMenuItem jmi = this.jp.add("Export Image");
        ActionListener printListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Export Image")) {
                    HEPDialog hd = new HEPDialog(null);
                    hd.showHEPDialog(null, "Export File", (Component)((Object)GradientLegend.this.myCanvas), "output.jpg", false);
                }
            }
        };
        jmi.addActionListener(printListener);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 2 || e.getButton() == 3) {
                    GradientLegend.this.jp.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.myCanvas.addMouseListener(ma);
        this.relayoutNodes();
    }

    public void relayoutNodes() {
        this.generateTickMarks();
        this.generateGradNode();
    }

    public Rectangle2D getB() {
        return this.bounds;
    }

    public void recenter() {
        if (this.bounds == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PTransformActivity pta = GradientLegend.this.myCanvas.getCamera().animateViewToCenterBounds(GradientLegend.this.getB(), true, 100L);
            }
        });
    }

    public void setDisplayBackground() {
        this.setDisplayBackground(this.getDisplayBackground());
    }

    public void setDisplayBackground(Color bg) {
        this.myCanvas.setBackground(bg);
        double lum = (299 * bg.getRed() + 587 * bg.getGreen() + 114 * bg.getBlue()) / 1000;
        this.foregroundColor = lum > 127.0 ? Color.black : Color.white;
        this.relayoutNodes();
    }

    public void setDisplayBackground(String bg) {
        this.setDisplayBackground(Colors.getColor(bg, this.getDisplayBackground()));
    }

    public Color getDisplayBackground() {
        return this.myCanvas.getBackground();
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(100, 100, 200, 600);
    }

    @Override
    public int getDirectionPreference() {
        return this.direction;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.direction == 2) {
            return new Dimension(200, 600);
        }
        return new Dimension(600, 200);
    }

    @Override
    public String toString() {
        return "GradientLegend";
    }

    @Override
    public void opening(boolean state) {
    }

    @Override
    public void attaching(boolean state) {
    }

    @Override
    public String getTitle() {
        return "Legend";
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    class DumbCanvas
    extends PCanvas {
        public PLayer dLayer = new PLayer();

        public DumbCanvas() {
            if (this.dLayer == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getLayer().addChild((PNode)this.dLayer);
            this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
            this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        }
    }
}

