/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.UndirectedEdge;
import com.hp.hpl.guess.piccolo.Arrow;
import com.hp.hpl.guess.piccolo.GuessPEdge;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GuessLegendEdge
extends PPath {
    double n1x = 0.0;
    double n1y = 0.0;
    double n2x = 10.0;
    double n2y = 10.0;
    boolean loop = false;
    boolean arrows = false;
    int destination = 0;
    static final int toN1 = 1;
    static final int toN2 = 2;
    static final int toN1N2 = 3;
    Color curcolor = Color.black;
    private int arrow_style = 0;
    private Point2D p1 = null;
    private Point2D p2 = null;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_START = 1;
    public static final int ARROW_END = 2;
    public static final int ARROW_BOTH = 3;

    public GuessLegendEdge(Edge owner) {
        GuessPEdge gpe = (GuessPEdge)owner.getRep();
        this.setColor((Color)gpe.getColor());
        this.setLineWidth(gpe.getLineWidth());
        Node n1 = owner.getNode1();
        Node n2 = owner.getNode2();
        if (n1 == n2) {
            this.loop = true;
        }
        this.arrows = VisFactory.getFactory().getDirected();
        if (this.arrows) {
            if (owner instanceof UndirectedEdge) {
                this.destination = 3;
            } else if (!this.loop) {
                n1 = (Node)((DirectedEdge)owner).getSource();
                this.destination = n1 == n2 ? 2 : 1;
            }
        }
        this.readjust();
    }

    public void setShape(Shape aShape) {
        this.setPathTo(aShape);
    }

    public void setLineWidth(double width) {
        this.setStroke(new BasicStroke((float)width));
    }

    public void setColor(Color clr) {
        super.setStrokePaint((Paint)clr);
        this.curcolor = clr;
        super.setPaint(null);
    }

    public Paint getColor() {
        return this.curcolor;
    }

    public double getLineWidth() {
        return ((BasicStroke)this.getStroke()).getLineWidth();
    }

    public void setCoords(double x1, double y1, double x2, double y2) {
        this.n1x = x1;
        this.n2x = x2;
        this.n1y = y1;
        this.n2y = y2;
        this.readjust();
    }

    public double getWidth() {
        return Math.max(this.n2x - this.n1x, this.n1x - this.n2x);
    }

    public double getHeight() {
        return Math.max(this.n2y - this.n1y, this.n1y - this.n2y);
    }

    public void readjust() {
        if (!this.loop) {
            if (this.arrows) {
                double[] x1s = new double[]{this.n1x + 0.0, this.n1x + 0.0, this.n1x, this.n1x + 1.0};
                double[] y1s = new double[]{this.n1y, this.n1y + 1.0, this.n1y + 0.0, this.n1y + 0.0};
                double[] x2s = new double[]{this.n2x + 0.0, this.n2x + 0.0, this.n2x, this.n2x + 1.0};
                double[] y2s = new double[]{this.n2y, this.n2y + 1.0, this.n2y + 0.0, this.n2y + 0.0};
                double mindist = Double.MAX_VALUE;
                double x1 = 0.0;
                double y1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                for (int i = 0; i <= 3; ++i) {
                    for (int j = 0; j <= 3; ++j) {
                        double dist = Math.sqrt(Math.pow(x1s[i] - x2s[j], 2.0) + Math.pow(y1s[i] - y2s[j], 2.0));
                        if (!(dist < mindist)) continue;
                        x1 = x1s[i];
                        x2 = x2s[j];
                        y1 = y1s[i];
                        y2 = y2s[j];
                        mindist = dist;
                    }
                }
                this.setShape(new Line2D.Double(x1, y1, x2, y2));
                if (this.destination == 1) {
                    this.arrow_style = 2;
                    this.p1 = new Point2D.Double(x1, y1);
                    this.p2 = new Point2D.Double(x2, y2);
                } else if (this.destination == 2) {
                    this.arrow_style = 1;
                    this.p1 = new Point2D.Double(x1, y1);
                    this.p2 = new Point2D.Double(x2, y2);
                } else if (this.destination == 3) {
                    this.arrow_style = 3;
                    this.p1 = new Point2D.Double(x1, y1);
                    this.p2 = new Point2D.Double(x2, y2);
                }
            } else {
                this.setShape(new Line2D.Double(this.n1x + 0.0, this.n1y + 0.0, this.n2x + 0.0, this.n2y + 0.0));
                this.arrow_style = 0;
                this.p1 = null;
                this.p2 = null;
            }
        } else {
            this.setShape(new Arc2D.Double(this.n1x, this.n1y, this.n2x - this.n1x, this.n2y - this.n1y, 20.0, 200.0, 0));
            this.arrow_style = 0;
            this.p1 = null;
            this.p2 = null;
        }
    }

    public void paint(PPaintContext apc) {
        super.paint(apc);
        if (this.arrow_style == 0) {
            return;
        }
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        Graphics2D g2 = apc.getGraphics();
        if (this.arrow_style == 3) {
            Arrow.drawArrow(g2, this.p1, this.p2, 2, this.getLineWidth());
            Arrow.drawArrow(g2, this.p2, this.p1, 2, this.getLineWidth());
        } else if (this.arrow_style == 1) {
            Arrow.drawArrow(g2, this.p2, this.p1, 2, this.getLineWidth());
        } else if (this.arrow_style == 2) {
            Arrow.drawArrow(g2, this.p1, this.p2, 2, this.getLineWidth());
        }
    }
}

