/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.UndirectedEdge;
import com.hp.hpl.guess.piccolo.Arrow;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.piccolo.LabelText;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.EdgeListener;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.InfoWindow;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class GuessPEdge
extends PPath
implements EdgeListener {
    private Edge owner = null;
    private GFrame frame = null;
    private Color labelColor = null;
    Color curcolor = Color.black;
    private boolean mouseOver = false;
    private static LabelText labelText = new LabelText(new Point2D.Double(0.0, 0.0));
    private int arrow_style = 0;
    private Point2D p1 = null;
    private Point2D p2 = null;
    private boolean labelVisible = false;
    private String label = "";
    private String[] multiLineLabel = null;
    private double labelX = 0.0;
    private double labelY = 0.0;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_START = 1;
    public static final int ARROW_END = 2;
    public static final int ARROW_BOTH = 3;

    public Edge getOwner() {
        return this.owner;
    }

    @Override
    public void set(String field, Object o) {
        try {
            if (field.equals("width")) {
                this.setLineWidth((Double)o);
            } else if (field.equals("color")) {
                if (o instanceof Color) {
                    this.setColor((Color)o);
                } else {
                    this.setColor(Colors.getColor((String)o, (Color)this.getColor()));
                }
            } else if (field.equals("visible")) {
                this.setVisible((Boolean)o);
                if (this.getVisible()) {
                    this.readjust();
                }
            } else if (field.equals("label")) {
                this.setLabel((String)o);
            } else if (field.equals("labelvisible")) {
                this.setLabelVisible((Boolean)o);
            } else if (field.equals("labelcolor")) {
                this.labelColor = o instanceof Color ? (Color)o : Colors.getColor((String)o, (Color)this.getColor());
            }
            if (Guess.getMTF()) {
                this.moveToFront();
            }
        }
        catch (Exception e) {
            throw new Error("Problem with setting rep attribute: " + field + " " + e.toString());
        }
    }

    @Override
    public Object get(String field) {
        try {
            if (field.equals("width")) {
                return new Double(this.getLineWidth());
            }
            if (field.equals("color")) {
                return Colors.toString((Color)this.getColor());
            }
            if (field.equals("labelcolor")) {
                if (this.labelColor != null) {
                    return Colors.toString(this.labelColor);
                }
                return Colors.toString((Color)this.getColor());
            }
            if (field.equals("visible")) {
                return new Boolean(this.getVisible());
            }
            if (field.equals("label")) {
                return this.label;
            }
            if (field.equals("labelvisible")) {
                return new Boolean(this.labelVisible);
            }
            return null;
        }
        catch (Exception e) {
            throw new Error("Problem with getting rep attribute: " + e.toString());
        }
    }

    public GuessPEdge(Edge owner, GFrame frame) {
        this.owner = owner;
        this.frame = frame;
        this.readjust();
    }

    public GuessPEdge(Shape aShape, Edge owner, GFrame frame) {
        super(aShape);
        this.owner = owner;
        this.frame = frame;
        super.setPaint(null);
    }

    public void setShape(Shape aShape) {
        this.setPathTo(aShape);
    }

    public void setLineWidth(double width) {
        this.setStroke(new BasicStroke((float)width));
        this.readjust();
    }

    public void setColor(Color clr) {
        super.setStrokePaint((Paint)clr);
        this.curcolor = clr;
        super.setPaint(null);
    }

    @Override
    public void highlight(boolean state) {
        if (!this.getVisible()) {
            return;
        }
        if (state) {
            this.mouseOver = true;
            InfoWindow.details(this.owner);
            this.setStrokePaint(Color.yellow);
            String ownerName = null;
            if (this.owner instanceof UndirectedEdge) {
                Node n2;
                Node n1 = this.owner.getNode1();
                if (n1 != (n2 = this.owner.getNode2())) {
                    ((GuessPNode)n1.getRep()).highlight(true);
                    ((GuessPNode)n2.getRep()).highlight(true);
                    ownerName = n1 + " - " + n2;
                } else {
                    ((GuessPNode)n2.getRep()).highlight(true);
                    ownerName = n1 + " self loop";
                }
            } else {
                Node n2;
                Node n1 = (Node)((DirectedEdge)this.owner).getSource();
                if (n1 != (n2 = (Node)((DirectedEdge)this.owner).getDest())) {
                    ((GuessPNode)n1.getRep()).highlight(true);
                    ((GuessPNode)n2.getRep()).highlight(true);
                    ownerName = n1 + " -> " + n2;
                } else {
                    ((GuessPNode)n2.getRep()).highlight(true);
                    ownerName = n1 + " -> self loop";
                }
            }
            if (this.label != null && this.label.equals(ownerName)) {
                StatusBar.setStatus(this.label);
            } else if (this.label == null) {
                StatusBar.setStatus(ownerName);
            } else {
                StatusBar.setStatus(ownerName + " (" + this.label + ")");
            }
        } else {
            this.mouseOver = false;
            this.setStrokePaint(this.curcolor);
            ArrayList l = new ArrayList(this.owner.getIncidentVertices());
            Node n1 = (Node)l.get(0);
            ((GuessPNode)n1.getRep()).highlight(false);
            if (l.size() > 1) {
                n1 = (Node)l.get(1);
                ((GuessPNode)n1.getRep()).highlight(false);
            }
            StatusBar.setStatus("");
        }
    }

    public void mouseEntered(PInputEvent aEvent) {
        if (this.getVisible()) {
            GraphEvents.mouseEnter(this.owner);
        }
    }

    public void mouseExited(PInputEvent aEvent) {
        if (this.getVisible()) {
            GraphEvents.mouseLeave(this.owner);
        }
    }

    public Paint getColor() {
        return this.curcolor;
    }

    public double getLineWidth() {
        return ((BasicStroke)this.getStroke()).getLineWidth();
    }

    public void mouseClicked(PInputEvent aEvent) {
        if (aEvent.isLeftMouseButton() && this.frame.getMode() == 0) {
            if (aEvent.isShiftDown()) {
                GraphEvents.shiftClick(this.owner);
            } else {
                GraphEvents.click(this.owner);
            }
        }
    }

    public void centerDisplay() {
        Node node1;
        ArrayList l = new ArrayList(this.owner.getIncidentVertices());
        Node node2 = node1 = (Node)l.get(0);
        if (l.size() > 1) {
            node2 = (Node)l.get(1);
        }
        if (node1 == node2) {
            this.frame.centerOn((GuessPNode)node1.getRep());
        } else {
            this.frame.centerOn((GuessPNode)node1.getRep(), (GuessPNode)node2.getRep());
        }
    }

    public void highlightOld(boolean state) {
        if (labelText.getParent() == null) {
            this.frame.labels.addChild((PNode)labelText);
        }
        if (state) {
            if (this.owner instanceof UndirectedEdge) {
                labelText.setText(((UndirectedEdge)this.owner).getNode1() + "-" + ((UndirectedEdge)this.owner).getNode2());
            } else {
                labelText.setText(((DirectedEdge)this.owner).getSource() + "->" + ((DirectedEdge)this.owner).getDest());
            }
            labelText.setPaint(new Color(100, 100, 100, 210));
            labelText.setTextPaint(Color.yellow);
            labelText.setVisible(true);
        } else {
            labelText.setVisible(false);
        }
    }

    private static void findEndPoints(GuessPNode node1, GuessPNode node2, Point2D pa, Point2D pb) {
        Point2D[] n1 = null;
        Point2D[] n2 = null;
        double transform1 = -(node1.getX() + node1.getWidth() / 2.0);
        double transform2 = -(node1.getY() + node1.getHeight() / 2.0);
        double testx = node2.getX() + node2.getWidth() / 2.0 + transform1;
        double testy = node2.getY() + node2.getHeight() / 2.0 + transform2;
        double angle = Math.sqrt(Math.pow(Math.toDegrees(Math.atan2(testy, testx)), 2.0));
        if (angle < 30.0 || angle > 150.0 || angle > 60.0 && angle < 120.0) {
            n1 = node1.getPrefPorts();
            n2 = node2.getPrefPorts();
        } else {
            n1 = node1.getAllPorts();
            n2 = node2.getAllPorts();
        }
        double mindist = Double.MAX_VALUE;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        for (int i = 0; i < n1.length; ++i) {
            for (int j = 0; j < n1.length; ++j) {
                double dist = Math.sqrt(Math.pow(n1[i].getX() - n2[j].getX(), 2.0) + Math.pow(n1[i].getY() - n2[j].getY(), 2.0));
                if (!(dist < mindist)) continue;
                x1 = n1[i].getX();
                x2 = n2[j].getX();
                y1 = n1[i].getY();
                y2 = n2[j].getY();
                mindist = dist;
            }
        }
        pa.setLocation(x1, y1);
        pb.setLocation(x2, y2);
    }

    @Override
    public void readjust() {
        GuessPNode node1;
        ArrayList l = new ArrayList(this.owner.getIncidentVertices());
        GuessPNode node2 = node1 = (GuessPNode)((Node)l.get(0)).getRep();
        if (l.size() > 1) {
            node2 = (GuessPNode)((Node)l.get(1)).getRep();
        }
        if (node1 != node2) {
            if (VisFactory.getFactory().getDirected()) {
                Point2D.Double pa = new Point2D.Double(0.0, 0.0);
                Point2D.Double pb = new Point2D.Double(0.0, 0.0);
                GuessPEdge.findEndPoints(node1, node2, pa, pb);
                double x1 = ((Point2D)pa).getX();
                double y1 = ((Point2D)pa).getY();
                double x2 = ((Point2D)pb).getX();
                double y2 = ((Point2D)pb).getY();
                if (VisFactory.getFactory().getDirected()) {
                    double cx = (x1 + x2) / 2.0;
                    double cy = (y1 + y2) / 2.0;
                    double thetaRadians = Math.atan2(y1 - y2, x1 - x2);
                    double buffer = Math.max(2.0, Arrow.getArrowLength(x1, y1, x2, y2, this.getLineWidth()) / 2.0);
                    double radius = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0)) / 2.0 - buffer;
                    double tx1 = radius * Math.cos(thetaRadians) + cx;
                    double ty1 = radius * Math.sin(thetaRadians) + cy;
                    double tx2 = radius * Math.cos(thetaRadians += Math.PI) + cx;
                    double ty2 = radius * Math.sin(thetaRadians) + cy;
                    this.setShape(new Line2D.Double(tx1, ty1, tx2, ty2));
                } else {
                    this.setShape(new Line2D.Double(x1, y1, x2, y2));
                }
                if (this.owner instanceof DirectedEdge) {
                    if (((Node)((DirectedEdge)this.owner).getSource()).getRep() == node1) {
                        this.arrow_style = 2;
                        this.p1 = new Point2D.Double(x1, y1);
                        this.p2 = new Point2D.Double(x2, y2);
                    } else {
                        this.arrow_style = 1;
                        this.p1 = new Point2D.Double(x1, y1);
                        this.p2 = new Point2D.Double(x2, y2);
                    }
                } else if (this.owner instanceof UndirectedEdge) {
                    this.arrow_style = 3;
                    this.p1 = new Point2D.Double(x1, y1);
                    this.p2 = new Point2D.Double(x2, y2);
                }
                if (this.labelVisible) {
                    double slope;
                    this.labelX = (x1 + x2) / 2.0 + 2.0;
                    this.labelY = x1 != x2 ? ((slope = (y1 - y2) / (x1 - x2)) >= -0.5 && slope <= 0.0 ? (y1 + y2) / 2.0 + 2.0 : (slope > 0.0 && slope <= 0.5 ? (y1 + y2) / 2.0 - 2.0 : (y1 + y2) / 2.0)) : (y1 + y2) / 2.0;
                }
            } else {
                double lx1 = node1.getX() + node1.getWidth() / 2.0;
                double ly1 = node1.getY() + node1.getHeight() / 2.0;
                double lx2 = node2.getX() + node2.getWidth() / 2.0;
                double ly2 = node2.getY() + node2.getHeight() / 2.0;
                this.setShape(new Line2D.Double(lx1, ly1, lx2, ly2));
                if (this.labelVisible) {
                    double slope;
                    this.labelX = (lx1 + lx2) / 2.0 + 2.0;
                    this.labelY = lx1 != lx2 ? ((slope = (ly1 - ly2) / (lx1 - lx2)) >= -0.5 && slope <= 0.0 ? (ly1 + ly2) / 2.0 + 2.0 : (slope > 0.0 && slope <= 0.5 ? (ly1 + ly2) / 2.0 - 2.0 : (ly1 + ly2) / 2.0)) : (ly1 + ly2) / 2.0;
                }
                this.arrow_style = 0;
                this.p1 = null;
                this.p2 = null;
            }
        } else {
            double x1 = node1.getX() + node1.getWidth() / 2.0;
            double y1 = node1.getY() + node1.getHeight() / 2.0;
            double size = Math.max(node1.getHeight(), node1.getWidth());
            this.setShape(new Ellipse2D.Double(x1 - size, y1 - size, size, size));
            if (this.labelVisible) {
                this.labelX = x1 - size / 2.0;
                this.labelY = y1 - size / 2.0 - 1.0;
            }
            this.arrow_style = 0;
            this.p1 = null;
            this.p2 = null;
        }
    }

    public void readjustJiggle(boolean upd) {
        GuessPNode node1;
        ArrayList l = new ArrayList(this.owner.getIncidentVertices());
        GuessPNode node2 = node1 = (GuessPNode)((Node)l.get(0)).getRep();
        if (l.size() > 1) {
            node2 = (GuessPNode)((Node)l.get(1)).getRep();
        }
        if (node1 != node2) {
            if (VisFactory.getFactory().getDirected()) {
                Point2D.Double pa = new Point2D.Double(0.0, 0.0);
                Point2D.Double pb = new Point2D.Double(0.0, 0.0);
                GuessPEdge.findEndPoints(node1, node2, pa, pb);
                double x1 = ((Point2D)pa).getX();
                double y1 = ((Point2D)pa).getY();
                double x2 = ((Point2D)pb).getX();
                double y2 = ((Point2D)pb).getY();
                this.setShapeJiggle(x1, y1, x2, y2, upd);
                if (this.owner instanceof DirectedEdge) {
                    if (((Node)((DirectedEdge)this.owner).getSource()).getRep() == node1) {
                        this.arrow_style = 2;
                        this.p1 = new Point2D.Double(x1, y1);
                        this.p2 = new Point2D.Double(x2, y2);
                    } else {
                        this.arrow_style = 1;
                        this.p1 = new Point2D.Double(x1, y1);
                        this.p2 = new Point2D.Double(x2, y2);
                    }
                } else if (this.owner instanceof UndirectedEdge) {
                    this.arrow_style = 3;
                    this.p1 = new Point2D.Double(x1, y1);
                    this.p2 = new Point2D.Double(x2, y2);
                }
            } else {
                this.setShapeJiggle(node1.getX() + node1.getWidth() / 2.0, node1.getY() + node1.getHeight() / 2.0, node2.getX() + node2.getWidth() / 2.0, node2.getY() + node2.getHeight() / 2.0, upd);
                this.arrow_style = 0;
                this.p1 = null;
                this.p2 = null;
            }
        }
    }

    private void setShapeJiggle(double x1, double y1, double x2, double y2, boolean upd) {
        double s = 0.0;
        s = y2 == y1 ? (upd ? 1.0 / (1.0 / (x2 - x1)) : 1.0 / (-1.0 / (x2 - x1))) : 1.0 / ((y2 - y1) / (x2 - x1));
        double x3 = (x1 + x2) / 2.0;
        double y3 = (y1 + y2) / 2.0;
        double dist = Math.min(4.0, Point2D.distance(x1, y1, x2, y2) / 8.0);
        double a = s * s + 1.0;
        double b = -(2.0 + 2.0 * s * s) * x3;
        double c = x3 * x3 + s * s * x3 * x3 - dist * dist;
        double x41 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        double x42 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        double y41 = y3 + s * (x3 - x41);
        double y42 = y3 + s * (x3 - x42);
        if (upd) {
            this.setShape(new QuadCurve2D.Double(x1, y1, x41, y41, x2, y2));
        } else {
            this.setShape(new QuadCurve2D.Double(x1, y1, x42, y42, x2, y2));
        }
    }

    public void setLabel(String str) {
        if (str == null) {
            str = "";
        }
        this.label = str;
        this.multiLineLabel = this.label.indexOf("\n") >= 0 ? GuessPEdge.breakupLines(str) : null;
    }

    public void setLabelVisible(boolean state) {
        this.labelVisible = state;
        if (state && (this.label == null || this.label.equals(""))) {
            this.label = "" + this.owner.edgeWeight();
        }
        this.readjust();
    }

    public static String[] breakupLines(String text) {
        String[] toRet = null;
        StringTokenizer st = new StringTokenizer(text, "\n");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        toRet = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            toRet[i] = (String)v.elementAt(i);
        }
        return toRet;
    }

    public void paintLabel(Graphics2D g, float labelX, float labelY, Font font) {
        Color cur = g.getColor();
        if (this.labelColor != null) {
            g.setColor(this.labelColor);
        }
        if (this.multiLineLabel == null) {
            g.drawString(this.label, labelX, labelY);
            g.setColor(cur);
            return;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        int num_lines = this.multiLineLabel.length;
        int i = 0;
        float height = labelY;
        while (i < num_lines) {
            g.drawString(this.multiLineLabel[i], labelX, height);
            ++i;
            height += (float)fontHeight;
        }
        g.setColor(cur);
    }

    public void paint(PPaintContext apc) {
        super.paint(apc);
        Graphics2D g2 = apc.getGraphics();
        if (this.labelVisible) {
            if (this.mouseOver) {
                g2.setPaint(Color.yellow);
            } else {
                g2.setPaint(this.curcolor);
            }
            float scaling = (float)(1.0 / this.frame.getGCamera().getViewScale());
            Font f = g2.getFont();
            f = f.deriveFont(12.0f * scaling);
            if (Guess.getDefaultFont() != null && !f.getFamily().equals(Guess.getDefaultFont())) {
                f = new Font(Guess.getDefaultFont(), f.getStyle(), f.getSize());
            }
            g2.setFont(f);
            this.paintLabel(g2, (float)this.labelX, (float)this.labelY, f);
        }
        if (this.arrow_style == 0) {
            return;
        }
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        if (this.arrow_style == 3) {
            Arrow.drawArrow(g2, this.p1, this.p2, 2, this.getLineWidth());
            Arrow.drawArrow(g2, this.p2, this.p1, 2, this.getLineWidth());
        } else if (this.arrow_style == 1) {
            Arrow.drawArrow(g2, this.p2, this.p1, 2, this.getLineWidth());
        } else if (this.arrow_style == 2) {
            Arrow.drawArrow(g2, this.p1, this.p2, 2, this.getLineWidth());
        }
    }
}

