/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.GuessShapeNode3D;
import com.hp.hpl.guess.piccolo.LabelText;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ShapeDB;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class GuessShape3DLegendNode
extends PPath {
    private int style = 1;
    private Paint gradPaint = null;
    private Color flatColor = null;
    Color curcolor = null;
    private String label = "";
    private LabelText labelText = null;
    private boolean highlightMode = false;
    private boolean labelMode = false;
    private static BasicStroke linestroke = new BasicStroke(0.3f);

    public int getStyle() {
        return this.style;
    }

    private void setGradPaint() {
        if (this.flatColor == null) {
            return;
        }
        float p1x = (float)(this.getX() + this.getWidth() / 8.0);
        float p1y = (float)(this.getY() + this.getHeight() / 8.0);
        float p2x = (float)(this.getX() + this.getWidth());
        float p2y = (float)(this.getY() + this.getHeight());
        this.gradPaint = new GradientPaint(p1x, p1y, Color.white, p2x, p2y, this.flatColor);
        this.setPaint(this.gradPaint);
    }

    public boolean setBounds(double x1, double y1, double width, double height) {
        boolean newB = super.setBounds(x1, y1, width, height);
        this.setGradPaint();
        return newB;
    }

    public boolean setBounds(Rectangle2D newBounds) {
        boolean newB = super.setBounds(newBounds);
        this.setGradPaint();
        return newB;
    }

    public GuessShape3DLegendNode(Node owner) {
        GuessShapeNode3D gsn = (GuessShapeNode3D)owner.getRep();
        this.style = gsn.getStyle();
        double width = gsn.getWidth();
        double height = gsn.getHeight();
        if (this.style == 8) {
            this.append(new Rectangle2D.Double(0.0, 0.0, width, height), false);
        } else if (this.style == 9) {
            this.append(new Ellipse2D.Double(0.0, 0.0, width, height), false);
        } else if (this.style == 10) {
            this.append(new RoundRectangle2D.Double(0.0, 0.0, width, height, 2.0, 2.0), false);
        } else if (this.style > 100) {
            Shape s = ShapeDB.getShapeDB().getShape(this.style);
            if (s == null) {
                this.append(new Rectangle2D.Double(0.0, 0.0, width, height), false);
            } else {
                this.append(s, false);
                this.setLocation(0.0, 0.0, width, height);
            }
        }
        this.gradPaint = gsn.gradPaint;
        this.flatColor = gsn.flatColor;
        this.setGradPaint();
        this.setStrokePaint(gsn.getStrokePaint());
    }

    public void setPaint(Color c) {
        Color oldcolor = (Color)this.getPaint();
        super.setPaint((Paint)c);
        this.curcolor = c;
        if (oldcolor != null && oldcolor.getAlpha() != this.curcolor.getAlpha()) {
            Color oldSP = (Color)this.getStrokePaint();
            this.setStrokePaint(Colors.getColor(oldSP.getRed() + "," + oldSP.getGreen() + "," + oldSP.getBlue() + "," + this.curcolor.getAlpha(), oldSP));
        }
    }

    public void setColor(Color c) {
        this.setPaint(c);
    }

    public void setShape(int type) {
    }

    public void setShape(Shape shp, int type) {
        this.style = type;
        this.setPathTo(shp);
    }

    public void setLabel(String str) {
        this.label = str;
    }

    public void setLocation(double x1, double y1, double width, double height) {
        this.setBounds(x1, y1, width, height);
    }

    public void setLocation(double x1, double y1) {
        double w = super.getWidth();
        double h = super.getHeight();
        this.setBounds(x1, y1, w, h);
    }

    public void setSize(double width, double height) {
        double x = super.getX();
        double y = super.getY();
        this.setBounds(x, y, width, height);
    }

    public void paint(PPaintContext apc) {
        Graphics2D g2 = apc.getGraphics();
        g2.setPaint(GuessShapeNode3D.shadow);
        int shadowOffset = GuessShapeNode3D.shadowOffset;
        if (this.style == 8) {
            g2.fillRect((int)this.getX() + shadowOffset, (int)this.getY() + shadowOffset, (int)this.getWidth(), (int)this.getHeight());
        } else if (this.style == 9) {
            g2.fillOval((int)this.getX() + shadowOffset, (int)this.getY() + shadowOffset, (int)this.getWidth(), (int)this.getHeight());
        } else if (this.style == 10) {
            g2.fillRoundRect((int)this.getX() + shadowOffset, (int)this.getY() + shadowOffset, (int)this.getWidth(), (int)this.getHeight(), 2, 2);
        }
        g2.setStroke(linestroke);
        super.paint(apc);
    }

    public double getDrawWidth() {
        return this.getWidth();
    }

    public double getDrawHeight() {
        return this.getHeight();
    }
}

