/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessShapeNode;
import com.hp.hpl.guess.piccolo.LabelText;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ShapeDB;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class GuessShapeLegendNode
extends PPath {
    private int style = 1;
    Color curcolor = null;
    private String label = "";
    private LabelText labelText = null;
    private boolean highlightMode = false;
    private boolean labelMode = false;
    private static BasicStroke linestroke = new BasicStroke(0.3f);

    public int getStyle() {
        return this.style;
    }

    public GuessShapeLegendNode(Node owner) {
        GuessShapeNode gsn = (GuessShapeNode)owner.getRep();
        int type = gsn.getStyle();
        double width = gsn.getWidth();
        double height = gsn.getHeight();
        if (type == 1) {
            this.append(new Rectangle2D.Double(0.0, 0.0, width, height), false);
        } else if (type == 2) {
            this.append(new Ellipse2D.Double(0.0, 0.0, width, height), false);
        } else if (type == 3) {
            this.append(new RoundRectangle2D.Double(0.0, 0.0, width, height, 2.0, 2.0), false);
        } else if (type > 100) {
            Shape s = ShapeDB.getShapeDB().getShape(type);
            if (s == null) {
                this.append(new Rectangle2D.Double(0.0, 0.0, width, height), false);
            } else {
                this.append(s, false);
                this.setLocation(0.0, 0.0, width, height);
            }
        }
        this.setStrokePaint(gsn.getStrokePaint());
        this.setPaint(gsn.getPaint());
    }

    public boolean setBounds(Rectangle2D newBounds) {
        boolean toRet = super.setBounds(newBounds);
        return toRet;
    }

    public void setPaint(Color c) {
        Color oldcolor = (Color)this.getPaint();
        super.setPaint((Paint)c);
        this.curcolor = c;
        if (oldcolor != null && oldcolor.getAlpha() != this.curcolor.getAlpha()) {
            Color oldSP = (Color)this.getStrokePaint();
            this.setStrokePaint(Colors.getColor(oldSP.getRed() + "," + oldSP.getGreen() + "," + oldSP.getBlue() + "," + this.curcolor.getAlpha(), oldSP));
        }
    }

    public void setColor(Color c) {
        this.setPaint(c);
    }

    public void setShape(int type) {
    }

    public void setShape(Shape shp, int type) {
        this.style = type;
        this.setPathTo(shp);
    }

    public void setLabel(String str) {
        this.label = str;
    }

    public void setLocation(double x1, double y1, double width, double height) {
        this.setBounds(x1, y1, width, height);
    }

    public void setLocation(double x1, double y1) {
        double w = super.getWidth();
        double h = super.getHeight();
        this.setBounds(x1, y1, w, h);
    }

    public void setSize(double width, double height) {
        double x = super.getX();
        double y = super.getY();
        this.setBounds(x, y, width, height);
    }

    public void paint(PPaintContext apc) {
        Graphics2D g2 = apc.getGraphics();
        if (this.labelMode) {
            float scaling = (float)(1.0 / ((GFrame)VisFactory.getFactory().getDisplay()).getGCamera().getViewScale());
            Font f = g2.getFont();
            f = f.deriveFont(12.0f * scaling);
            g2.setFont(f);
            g2.setPaint(this.curcolor);
            g2.drawString(this.label, (float)(this.getX() + this.getWidth() + 1.0), (float)(this.getY() + this.getHeight()));
        }
        g2.setStroke(linestroke);
        super.paint(apc);
    }

    public double getDrawWidth() {
        return this.getWidth();
    }

    public double getDrawHeight() {
        return this.getHeight();
    }
}

