/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.ConvexHullNode;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.piccolo.LabelText;
import com.hp.hpl.guess.piccolo.PFactory;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.NodeListener;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class GuessShapeNode
extends PPath
implements GuessPNode {
    protected Node owner = null;
    protected GFrame frame = null;
    protected int style = 1;
    protected Color labelColor = null;
    Color curcolor = null;
    protected String label = "";
    protected String[] multiLineLabel = null;
    protected LabelText labelText = null;
    protected boolean highlightMode = false;
    protected boolean labelMode = false;
    protected static BasicStroke linestroke = new BasicStroke(3.0f);
    public static int ZOOM_SIZE = 40;
    public HashSet hulls = null;

    @Override
    public Node getOwner() {
        return this.owner;
    }

    @Override
    public void set(String field, Object o) {
        if (field.equals("style")) {
            this.setStyle((Integer)o);
        } else if (field.equals("x")) {
            this.setLocation((Double)o, this.getY());
        } else if (field.equals("y")) {
            this.setLocation(this.getX(), (Double)o);
        } else if (field.equals("width")) {
            this.setLocation(this.getX(), this.getY(), (Double)o, this.getHeight());
        } else if (field.equals("height")) {
            this.setLocation(this.getX(), this.getY(), this.getWidth(), (Double)o);
        } else if (field.equals("label")) {
            this.setLabel((String)o);
        } else if (field.equals("labelvisible")) {
            this.setLabelVisible((Boolean)o);
        } else if (field.equals("color")) {
            if (o instanceof Color) {
                this.setPaint((Color)o);
            } else {
                this.setPaint(Colors.getColor((String)o, (Color)this.getPaint()));
            }
        } else if (field.equals("labelcolor")) {
            if (o instanceof Color) {
                this.setLabelPaint((Color)o);
            } else {
                this.setLabelPaint(Colors.getColor((String)o, (Color)this.getPaint()));
            }
        } else if (field.equals("visible")) {
            this.setVisible((Boolean)o);
        } else if (field.equals("strokecolor")) {
            if (o instanceof Color) {
                this.setStrokePaint((Color)o);
            } else {
                this.setStrokePaint(Colors.getColor((String)o, (Color)this.getPaint()));
            }
        }
        if (Guess.getMTF()) {
            this.moveToFront();
        }
    }

    public void setLabelPaint(Color c) {
        this.labelColor = c;
    }

    @Override
    public Object get(String field) {
        try {
            if (field.equals("style")) {
                return new Integer(this.style);
            }
            if (field.equals("x")) {
                return new Double(this.getX());
            }
            if (field.equals("y")) {
                return new Double(this.getY());
            }
            if (field.equals("width")) {
                return new Double(this.getWidth());
            }
            if (field.equals("height")) {
                return new Double(this.getHeight());
            }
            if (field.equals("label")) {
                return this.label;
            }
            if (field.equals("labelvisible")) {
                return new Boolean(this.labelMode);
            }
            if (field.equals("color")) {
                return Colors.toString(this.curcolor);
            }
            if (field.equals("labelcolor")) {
                if (this.labelColor != null) {
                    return Colors.toString(this.labelColor);
                }
                return Colors.toString(this.curcolor);
            }
            if (field.equals("strokecolor")) {
                return Colors.toString((Color)this.getStrokePaint());
            }
            if (field.equals("visible")) {
                return new Boolean(this.getVisible());
            }
            return null;
        }
        catch (Exception e) {
            throw new Error("Problem with getting rep attribute: " + field + " " + e.toString());
        }
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(int s) {
        if (s > 100 || s != this.style) {
            NodeListener rep = ((PFactory)VisFactory.getFactory()).convertNode(this, s, this.owner);
            this.owner.setRep(rep);
            this.owner.readjustEdges();
        }
    }

    public GuessShapeNode(Shape aShape, Node owner, GFrame frame, int style) {
        super(aShape);
        this.owner = owner;
        this.frame = frame;
        this.style = style;
        this.label = owner.getName();
    }

    public boolean setBounds(Rectangle2D newBounds) {
        boolean toRet = super.setBounds(newBounds);
        this.owner.readjustEdges();
        return toRet;
    }

    public void setPaint(Color c) {
        Color oldcolor = (Color)this.getPaint();
        super.setPaint((Paint)c);
        this.curcolor = c;
        if (oldcolor != null && oldcolor.getAlpha() != this.curcolor.getAlpha()) {
            Color oldSP = (Color)this.getStrokePaint();
            this.setStrokePaint(Colors.getColor(oldSP.getRed() + "," + oldSP.getGreen() + "," + oldSP.getBlue() + "," + this.curcolor.getAlpha(), oldSP));
        }
    }

    @Override
    public void setColor(Color c) {
        this.setPaint(c);
    }

    public void setShape(int type) {
    }

    @Override
    public void setShape(Shape shp, int type) {
        this.style = type;
        this.setPathTo(shp);
    }

    public void setLabel(String str) {
        this.label = str;
        if (this.label != null) {
            this.multiLineLabel = this.label.indexOf("\n") >= 0 ? GuessShapeNode.breakupLines(str) : null;
        }
    }

    @Override
    public void setLocation(double x1, double y1, double width, double height) {
        this.setBounds(x1, y1, width, height);
        this.owner.readjustEdges();
        this.notifyHullListeners();
    }

    @Override
    public void setLocation(double x1, double y1) {
        double w = super.getWidth();
        double h = super.getHeight();
        this.setBounds(x1, y1, w, h);
        this.owner.readjustEdges();
        this.notifyHullListeners();
    }

    public void setSize(double width, double height) {
        double x = super.getX();
        double y = super.getY();
        this.setBounds(x, y, width, height);
    }

    @Override
    public void mouseEntered(PInputEvent aEvent) {
        if (this.getVisible()) {
            GraphEvents.mouseEnter(this.owner);
        }
    }

    @Override
    public void mouseExited(PInputEvent aEvent) {
        if (this.getVisible()) {
            GraphEvents.mouseLeave(this.owner);
        }
    }

    @Override
    public void highlight(boolean state) {
        if (!this.getVisible()) {
            return;
        }
        if (this.labelText == null) {
            this.labelText = new LabelText(this);
        }
        if (state) {
            super.setPaint((Paint)Color.yellow);
            this.labelText.setText(this.label);
            this.labelText.setPaint(new Color(100, 100, 100, 210));
            this.labelText.setTextPaint(Color.yellow);
            float scaling = (float)(1.0 / this.frame.getGCamera().getViewScale());
            this.labelText.setX(this.getX() + this.getWidth() + (double)(1.0f * scaling));
            this.labelText.setY(this.getY() + this.getHeight());
            this.frame.labels.addChild((PNode)this.labelText);
            if (this.label != null && this.label.equals(this.owner.getName())) {
                StatusBar.setStatus(this.label);
            } else if (this.label == null) {
                StatusBar.setStatus(this.owner.getName());
            } else {
                StatusBar.setStatus(this.owner.getName() + " (" + this.label + ")");
            }
        } else {
            super.setPaint((Paint)this.curcolor);
            this.labelText.removeFromParent();
            StatusBar.setStatus("");
        }
        this.highlightMode = state;
    }

    public void setLabelVisible(boolean state) {
        this.labelMode = state;
        if (state && (this.label == null || this.label.equals(""))) {
            this.label = this.owner.getName();
        }
    }

    public static String[] breakupLines(String text) {
        String[] toRet = null;
        StringTokenizer st = new StringTokenizer(text, "\n");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        toRet = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            toRet[i] = (String)v.elementAt(i);
        }
        return toRet;
    }

    public void paintLabel(Graphics2D g, float labelX, float labelY, Font font) {
        if (this.labelColor != null) {
            g.setPaint(this.labelColor);
        }
        if (this.multiLineLabel == null) {
            g.drawString(this.label, labelX, labelY);
            return;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        int num_lines = this.multiLineLabel.length;
        int i = 0;
        float height = labelY;
        while (i < num_lines) {
            g.drawString(this.multiLineLabel[i], labelX, height);
            ++i;
            height += (float)fontHeight;
        }
    }

    public void paintOverload(PPaintContext apc) {
        Graphics2D g2 = apc.getGraphics();
        if (this.labelMode) {
            float scaling = (float)(1.0 / this.frame.getGCamera().getViewScale());
            Font f = g2.getFont();
            f = f.deriveFont(12.0f * scaling);
            if (Guess.getDefaultFont() != null && !f.getFamily().equals(Guess.getDefaultFont())) {
                f = new Font(Guess.getDefaultFont(), f.getStyle(), f.getSize());
            }
            g2.setFont(f);
            g2.setPaint(this.curcolor);
            this.paintLabel(g2, (float)(this.getX() + this.getWidth() + 2.0), (float)(this.getY() + this.getHeight()), f);
        }
        g2.setStroke(linestroke);
    }

    public void paint(PPaintContext apc) {
        this.paintOverload(apc);
        super.paint(apc);
    }

    @Override
    public double getDrawWidth() {
        return this.getWidth();
    }

    @Override
    public double getDrawHeight() {
        return this.getHeight();
    }

    @Override
    public void moveDone(double x, double y) {
        this.owner.endMove(x, y);
        this.notifyHullListeners();
    }

    @Override
    public void inTransition(double x, double y) {
        this.owner.move(x, y);
        this.hideHullListeners();
    }

    public void keyTyped(PInputEvent aEvent) {
        System.out.println("" + aEvent.getKeyChar());
    }

    @Override
    public void mouseClicked(PInputEvent aEvent) {
        if (aEvent.isLeftMouseButton() && this.frame.getMode() == 0) {
            if (aEvent.isShiftDown()) {
                GraphEvents.shiftClick(this.owner);
            } else {
                GraphEvents.click(this.owner);
            }
        }
    }

    @Override
    public void centerDisplay() {
        this.frame.centerOn(this);
    }

    @Override
    public void addHullListener(ConvexHullNode chn) {
        if (this.hulls == null) {
            this.hulls = new HashSet();
        }
        this.hulls.add(chn);
    }

    @Override
    public void removeHullListener(ConvexHullNode chn) {
        if (this.hulls != null) {
            this.hulls.remove(chn);
        }
    }

    private void notifyHullListeners() {
        if (this.hulls != null) {
            for (ConvexHullNode chn : this.hulls) {
                chn.setVisible(true);
                chn.nodeMoved((PNode)this);
            }
        }
    }

    private void hideHullListeners() {
        if (this.hulls != null) {
            for (ConvexHullNode chn : this.hulls) {
                chn.setVisible(false);
            }
        }
    }

    @Override
    public Point2D[] getAllPorts() {
        Point2D[] toRet = new Point2D[]{new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY()), new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight()), new Point2D.Double(this.getX(), this.getY() + this.getHeight() / 2.0), new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0), new Point2D.Double(this.getX(), this.getY()), new Point2D.Double(this.getX() + this.getWidth(), this.getY()), new Point2D.Double(this.getX(), this.getY() + this.getHeight()), new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight())};
        return toRet;
    }

    @Override
    public Point2D[] getPrefPorts() {
        Point2D[] toRet = new Point2D[]{new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY()), new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight()), new Point2D.Double(this.getX(), this.getY() + this.getHeight() / 2.0), new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0)};
        return toRet;
    }
}

