/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessShapeNode;
import com.hp.hpl.guess.piccolo.LabelText;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.StatusBar;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class GuessShapeNode3D
extends GuessShapeNode {
    public static int shadowOffset = 2;
    protected Color flatColor = null;
    protected Paint gradPaint = null;
    protected static final Color shadow = new Color(125, 125, 125, 125);

    public GuessShapeNode3D(Shape aShape, Node owner, GFrame frame, int style) {
        super(aShape, owner, frame, style);
    }

    @Override
    public void set(String field, Object o) {
        if (field.equals("color")) {
            if (o instanceof Color) {
                this.setPaint((Color)o);
            } else {
                this.setPaint(Colors.getColor((String)o, this.flatColor));
            }
        } else if (field.equals("strokecolor")) {
            super.set("strokecolor", this.flatColor);
        } else if (field.equals("labelcolor")) {
            if (o instanceof Color) {
                this.setLabelPaint((Color)o);
            } else {
                this.setLabelPaint(Colors.getColor((String)o, this.flatColor));
            }
        } else {
            super.set(field, o);
        }
    }

    @Override
    public Object get(String field) {
        if (field.equals("color")) {
            return this.flatColor;
        }
        if (field.equals("labelcolor")) {
            if (this.labelColor != null) {
                return Colors.toString(this.labelColor);
            }
            return Colors.toString(this.flatColor);
        }
        return super.get(field);
    }

    @Override
    public void highlight(boolean state) {
        if (!this.getVisible()) {
            return;
        }
        if (this.labelText == null) {
            this.labelText = new LabelText(this);
        }
        if (state) {
            this.labelText.setText(this.label);
            this.labelText.setPaint(new Color(100, 100, 100, 210));
            this.labelText.setTextPaint(Color.yellow);
            float scaling = (float)(1.0 / this.frame.getGCamera().getViewScale());
            this.labelText.setX(this.getX() + this.getWidth() + (double)(1.0f * scaling));
            this.labelText.setY(this.getY() + this.getHeight());
            this.frame.labels.addChild((PNode)this.labelText);
            if (this.label != null && this.label.equals(this.owner.getName())) {
                StatusBar.setStatus(this.label);
            } else if (this.label == null) {
                StatusBar.setStatus(this.owner.getName());
            } else {
                StatusBar.setStatus(this.owner.getName() + " (" + this.label + ")");
            }
        } else {
            this.labelText.removeFromParent();
            StatusBar.setStatus("");
        }
        this.highlightMode = state;
    }

    private void setGradPaint() {
        if (this.flatColor == null) {
            return;
        }
        float p1x = (float)(this.getX() + this.getWidth() / 8.0);
        float p1y = (float)(this.getY() + this.getHeight() / 8.0);
        float p2x = (float)(this.getX() + this.getWidth());
        float p2y = (float)(this.getY() + this.getHeight());
        this.gradPaint = new GradientPaint(p1x, p1y, Color.white, p2x, p2y, this.flatColor);
        this.setPaint(this.gradPaint);
    }

    public boolean setBounds(double x1, double y1, double width, double height) {
        boolean newB = super.setBounds(x1, y1, width, height);
        this.setGradPaint();
        return newB;
    }

    @Override
    public boolean setBounds(Rectangle2D newBounds) {
        boolean newB = super.setBounds(newBounds);
        this.setGradPaint();
        return newB;
    }

    @Override
    public void setPaint(Color c) {
        Color oldcolor = this.flatColor;
        this.flatColor = c;
        this.setGradPaint();
        if (oldcolor != null && oldcolor.getAlpha() != this.flatColor.getAlpha()) {
            Color oldSP = (Color)this.getStrokePaint();
            this.setStrokePaint(Colors.getColor(oldSP.getRed() + "," + oldSP.getGreen() + "," + oldSP.getBlue() + "," + this.curcolor.getAlpha(), oldSP));
        }
    }

    @Override
    public void paintOverload(PPaintContext apc) {
        Graphics2D g2 = apc.getGraphics();
        g2.setPaint(shadow);
        if (super.getStyle() == 8) {
            g2.fillRect((int)this.getX() + shadowOffset, (int)this.getY() + shadowOffset, (int)this.getWidth(), (int)this.getHeight());
        } else if (super.getStyle() == 9) {
            g2.fillOval((int)this.getX() + shadowOffset, (int)this.getY() + shadowOffset, (int)this.getWidth(), (int)this.getHeight());
        } else if (super.getStyle() == 10) {
            g2.fillRoundRect((int)this.getX() + shadowOffset, (int)this.getY() + shadowOffset, (int)this.getWidth(), (int)this.getHeight(), 2, 2);
        }
        if (this.labelMode) {
            float scaling = (float)(1.0 / this.frame.getGCamera().getViewScale());
            Font f = g2.getFont();
            f = f.deriveFont(12.0f * scaling);
            if (Guess.getDefaultFont() != null && !f.getFamily().equals(Guess.getDefaultFont())) {
                f = new Font(Guess.getDefaultFont(), f.getStyle(), f.getSize());
            }
            g2.setFont(f);
            g2.setPaint(this.curcolor);
            this.paintLabel(g2, (float)(this.getX() + this.getWidth() + 2.0), (float)(this.getY() + this.getHeight()), f);
        }
        g2.setStroke(linestroke);
    }
}

