/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.GuessTextNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class GuessTextLegendNode
extends PText {
    private int style = 6;
    private RectangularShape borderShape = null;
    Paint curcolor = null;
    Color strokePaint = Color.black;
    private boolean highlightMode = false;
    private boolean labelMode = false;
    private static BasicStroke linestroke = new BasicStroke(0.3f);
    public static int ZOOM_SIZE = 40;

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int s) {
        if (this.style == s && this.borderShape != null) {
            return;
        }
        this.borderShape = s == 4 ? new Rectangle2D.Double(this.getX() - 1.0, this.getY() - 1.0, this.getWidth() + 2.0, this.getHeight() + 2.0) : (s == 5 ? new Ellipse2D.Double(this.getX() - 4.0, this.getY() - 4.0, this.getWidth() + 8.0, this.getHeight() + 8.0) : new RoundRectangle2D.Double(this.getX() - 1.0, this.getY() - 1.0, this.getWidth() + 2.0, this.getHeight() + 2.0, 2.0, 2.0));
        this.style = s;
    }

    public GuessTextLegendNode(Node owner) {
        super(owner.getName());
        Font f;
        GuessTextNode gtn = (GuessTextNode)owner.getRep();
        this.setStyle(gtn.getStyle());
        this.curcolor = gtn.getPaint();
        this.setTextPaint(gtn.getTextPaint());
        this.strokePaint = gtn.strokePaint;
        this.setLabel(gtn.getText());
        if (Guess.getDefaultFont() != null && !(f = this.getFont()).getFamily().equals(Guess.getDefaultFont())) {
            f = new Font(Guess.getDefaultFont(), f.getStyle(), f.getSize());
            this.setFont(f);
        }
    }

    public boolean setBounds(Rectangle2D newBounds) {
        boolean toRet = super.setBounds(newBounds);
        return toRet;
    }

    public void setColor(Color c) {
        this.setPaint(c);
    }

    public void setShape(Shape shp, int style) {
    }

    public String getLabel() {
        return this.getText();
    }

    public void setLabel(String label) {
        this.setText(label);
    }

    public void setLocation(double x1, double y1, double width, double height) {
        this.setBounds(x1, y1, width, height);
    }

    public void setLocation(double x1, double y1) {
        double w = super.getWidth();
        double h = super.getHeight();
        this.setBounds(x1, y1, w, h);
    }

    public void setSize(double width, double height) {
        double x = super.getX();
        double y = super.getY();
        this.setBounds(x - width, y - height, width, height);
    }

    public double getDrawWidth() {
        return this.getWidth();
    }

    public double getDrawHeight() {
        return this.getHeight();
    }

    public void label(boolean state) {
        this.labelMode = state;
    }

    public void paint(PPaintContext apc) {
        Graphics2D g2 = apc.getGraphics();
        if (this.highlightMode) {
            g2.setPaint(Color.yellow);
        } else {
            g2.setPaint(this.curcolor);
        }
        if (this.borderShape == null) {
            this.setStyle(this.style);
        }
        if (this.style == 5) {
            this.borderShape.setFrame(this.getX() - 4.0, this.getY() - 4.0, this.getWidth() + 8.0, this.getHeight() + 8.0);
        } else {
            this.borderShape.setFrame(this.getX() - 1.0, this.getY() - 1.0, this.getWidth() + 2.0, this.getHeight() + 2.0);
        }
        g2.fill(this.borderShape);
        g2.setPaint(this.strokePaint);
        g2.setStroke(linestroke);
        g2.draw(this.borderShape);
        super.paint(apc);
    }
}

