/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.ConvexHullNode;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.piccolo.PFactory;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.NodeListener;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.HashSet;

public class GuessTextNode
extends PText
implements GuessPNode {
    protected Node owner = null;
    protected GFrame frame = null;
    protected int style = 6;
    protected RectangularShape borderShape = null;
    Color curcolor = Color.red;
    Color strokePaint = Color.black;
    protected boolean highlightMode = false;
    protected boolean labelMode = false;
    protected static BasicStroke linestroke = new BasicStroke(0.3f);
    public static int ZOOM_SIZE = 40;
    public HashSet hulls = null;

    @Override
    public Node getOwner() {
        return this.owner;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(int s) {
        if (this.style == s && this.borderShape != null) {
            return;
        }
        if (s == 3 || s == 1 || s == 2 || s == 7 || s > 100) {
            NodeListener rep = ((PFactory)VisFactory.getFactory()).convertNode(this, s, this.owner);
            this.owner.setRep(rep);
            this.owner.readjustEdges();
        } else {
            this.borderShape = s == 4 ? new Rectangle2D.Double(this.getX() - 1.0, this.getY() - 1.0, this.getWidth() + 2.0, this.getHeight() + 2.0) : (s == 5 ? new Ellipse2D.Double(this.getX() - 4.0, this.getY() - 4.0, this.getWidth() + 8.0, this.getHeight() + 8.0) : new RoundRectangle2D.Double(this.getX() - 4.0, this.getY() - 4.0, this.getWidth() + 8.0, this.getHeight() + 8.0, Math.max(8.0, (this.getWidth() + 8.0) / 5.0), Math.max(8.0, (this.getHeight() + 8.0) / 5.0)));
        }
        this.style = s;
    }

    public GuessTextNode(Node owner, double x, double y, GFrame frame, int style) {
        super(owner.getName());
        Font f;
        this.owner = owner;
        this.frame = frame;
        this.setX(x);
        this.setY(y);
        this.style = style;
        if (Guess.getDefaultFont() != null && !(f = this.getFont()).getFamily().equals(Guess.getDefaultFont())) {
            f = new Font(Guess.getDefaultFont(), f.getStyle(), f.getSize());
            this.setFont(f);
        }
    }

    public boolean setBounds(Rectangle2D newBounds) {
        boolean toRet = super.setBounds(newBounds);
        this.owner.readjustEdges();
        this.notifyHullListeners();
        return toRet;
    }

    public void setPaint(Color c) {
        Color oldcolor = (Color)this.getPaint();
        super.setPaint((Paint)c);
        this.curcolor = c;
        if (oldcolor != null && oldcolor.getAlpha() != this.curcolor.getAlpha()) {
            Color oldSP = this.strokePaint;
            this.strokePaint = Colors.getColor(oldSP.getRed() + "," + oldSP.getGreen() + "," + oldSP.getBlue() + "," + this.curcolor.getAlpha(), oldSP);
        }
        oldcolor = (Color)this.getTextPaint();
        double lum = (299 * c.getRed() + 587 * c.getGreen() + 114 * c.getBlue()) / 1000;
        if (lum < 127.0) {
            this.setTextPaint(Colors.getColor("255,255,255," + this.curcolor.getAlpha(), oldcolor));
        } else {
            this.setTextPaint(Colors.getColor("0,0,0," + this.curcolor.getAlpha(), oldcolor));
        }
    }

    @Override
    public void setColor(Color c) {
        this.setPaint(c);
    }

    @Override
    public Paint getPaint() {
        return this.curcolor;
    }

    @Override
    public void setShape(Shape shp, int style) {
    }

    public String getLabel() {
        return this.getText();
    }

    public void setLabel(String label) {
        this.setText(label);
        this.owner.readjustEdges();
    }

    @Override
    public void setLocation(double x1, double y1, double width, double height) {
        this.setBounds(x1, y1, width, height);
        this.owner.readjustEdges();
        this.notifyHullListeners();
    }

    @Override
    public void setLocation(double x1, double y1) {
        double w = super.getWidth();
        double h = super.getHeight();
        this.setBounds(x1, y1, w, h);
        this.owner.readjustEdges();
        this.notifyHullListeners();
    }

    public void setSize(double width, double height) {
        double x = super.getX();
        double y = super.getY();
        this.setBounds(x - width, y - height, width, height);
    }

    @Override
    public void mouseEntered(PInputEvent aEvent) {
        if (this.getVisible()) {
            GraphEvents.mouseEnter(this.owner);
        }
    }

    @Override
    public void mouseExited(PInputEvent aEvent) {
        if (this.getVisible()) {
            GraphEvents.mouseLeave(this.owner);
        }
    }

    @Override
    public void highlight(boolean state) {
        if (!this.getVisible()) {
            return;
        }
        this.highlightMode = state;
        if (state) {
            String label = this.getLabel();
            if (label != null && label.equals(this.owner.getName())) {
                StatusBar.setStatus(label);
            } else if (label == null) {
                StatusBar.setStatus(this.owner.getName());
            } else {
                StatusBar.setStatus(this.owner.getName() + " (" + label + ")");
            }
        } else {
            StatusBar.setStatus("");
        }
        this.repaint();
    }

    @Override
    public double getDrawWidth() {
        return this.getWidth();
    }

    @Override
    public double getDrawHeight() {
        return this.getHeight();
    }

    public void label(boolean state) {
        this.labelMode = state;
    }

    public void paintInternal(PPaintContext apc) {
        Graphics2D g2 = apc.getGraphics();
        if (this.highlightMode) {
            g2.setPaint(Color.yellow);
        } else {
            g2.setPaint(this.curcolor);
        }
        if (this.borderShape == null) {
            this.setStyle(this.style);
        }
        this.borderShape.setFrame(this.getX() - 4.0, this.getY() - 4.0, this.getWidth() + 8.0, this.getHeight() + 8.0);
        g2.fill(this.borderShape);
        g2.setPaint(this.strokePaint);
        g2.setStroke(linestroke);
        g2.draw(this.borderShape);
    }

    public void paint(PPaintContext apc) {
        this.paintInternal(apc);
        super.paint(apc);
    }

    @Override
    public void moveDone(double x, double y) {
        this.owner.endMove(x, y);
        this.notifyHullListeners();
    }

    @Override
    public void inTransition(double x, double y) {
        this.owner.move(x, y);
        this.hideHullListeners();
    }

    public void keyTyped(PInputEvent aEvent) {
        System.out.println("" + aEvent.getKeyChar());
    }

    @Override
    public void mouseClicked(PInputEvent aEvent) {
        if (aEvent.isLeftMouseButton() && this.frame.getMode() == 0) {
            if (aEvent.isShiftDown()) {
                GraphEvents.shiftClick(this.owner);
            } else {
                GraphEvents.click(this.owner);
            }
        }
    }

    @Override
    public void centerDisplay() {
        this.frame.centerOn(this);
    }

    @Override
    public void set(String field, Object o) {
        try {
            if (field.equals("style")) {
                this.setStyle((Integer)o);
            } else if (field.equals("x")) {
                this.setLocation((Double)o, this.getY());
            } else if (field.equals("y")) {
                this.setLocation(this.getX(), (Double)o);
            } else if (field.equals("width")) {
                this.setLocation(this.getX(), this.getY(), (Double)o, this.getHeight());
            } else if (field.equals("height")) {
                this.setLocation(this.getX(), this.getY(), this.getWidth(), (Double)o);
            } else if (field.equals("label")) {
                this.setLabel((String)o);
            } else if (field.equals("color")) {
                if (o instanceof Color) {
                    this.setPaint((Color)o);
                } else {
                    this.setPaint(Colors.getColor((String)o, (Color)this.getPaint()));
                }
            } else if (field.equals("strokecolor")) {
                this.strokePaint = o instanceof Color ? (Color)o : Colors.getColor((String)o, (Color)this.getPaint());
            } else if (field.equals("visible")) {
                this.setVisible((Boolean)o);
            } else if (field.equals("labelsize")) {
                this.setLabelSize((Integer)o);
            }
            if (Guess.getMTF()) {
                this.moveToFront();
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error("Problem with setting rep attribute: " + e.toString());
        }
    }

    private void setLabelSize(int newsz) {
        Font f = this.getFont().deriveFont((float)newsz);
        this.setFont(f);
    }

    private int getLabelSize() {
        return this.getFont().getSize();
    }

    @Override
    public Object get(String field) {
        try {
            if (field.equals("style")) {
                return new Integer(this.style);
            }
            if (field.equals("x")) {
                return new Double(this.getX());
            }
            if (field.equals("y")) {
                return new Double(this.getY());
            }
            if (field.equals("width")) {
                return new Double(this.getWidth());
            }
            if (field.equals("height")) {
                return new Double(this.getHeight());
            }
            if (field.equals("label")) {
                return this.getText();
            }
            if (field.equals("color")) {
                return Colors.toString((Color)this.getPaint());
            }
            if (field.equals("visible")) {
                return new Boolean(this.getVisible());
            }
            if (field.equals("labelvisible")) {
                return new Boolean(true);
            }
            if (field.equals("strokecolor")) {
                return this.strokePaint;
            }
            if (field.equals("labelsize")) {
                return new Integer(this.getLabelSize());
            }
            return null;
        }
        catch (Exception e) {
            throw new Error("Problem with getting rep attribute: " + field + " " + e.toString());
        }
    }

    @Override
    public void addHullListener(ConvexHullNode chn) {
        if (this.hulls == null) {
            this.hulls = new HashSet();
        }
        this.hulls.add(chn);
    }

    @Override
    public void removeHullListener(ConvexHullNode chn) {
        if (this.hulls != null) {
            this.hulls.remove(chn);
        }
    }

    private void notifyHullListeners() {
        if (this.hulls != null) {
            for (ConvexHullNode chn : this.hulls) {
                chn.nodeMoved((PNode)this);
            }
        }
    }

    private void hideHullListeners() {
        if (this.hulls != null) {
            for (ConvexHullNode chn : this.hulls) {
                chn.setVisible(false);
            }
        }
    }

    @Override
    public Point2D[] getAllPorts() {
        Point2D[] toRet = new Point2D[]{new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY()), new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight()), new Point2D.Double(this.getX(), this.getY() + this.getHeight() / 2.0), new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0), new Point2D.Double(this.getX(), this.getY()), new Point2D.Double(this.getX() + this.getWidth(), this.getY()), new Point2D.Double(this.getX(), this.getY() + this.getHeight()), new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight())};
        return toRet;
    }

    @Override
    public Point2D[] getPrefPorts() {
        Point2D[] toRet = new Point2D[]{new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY()), new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight()), new Point2D.Double(this.getX(), this.getY() + this.getHeight() / 2.0), new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0)};
        return toRet;
    }
}

