/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;

public class JpegImagesToMovie
implements ControllerListener,
DataSinkListener,
Runnable {
    ImageDataSource ids = null;
    Processor p = null;
    DataSink dsink = null;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public ImageSourceStream getISS() {
        if (this.ids != null) {
            return this.ids.getISS();
        }
        return null;
    }

    public boolean doIt(int width, int height, int frameRate, MediaLocator outML) {
        this.ids = new ImageDataSource(width, height, frameRate);
        try {
            this.p = Manager.createProcessor((DataSource)this.ids);
        }
        catch (Exception e) {
            System.err.println("Yikes!  Cannot create a processor from the data source.");
            return false;
        }
        this.p.addControllerListener((ControllerListener)this);
        this.p.configure();
        if (!this.waitForState(this.p, 180)) {
            System.err.println("Failed to configure the processor.");
            return false;
        }
        this.p.setContentDescriptor(new ContentDescriptor("video.quicktime"));
        TrackControl[] tcs = this.p.getTrackControls();
        Format[] f = tcs[0].getSupportedFormats();
        if (f == null || f.length <= 0) {
            System.err.println("The mux does not support the input format: " + tcs[0].getFormat());
            return false;
        }
        tcs[0].setFormat(f[0]);
        this.p.realize();
        if (!this.waitForState(this.p, 300)) {
            System.err.println("Failed to realize the processor.");
            return false;
        }
        this.dsink = this.createDataSink(this.p, outML);
        if (this.dsink == null) {
            System.err.println("Failed to create a DataSink for the given output MediaLocator: " + outML);
            return false;
        }
        this.dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        try {
            this.p.start();
            this.dsink.start();
        }
        catch (IOException e) {
            System.err.println("IO error during processing");
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        this.waitForFileDone();
        try {
            this.dsink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.p.removeControllerListener((ControllerListener)this);
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            System.err.println("Something is really wrong: the processor does not have an output DataSource");
            return null;
        }
        try {
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
            dsink.open();
        }
        catch (Exception e) {
            System.err.println("Cannot create the DataSink: " + e);
            return null;
        }
        return dsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    public JpegImagesToMovie(int width, int height, int frameRate, String outputURL) {
        MediaLocator oml = JpegImagesToMovie.createMediaLocator(outputURL);
        if (oml == null) {
            System.err.println("Cannot build media locator from: " + outputURL);
        } else {
            this.doIt(width, height, frameRate, oml);
        }
    }

    static MediaLocator createMediaLocator(String url) {
        MediaLocator ml = new MediaLocator("file:" + url);
        return ml;
    }

    public static void main(String[] args) {
        new JpegImagesToMovie(639, 421, 30, "abc.mov");
    }

    class ImageSourceStream
    implements PushBufferStream {
        Vector images;
        int width;
        int height;
        VideoFormat format;
        int nextImage = 0;
        boolean ended = false;
        byte[] initdata = null;
        BufferTransferHandler bth = null;

        public ImageSourceStream(int width, int height, int frameRate) {
            this.width = width;
            this.height = height;
            this.format = new VideoFormat("jpeg", new Dimension(width, height), -1, Format.byteArray, (float)frameRate);
        }

        public boolean willReadBlock() {
            return false;
        }

        public void stopMovie() {
            this.initdata = null;
            this.notifyBTH();
        }

        public void read(Buffer buf) throws IOException {
            if (this.initdata == null) {
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                this.ended = true;
                return;
            }
            byte[] data = null;
            if (buf.getData() instanceof byte[]) {
                data = (byte[])buf.getData();
            }
            if (data == null || data.length < this.initdata.length) {
                data = new byte[this.initdata.length];
                buf.setData((Object)data);
            }
            System.arraycopy(this.initdata, 0, data, 0, this.initdata.length);
            buf.setOffset(0);
            buf.setLength(this.initdata.length);
            buf.setFormat((Format)this.format);
            buf.setFlags(buf.getFlags() | 0x10);
        }

        public void loadBuffer(byte[] initdata) {
            this.initdata = initdata;
            this.notifyBTH();
        }

        public Format getFormat() {
            return this.format;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            return 0L;
        }

        public boolean endOfStream() {
            return this.ended;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }

        public void setTransferHandler(BufferTransferHandler th) {
            this.bth = th;
        }

        public void notifyBTH() {
            if (this.bth != null) {
                this.bth.transferData((PushBufferStream)this);
            }
        }
    }

    class ImageDataSource
    extends PushBufferDataSource {
        ImageSourceStream[] streams = new ImageSourceStream[1];

        ImageDataSource(int width, int height, int frameRate) {
            this.streams[0] = new ImageSourceStream(width, height, frameRate);
        }

        public void setLocator(MediaLocator source) {
        }

        public MediaLocator getLocator() {
            return null;
        }

        public String getContentType() {
            return "raw";
        }

        public void connect() {
        }

        public void disconnect() {
        }

        public void start() {
        }

        public void stop() {
        }

        public PushBufferStream[] getStreams() {
            return this.streams;
        }

        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }

        public ImageSourceStream getISS() {
            return this.streams[0];
        }
    }
}

