/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.ConvexHullNode;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessPEdge;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.AffineTransform;
import java.util.Collection;

public class KeyBoardManager
extends PBasicInputEventHandler {
    GFrame frame = null;

    public KeyBoardManager(GFrame f) {
        this.frame = f;
    }

    public void keyReleased(PInputEvent event) {
        if (event.getKeyCode() != 69 && event.getKeyCode() != 68) {
            if (event.getKeyCode() == 48 || event.getKeyCode() == 36) {
                this.frame.center();
            } else if (event.getKeyCode() != 70 && event.getKeyCode() == 127) {
                Collection c = this.frame.getSelected();
                for (PNode pn : c) {
                    GraphElement owner;
                    if (pn instanceof GuessPNode) {
                        owner = ((GuessPNode)pn).getOwner();
                        if (owner == null) continue;
                        Guess.getGraph().removeNode((Node)owner);
                        continue;
                    }
                    if (pn instanceof GuessPEdge) {
                        owner = ((GuessPEdge)pn).getOwner();
                        if (owner == null) continue;
                        Guess.getGraph().removeEdge((Edge)owner);
                        continue;
                    }
                    if (pn instanceof ConvexHullNode) {
                        VisFactory.getFactory().removeConvexHull((ConvexHullNode)pn);
                        continue;
                    }
                    pn.removeFromParent();
                }
                this.frame.unselectAll();
            }
        }
    }

    public void keyPressed(PInputEvent event) {
        PCamera cam = this.frame.getGCamera();
        double scale = cam.getScale();
        if (event.getKeyCode() == 90) {
            AffineTransform af = new AffineTransform();
            af.scale(scale * 0.8, scale * 0.8);
            cam.animateToTransform(af, 200L);
        } else if (event.getKeyCode() == 88) {
            AffineTransform af = new AffineTransform();
            af.scale(scale * 1.2, scale * 1.2);
            cam.animateToTransform(af, 200L);
        } else if (event.getKeyCode() == 40) {
            cam.translateView(0.0, 1.0 / scale * -20.0);
        } else if (event.getKeyCode() == 38) {
            cam.translateView(0.0, 1.0 / scale * 20.0);
        } else if (event.getKeyCode() == 39) {
            cam.translateView(1.0 / scale * -20.0, 0.0);
        } else if (event.getKeyCode() == 37) {
            cam.translateView(1.0 / scale * 20.0, 0.0);
        }
    }
}

