/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Font;
import java.awt.geom.Point2D;

public class LabelText
extends PText {
    private GuessPNode owner = null;
    private Point2D location = null;
    private float prevScale = -1.0f;

    public LabelText(GuessPNode owner) {
        this.owner = owner;
    }

    public LabelText(Point2D location) {
        this.location = location;
    }

    public void setLocation(Point2D location) {
        this.location = location;
        this.setX(location.getX());
        this.setY(location.getY() - 20.0);
    }

    public void paint(PPaintContext apc) {
        float scaling = (float)(1.0 / ((GFrame)VisFactory.getFactory().getDisplay()).getGCamera().getViewScale());
        if (scaling != this.prevScale) {
            Font f = this.getFont();
            f = f.deriveFont(12.0f * scaling);
            this.prevScale = scaling;
            if ((double)scaling <= 0.3) {
                scaling = 0.3f;
            }
            if (this.owner != null) {
                this.setX(this.owner.getX() + this.owner.getWidth() + (double)(1.0f * scaling));
                this.setY(this.owner.getY() + this.owner.getHeight());
            }
            if (Guess.getDefaultFont() != null && !f.getFamily().equals(Guess.getDefaultFont())) {
                f = new Font(Guess.getDefaultFont(), f.getStyle(), f.getSize());
            }
            this.setFont(f);
        }
        super.paint(apc);
    }
}

