/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.freehep.HEPDialog;
import com.hp.hpl.guess.piccolo.ConvexHullLegendNode;
import com.hp.hpl.guess.piccolo.ConvexHullNode;
import com.hp.hpl.guess.piccolo.GuessImageLegendNode;
import com.hp.hpl.guess.piccolo.GuessImageNode;
import com.hp.hpl.guess.piccolo.GuessLegendEdge;
import com.hp.hpl.guess.piccolo.GuessShape3DLegendNode;
import com.hp.hpl.guess.piccolo.GuessShapeLegendNode;
import com.hp.hpl.guess.piccolo.GuessShapeNode;
import com.hp.hpl.guess.piccolo.GuessShapeNode3D;
import com.hp.hpl.guess.piccolo.GuessTextLegendNode;
import com.hp.hpl.guess.piccolo.GuessTextNode;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.GuessJFrame;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Legend
extends JPanel
implements Dockable {
    DumbCanvas myCanvas = new DumbCanvas();
    private Vector nodes = new Vector();
    private HashMap annotations = new HashMap();
    private HashMap a2n = new HashMap();
    private double maxWidth = 14.0;
    private double maxHeight = 14.0;
    private Font font = null;
    private Color fontColor = Color.black;
    private Rectangle2D bounds = null;
    private JPopupMenu jp = new JPopupMenu("Options");
    private int direction = 2;
    private GuessJFrame myParent = null;

    public Legend() {
        this(2);
    }

    public Legend(int direction) {
        this.direction = direction;
        Guess.getMainUIWindow().dock(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)((Object)this.myCanvas), c);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent().getWidth() > 0) {
                    Legend.this.recenter();
                }
            }
        });
        JMenuItem jmi = this.jp.add("Export Image");
        ActionListener printListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Export Image")) {
                    HEPDialog hd = new HEPDialog(null);
                    hd.showHEPDialog(null, "Export File", (Component)((Object)Legend.this.myCanvas), "output.jpg", false);
                }
            }
        };
        jmi.addActionListener(printListener);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 2 || e.getButton() == 3) {
                    Legend.this.jp.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.myCanvas.addMouseListener(ma);
    }

    public void relayoutNodes() {
        int nnodes = this.nodes.size();
        double cellHeight = this.maxHeight + 8.0;
        double cellWidth = this.maxWidth + 8.0;
        boolean cellLoc = false;
        Font newFont = null;
        if (this.font != null) {
            newFont = this.font.deriveFont((float)this.maxHeight);
            if (Guess.getDefaultFont() != null && !newFont.getFamily().equals(Guess.getDefaultFont())) {
                newFont = new Font(Guess.getDefaultFont(), newFont.getStyle(), newFont.getSize());
            }
        }
        double maxX = 0.0;
        double maxY = 0.0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            PNode n = (PNode)this.nodes.elementAt(i);
            if (n instanceof GuessLegendEdge) {
                ((GuessLegendEdge)n).setCoords(4.0, (double)i * cellHeight + 4.0, cellWidth - 4.0, (double)i * cellHeight + cellHeight - 4.0);
            } else {
                double nwidth = n.getWidth();
                double nheight = n.getHeight();
                double hoffset = cellHeight * (double)i + (cellHeight / 2.0 - nheight / 2.0);
                double woffset = cellWidth / 2.0 - nwidth / 2.0;
                n.setX(woffset);
                n.setY(hoffset);
            }
            PText anno = (PText)this.annotations.get(n);
            if (anno != null) {
                double hoffset = cellHeight * (double)i + 4.0;
                double woffset = this.maxWidth + 20.0;
                anno.setFont(newFont);
                anno.setX(woffset);
                anno.setY(hoffset);
                anno.setTextPaint((Paint)this.fontColor);
                if (anno.getX() + anno.getWidth() > maxX) {
                    maxX = anno.getX() + anno.getWidth();
                }
                if (anno.getY() + anno.getHeight() > maxY) {
                    maxY = anno.getY() + anno.getHeight();
                }
            }
            if (n.getX() + n.getWidth() > maxX) {
                maxX = n.getX() + n.getWidth();
            }
            if (!(n.getY() + n.getHeight() > maxY)) continue;
            maxY = n.getY() + n.getHeight();
        }
        this.bounds = new Rectangle2D.Float(-10.0f, -10.0f, (float)maxX + 20.0f, (float)maxY + 20.0f);
        this.recenter();
    }

    public Rectangle2D getB() {
        return this.bounds;
    }

    public void recenter() {
        if (this.bounds == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PTransformActivity pta = Legend.this.myCanvas.getCamera().animateViewToCenterBounds(Legend.this.getB(), true, 100L);
            }
        });
    }

    public void remove(String s) {
        this.remove(s, (PNode)this.a2n.get(s));
        this.relayoutNodes();
    }

    private void remove(String s, PNode pn) {
        if (pn != null) {
            this.nodes.remove(pn);
            pn.removeFromParent();
            PNode p2 = (PNode)this.annotations.get(pn);
            this.annotations.remove(pn);
            if (p2 != null) {
                p2.removeFromParent();
            }
            this.a2n.remove(s);
        }
    }

    @Override
    public void removeAll() {
        ArrayList al = new ArrayList(this.a2n.keySet());
        Iterator it = al.iterator();
        while (it.hasNext()) {
            this.remove((String)it.next());
        }
        this.relayoutNodes();
    }

    public void setDisplayBackground(Color bg) {
        this.myCanvas.setBackground(bg);
        double lum = (299 * bg.getRed() + 587 * bg.getGreen() + 114 * bg.getBlue()) / 1000;
        this.fontColor = lum > 127.0 ? Color.black : Color.white;
        this.relayoutNodes();
    }

    public void setDisplayBackground(String bg) {
        this.setDisplayBackground(Colors.getColor(bg, this.getDisplayBackground()));
    }

    public Color getDisplayBackground() {
        return this.myCanvas.getBackground();
    }

    public void add(Node n, String annotation) {
        if (this.a2n.containsKey(annotation)) {
            throw new Error(annotation + " already exists in legend");
        }
        PNode pn = (PNode)n.getRep();
        Object toRet = null;
        if (pn instanceof GuessTextNode) {
            toRet = new GuessTextLegendNode(n);
        } else if (pn instanceof GuessShapeNode3D) {
            toRet = new GuessShape3DLegendNode(n);
        } else if (pn instanceof GuessShapeNode) {
            toRet = new GuessShapeLegendNode(n);
        } else if (pn instanceof GuessImageNode) {
            toRet = new GuessImageLegendNode(n);
        }
        if (toRet != null) {
            if (toRet.getWidth() > this.maxWidth) {
                this.maxWidth = toRet.getWidth();
            }
            if (toRet.getHeight() > this.maxHeight) {
                this.maxHeight = toRet.getHeight();
            }
            this.myCanvas.dLayer.addChild((PNode)toRet);
            this.nodes.add(toRet);
            PText anno = new PText(annotation);
            anno.setX(toRet.getWidth() + 10.0);
            anno.setY(toRet.getY());
            this.annotations.put(toRet, anno);
            this.myCanvas.dLayer.addChild((PNode)anno);
            this.font = anno.getFont();
            if (Guess.getDefaultFont() != null && !this.font.getFamily().equals(Guess.getDefaultFont())) {
                this.font = new Font(Guess.getDefaultFont(), this.font.getStyle(), this.font.getSize());
            }
            this.a2n.put(annotation, toRet);
        }
        this.relayoutNodes();
    }

    public void add(Edge e, String annotation) {
        if (this.a2n.containsKey(annotation)) {
            throw new Error(annotation + " already exists in legend");
        }
        GuessLegendEdge toRet = new GuessLegendEdge(e);
        this.myCanvas.dLayer.addChild((PNode)toRet);
        this.nodes.add(toRet);
        PText anno = new PText(annotation);
        anno.setX(toRet.getWidth() + 10.0);
        anno.setY(toRet.getY());
        this.annotations.put(toRet, anno);
        this.myCanvas.dLayer.addChild((PNode)anno);
        this.font = anno.getFont();
        if (Guess.getDefaultFont() != null && !this.font.getFamily().equals(Guess.getDefaultFont())) {
            this.font = new Font(Guess.getDefaultFont(), this.font.getStyle(), this.font.getSize());
        }
        this.a2n.put(annotation, toRet);
        this.relayoutNodes();
    }

    public void add(ConvexHullNode c, String annotation) {
        if (this.a2n.containsKey(annotation)) {
            throw new Error(annotation + " already exists in legend");
        }
        ConvexHullLegendNode toRet = new ConvexHullLegendNode(c);
        this.myCanvas.dLayer.addChild((PNode)toRet);
        this.nodes.add(toRet);
        PText anno = new PText(annotation);
        anno.setX(toRet.getWidth() + 10.0);
        anno.setY(toRet.getY());
        this.annotations.put(toRet, anno);
        this.myCanvas.dLayer.addChild((PNode)anno);
        this.font = anno.getFont();
        if (Guess.getDefaultFont() != null && !this.font.getFamily().equals(Guess.getDefaultFont())) {
            this.font = new Font(Guess.getDefaultFont(), this.font.getStyle(), this.font.getSize());
        }
        this.a2n.put(annotation, toRet);
        this.relayoutNodes();
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(100, 100, 200, 600);
    }

    @Override
    public int getDirectionPreference() {
        return this.direction;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.direction == 2) {
            return new Dimension(200, 600);
        }
        return new Dimension(600, 200);
    }

    @Override
    public String toString() {
        return "Legend [Items: " + this.nodes.size() + "]";
    }

    @Override
    public void opening(boolean state) {
    }

    @Override
    public void attaching(boolean state) {
    }

    @Override
    public String getTitle() {
        return "Legend";
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    class DumbCanvas
    extends PCanvas {
        public PLayer dLayer = new PLayer();

        public DumbCanvas() {
            if (this.dLayer == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getLayer().addChild((PNode)this.dLayer);
            this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
            this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        }
    }
}

