/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.piccolo.GuessPEdge;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.storage.StorageListener;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.GuessEdgeActivity;
import edu.umd.cs.piccolo.activities.GuessNodeActivity;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import java.awt.Color;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Morpher {
    private static Color invisiblecolor = null;
    private static float nodeDisBy = 1.0f;
    private static float nodeAppearAfter = 0.0f;
    private static float edgeDisBy = 1.0f;
    private static float edgeAppearAfter = 0.0f;

    public static Color getInvisible() {
        return invisiblecolor;
    }

    public static void morph(Graph g, String state, long duration) {
        Color background = VisFactory.getFactory().getDisplay().getDisplayBackground();
        invisiblecolor = new Color(background.getRed(), background.getBlue(), background.getGreen(), 0);
        StorageListener sl = StorageFactory.getSL();
        Vector v = sl.getNodesNotInCurrent(g, state);
        for (int i = 0; i < v.size(); ++i) {
            Node n = (Node)v.elementAt(i);
            n.__setattr__("visible", new Boolean(false));
            g.addNode(n);
        }
        Set nset = g.getNodes();
        GuessNodeActivity[] nActs = new GuessNodeActivity[nset.size()];
        NodeSchema ns = g.getNodeSchema();
        Field[] fields = new Field[]{ns.getField("x"), ns.getField("y"), ns.getField("color"), ns.getField("visible"), ns.getField("labelvisible"), ns.getField("height"), ns.getField("width"), ns.getField("style")};
        Iterator it = nset.iterator();
        PActivityScheduler pas = null;
        PRoot pr = null;
        int i = 0;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Object[] vals = sl.getColumns(n, fields, state);
            GuessNodeActivity gna = new GuessNodeActivity(duration, 1L, (GuessPNode)n.getRep());
            if (pas == null) {
                pr = ((PNode)n.getRep()).getRoot();
                pas = pr.getActivityScheduler();
            }
            if (vals == null) {
                gna.setDestinationGone();
            } else {
                gna.setDestination((Double)vals[0], (Double)vals[1], Colors.getColor((String)vals[2], null), (Boolean)vals[3], (Boolean)vals[4], (Double)vals[5], (Double)vals[6]);
            }
            nActs[i] = gna;
            ++i;
        }
        v = sl.getEdgesNotInCurrent(g, state);
        for (int j = 0; j < v.size(); ++j) {
            Edge e = (Edge)v.elementAt(j);
            e.__setattr__("visible", new Boolean(false));
            g.addEdge(e);
        }
        Set eset = g.getEdges();
        GuessEdgeActivity[] eActs = new GuessEdgeActivity[eset.size()];
        EdgeSchema es = g.getEdgeSchema();
        fields = new Field[]{ns.getField("color"), ns.getField("visible"), ns.getField("width")};
        it = eset.iterator();
        i = 0;
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            Object[] vals = sl.getColumns(e, fields, state);
            GuessEdgeActivity gea = new GuessEdgeActivity(duration, 1L, (GuessPEdge)e.getRep());
            if (pas == null) {
                pr = ((PNode)e.getRep()).getRoot();
                pas = pr.getActivityScheduler();
            }
            if (vals == null) {
                gea.setDestinationGone();
            } else {
                gea.setDestination(Colors.getColor((String)vals[0], null), (Boolean)vals[1], (Double)vals[2]);
            }
            eActs[i] = gea;
            ++i;
        }
        long start = System.currentTimeMillis() + 100L;
        for (i = 0; i < nActs.length; ++i) {
            nActs[i].setStartTime(start);
            pas.addActivity((PActivity)nActs[i]);
        }
        for (i = 0; i < eActs.length; ++i) {
            eActs[i].setStartTime(start);
            pas.addActivity((PActivity)eActs[i]);
        }
        pr.waitForActivities();
        sl.loadState(g, state);
    }

    public static void morph(Graph g, int state, long duration) {
        Morpher.morph(g, state + "", duration);
    }

    public static float getNodeDisappearBy() {
        return nodeDisBy;
    }

    public static void setNodeDisappearBy(float nodeDisBy) {
        if (nodeDisBy > 1.0f) {
            nodeDisBy = 1.0f;
        } else if (nodeDisBy < 0.0f) {
            nodeDisBy = 0.0f;
        }
        Morpher.nodeDisBy = nodeDisBy;
    }

    public static float getNodeAppearAfter() {
        return nodeAppearAfter;
    }

    public static void setNodeAppearAfter(float nodeAppearAfter) {
        if (nodeAppearAfter > 1.0f) {
            nodeAppearAfter = 1.0f;
        } else if (nodeAppearAfter < 0.0f) {
            nodeAppearAfter = 0.0f;
        }
        Morpher.nodeAppearAfter = nodeAppearAfter;
    }

    public static float getEdgeDisappearBy() {
        return edgeDisBy;
    }

    public static void setEdgeDisappearBy(float edgeDisBy) {
        if (edgeDisBy > 1.0f) {
            edgeDisBy = 1.0f;
        } else if (edgeDisBy < 0.0f) {
            edgeDisBy = 0.0f;
        }
        Morpher.edgeDisBy = edgeDisBy;
    }

    public static float getEdgeAppearAfter() {
        return edgeAppearAfter;
    }

    public static void setEdgeAppearAfter(float edgeAppearAfter) {
        if (edgeAppearAfter > 1.0f) {
            edgeAppearAfter = 1.0f;
        } else if (edgeAppearAfter < 0.0f) {
            edgeAppearAfter = 0.0f;
        }
        Morpher.edgeAppearAfter = edgeAppearAfter;
    }
}

