/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.ConvexHullNode;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessImageNode;
import com.hp.hpl.guess.piccolo.GuessPEdge;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.piccolo.GuessShapeNode;
import com.hp.hpl.guess.piccolo.GuessShapeNode3D;
import com.hp.hpl.guess.piccolo.GuessTextNode;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ConvexHull;
import com.hp.hpl.guess.ui.EdgeListener;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.NodeListener;
import com.hp.hpl.guess.ui.ShapeDB;
import com.hp.hpl.guess.ui.UIListener;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.HashSet;

public class PFactory
extends VisFactory
implements UIListener {
    private GFrame curFrame = null;
    private static long lastModTime = System.currentTimeMillis();
    HashSet hulls = new HashSet();
    private boolean defnhighlight = true;
    private boolean defehighlight = true;
    private boolean defnzoom = true;
    private boolean defezoom = true;

    public static void updateTime() {
        lastModTime = System.currentTimeMillis();
    }

    public static long getLastUpdate() {
        return lastModTime;
    }

    public PFactory() {
        this.init();
        GraphEvents.getGraphEvents().addGraphMouseListener(this);
    }

    public GFrame init() {
        this.curFrame = new GFrame();
        return this.curFrame;
    }

    @Override
    public FrameListener getDisplay() {
        return this.curFrame;
    }

    @Override
    public NodeListener generateNode(Node n) {
        return this.generateNode(1, 500.0, 500.0, 10.0, 10.0, Color.red, n);
    }

    @Override
    public NodeListener generateNode(int type, double x, double y, double width, double height, Color clr, Node n) {
        GuessPNode toRet = null;
        if (type == 2) {
            toRet = new GuessShapeNode(new Ellipse2D.Double(x, y, width, height), n, this.curFrame, type);
        } else if (type == 3) {
            toRet = new GuessShapeNode(new RoundRectangle2D.Double(x, y, width, height, Math.max(2.0, width / 5.0), Math.max(2.0, height / 5.0)), n, this.curFrame, type);
        } else if (type == 8) {
            toRet = new GuessShapeNode3D(new Rectangle2D.Double(x, y, width, height), n, this.curFrame, type);
        } else if (type == 9) {
            toRet = new GuessShapeNode3D(new Ellipse2D.Double(x, y, width, height), n, this.curFrame, type);
        } else if (type == 10) {
            toRet = new GuessShapeNode3D(new RoundRectangle2D.Double(x, y, width, height, Math.max(2.0, width / 5.0), Math.max(2.0, height / 5.0)), n, this.curFrame, type);
        } else if (type == 4 || type == 6 || type == 5) {
            toRet = new GuessTextNode(n, x, y, this.curFrame, type);
        } else if (type == 7) {
            toRet = new GuessImageNode(n, this.curFrame, type, x, y, width, height);
        } else if (type > 100) {
            Shape s = ShapeDB.getShapeDB().getShape(type);
            if (s == null) {
                toRet = new GuessShapeNode(new Rectangle2D.Double(x, y, width, height), n, this.curFrame, type);
            } else {
                toRet = new GuessShapeNode(s, n, this.curFrame, type);
                toRet.setLocation(x, y, width, height);
            }
        } else {
            toRet = new GuessShapeNode(new Rectangle2D.Double(x, y, width, height), n, this.curFrame, type);
        }
        if (toRet != null) {
            toRet.setColor(clr);
            this.curFrame.getNodes().addChild((PNode)toRet);
        }
        ((PNode)toRet).setBounds((Rectangle2D)new Rectangle2D.Double(x, y, width, height));
        return toRet;
    }

    @Override
    public void remove(Node n) {
        PNode rep = (PNode)n.getRep();
        if (rep.getParent() != null) {
            this.curFrame.getNodes().removeChild(rep);
        }
    }

    @Override
    public void remove(Edge e) {
        PNode rep = (PNode)e.getRep();
        if (rep.getParent() != null) {
            this.curFrame.getEdges().removeChild(rep);
        }
    }

    @Override
    public void add(Node n) {
        PNode pn = (PNode)n.getRep();
        if (pn.getParent() == null) {
            this.curFrame.getNodes().addChild(pn);
        }
    }

    @Override
    public void add(Edge e) {
        PNode pn = (PNode)e.getRep();
        if (pn.getParent() == null) {
            this.curFrame.getEdges().addChild(pn);
            if (pn instanceof GuessPEdge) {
                ((GuessPEdge)pn).readjust();
            }
        }
    }

    public NodeListener convertNode(GuessPNode rep, int style, Node n) {
        NodeListener toRet;
        if (style <= 100 && rep.getStyle() == style) {
            return rep;
        }
        boolean vis = ((PNode)rep).getVisible();
        String image = "";
        Object tCol = rep.get("color");
        Color newCol = Color.blue;
        if (tCol != null) {
            newCol = Colors.getColor(tCol.toString(), Color.blue);
        }
        if (style == 7) {
            image = (String)n.__getattr__("image");
        }
        if (rep.getStyle() == 7) {
            newCol = Colors.getColor((String)n.__getattr__("color"), Color.blue);
        }
        if ((toRet = this.generateNode(style, rep.getX(), rep.getY(), rep.getWidth(), rep.getHeight(), newCol, n)) == null) {
            return rep;
        }
        ((PNode)toRet).setVisible(vis);
        try {
            ((PNode)rep).removeFromParent();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (style == 7) {
            toRet.set("image", image);
        }
        if (rep.get("label") != null) {
            toRet.set("label", rep.get("label"));
        }
        toRet.set("labelvisible", rep.get("labelvisible"));
        toRet.set("labelcolor", rep.get("labelcolor"));
        if (!(rep.getStyle() != 4 && rep.getStyle() != 6 && rep.getStyle() != 5 || style != 1 && style != 3 && style != 2 && style != 8 && style != 10 && style != 9 && style != 7)) {
            toRet.set("width", rep.getOwner().getAttrDB("width"));
            toRet.set("height", rep.getOwner().getAttrDB("height"));
        }
        toRet.set("strokecolor", rep.get("strokecolor"));
        return toRet;
    }

    public NodeListener generateNode(Shape sp, Node n) {
        return new GuessShapeNode(sp, n, this.curFrame, 4);
    }

    @Override
    public EdgeListener generateEdge(Edge n) {
        GuessPEdge toRet = new GuessPEdge(n, this.curFrame);
        this.curFrame.getEdges().addChild((PNode)toRet);
        return toRet;
    }

    public EdgeListener generateEdge(Shape aShape, Edge n) {
        return new GuessPEdge(aShape, n, this.curFrame);
    }

    public EdgeListener generateEdge(double x1, double y1, Color clr, float width, double size, Edge n) {
        GuessPEdge toRet = new GuessPEdge(new Ellipse2D.Double(x1 - size, y1 - size, size, size), n, this.curFrame);
        toRet.setPaint(clr);
        toRet.setStroke(new BasicStroke(width));
        this.curFrame.getEdges().addChild((PNode)toRet);
        return toRet;
    }

    public void updateEdge(GuessPEdge toRet, double x1, double y1, double x2, double y2) {
        toRet.setShape(new Line2D.Double(x1, y1, x2, y2));
    }

    public void updateEdge(GuessPEdge toRet, Shape aShape) {
        toRet.setShape(aShape);
    }

    public void updateEdge(GuessPEdge toRet, double x1, double y1, Color clr, float width, double size) {
        toRet.setShape(new Ellipse2D.Double(x1 - size, y1 - size, size, size));
    }

    @Override
    public void setDirected(boolean dir) {
        boolean readjust = false;
        if (dir != this.getDirected()) {
            readjust = true;
        }
        super.setDirected(dir);
        if (readjust) {
            this.curFrame.setFrozen(true);
            try {
                for (int i = this.curFrame.getEdges().getChildrenCount() - 1; i >= 0; --i) {
                    EdgeListener gpe = (EdgeListener)this.curFrame.getEdges().getChild(i);
                    gpe.readjust();
                }
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
            this.curFrame.setFrozen(false);
        }
    }

    @Override
    public ConvexHull createConvexHull(Collection s, Color c) {
        ConvexHullNode t = new ConvexHullNode(s, c);
        this.curFrame.getHulls().addChild((PNode)t);
        this.hulls.add(t);
        return t;
    }

    @Override
    public void removeConvexHull(ConvexHull c) {
        this.hulls.remove(c);
        ((ConvexHullNode)c).destroyHull();
    }

    @Override
    public Collection getConvexHulls() {
        return this.hulls;
    }

    @Override
    public void shiftClickNode(Node n) {
    }

    @Override
    public void shiftClickEdge(Edge e) {
    }

    @Override
    public void clickNode(Node n) {
        if (this.defnzoom) {
            ((GuessPNode)n.getRep()).centerDisplay();
        }
    }

    @Override
    public void clickEdge(Edge e) {
        if (this.defezoom) {
            ((GuessPEdge)e.getRep()).centerDisplay();
        }
    }

    @Override
    public void mouseEnterNode(Node n) {
        if (this.defnhighlight) {
            n.getRep().highlight(true);
        }
    }

    @Override
    public void mouseEnterEdge(Edge e) {
        if (this.defehighlight) {
            e.getRep().highlight(true);
        }
    }

    @Override
    public void mouseLeaveNode(Node n) {
        if (this.defnhighlight) {
            n.getRep().highlight(false);
        }
    }

    @Override
    public void mouseLeaveEdge(Edge e) {
        if (this.defehighlight) {
            e.getRep().highlight(false);
        }
    }

    public void defaultNodeHighlights(boolean state) {
        this.defnhighlight = state;
    }

    public void defaultEdgeHighlights(boolean state) {
        this.defehighlight = state;
    }

    public void defaultNodeZooming(boolean state) {
        this.defnzoom = state;
    }

    public void defaultEdgeZooming(boolean state) {
        this.defezoom = state;
    }
}

