/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.PFactory;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;

class PreviewPopup
extends JPopupMenu
implements MouseListener,
MouseMotionListener {
    private PCamera _camera;
    private JLabel _zoomWindow;
    private JLabel _cursorLabel;
    private JLayeredPane _layeredPane;
    private int _iconWidth;
    private int _iconHeight;
    private boolean _doCloseAfterClick;
    private Rectangle2D _origin = null;
    double _ratio;
    private static int DELTA = 5;
    private static double SCALEFACTOR = 4.0;
    private GFrame _gf = null;
    private Image componentImage = null;
    private long lastUpdate = System.currentTimeMillis();

    public PreviewPopup(GFrame gf, boolean doCloseAfterClick) {
        this._camera = gf.getGCamera();
        this._gf = gf;
        this.setBorder(BorderFactory.createEtchedBorder());
        this._doCloseAfterClick = doCloseAfterClick;
        this._zoomWindow = new JLabel();
        this._cursorLabel = this.createCursor();
        this._layeredPane = new JLayeredPane();
        this._layeredPane.add((Component)this._zoomWindow, new Integer(0));
        this._layeredPane.add((Component)this._cursorLabel, new Integer(1));
        BufferedImage bim = new BufferedImage(1, 1, 6);
        this.setCursor(this.getToolkit().createCustomCursor(bim, new Point(0, 0), "HiddenM"));
        this.add(this._layeredPane);
        this._layeredPane.addMouseListener(this);
        this._layeredPane.addMouseMotionListener(this);
    }

    public void showUpInCorner(Component c, String corner, int mouseX, int mouseY) {
        BufferedImage original = null;
        if (this.componentImage == null || this.lastUpdate < PFactory.getLastUpdate()) {
            this.lastUpdate = System.currentTimeMillis();
            this._origin = this._gf.getFullImageSize();
            original = this._gf.getFullImage(this._origin, 200.0, 200.0);
            SCALEFACTOR = 1.0 / Math.min(200.0 / this._origin.getWidth(), 200.0 / this._origin.getHeight());
            if (original == null) {
                return;
            }
        }
        this._ratio = 1.0 / SCALEFACTOR;
        if (original != null) {
            this.componentImage = original;
        }
        ImageIcon componentIcon = new ImageIcon(this.componentImage);
        this._iconWidth = componentIcon.getIconWidth();
        this._iconHeight = componentIcon.getIconHeight();
        this._zoomWindow.setIcon(componentIcon);
        this._zoomWindow.setBounds(0, 0, this._iconWidth, this._iconHeight);
        PBounds pb = this._camera.getViewBounds();
        double cursorWidth = pb.getWidth() * this._ratio;
        double cursorHeight = pb.getHeight() * this._ratio;
        this._cursorLabel.setBounds(0, 0, (int)cursorWidth, (int)cursorHeight);
        this._layeredPane.setPreferredSize(new Dimension(this._iconWidth, this._iconHeight));
        int dx = componentIcon.getIconWidth() + DELTA;
        int dy = componentIcon.getIconHeight() + DELTA;
        this.show(c, dx, dy);
    }

    public JLabel createCursor() {
        JLabel label = new JLabel();
        label.setBorder(BorderFactory.createLineBorder(Color.black));
        label.setVisible(false);
        return label;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._cursorLabel.setVisible(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._cursorLabel.setVisible(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._doCloseAfterClick) {
            this.setVisible(false);
            this._cursorLabel.setVisible(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveCursor(e.getX(), e.getY());
        this.scrollViewPort();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.moveCursor(e.getX(), e.getY());
        this.scrollViewPort();
    }

    private void moveCursor(int x, int y) {
        int dx = x - this._cursorLabel.getWidth() / 2;
        int dy = y - this._cursorLabel.getHeight() / 2;
        this._cursorLabel.setLocation(dx, dy);
    }

    private void scrollViewPort() {
        Point cursorLocation = this._cursorLabel.getLocation();
        double dx = cursorLocation.getX();
        double dy = cursorLocation.getY();
        dx = dx / this._ratio + this._origin.getX();
        dy = dy / this._ratio + this._origin.getY();
        PBounds pb = this._camera.getViewBounds();
        Rectangle2D.Double r2d = new Rectangle2D.Double(dx, dy, pb.getWidth(), pb.getHeight());
        this._camera.animateViewToPanToBounds((Rectangle2D)r2d, 0L);
    }
}

