/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.piccolo.CursorFactory;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;

public class RectZoomHandler
extends PBasicInputEventHandler {
    protected PPath rectangle;
    protected Point2D pressPoint;
    protected Point2D dragPoint;
    private PLayer layer = null;
    private PCamera camera = null;
    static final int DASH_WIDTH = 5;
    static final int NUM_STROKES = 10;
    private float strokeNum = 0.0f;
    private BasicStroke[] strokes = null;
    FrameListener fl = null;

    public RectZoomHandler(PLayer layer, PCamera cam) {
        this.layer = layer;
        this.camera = cam;
        float[] dash = new float[]{5.0f, 5.0f};
        this.strokes = new BasicStroke[10];
        for (int i = 0; i < 10; ++i) {
            this.strokes[i] = new BasicStroke(1.0f, 0, 0, 1.0f, dash, i);
        }
        this.fl = VisFactory.getFactory().getDisplay();
    }

    public void mousePressed(PInputEvent e) {
        if (!e.isLeftMouseButton()) {
            return;
        }
        if (!e.isShiftDown()) {
            return;
        }
        super.mousePressed(e);
        this.dragPoint = this.pressPoint = e.getPosition();
        this.rectangle = new PPath();
        this.rectangle.setStroke((Stroke)new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
        Color c = this.fl.getDisplayBackground();
        double lum = (299 * c.getRed() + 587 * c.getGreen() + 114 * c.getBlue()) / 1000;
        if (lum < 127.0) {
            this.rectangle.setStrokePaint((Paint)Color.white);
        } else {
            this.rectangle.setStrokePaint((Paint)Color.black);
        }
        this.layer.addChild((PNode)this.rectangle);
        e.pushCursor(CursorFactory.getCursor(2));
        this.updateRectangle();
    }

    public void mouseDragged(PInputEvent e) {
        if (!e.isLeftMouseButton()) {
            return;
        }
        if (!e.isShiftDown()) {
            return;
        }
        super.mouseDragged(e);
        float origStrokeNum = this.strokeNum;
        this.strokeNum = (this.strokeNum + 0.5f) % 10.0f;
        if ((int)this.strokeNum != (int)origStrokeNum) {
            this.rectangle.setStroke((Stroke)this.strokes[(int)this.strokeNum]);
        }
        this.dragPoint = e.getPosition();
        this.updateRectangle();
    }

    public void mouseReleased(PInputEvent e) {
        if (!e.isLeftMouseButton()) {
            return;
        }
        try {
            e.popCursor();
        }
        catch (Exception ex) {
            e.pushCursor(CursorFactory.getCursor(1));
        }
        if (this.rectangle == null) {
            return;
        }
        super.mouseReleased(e);
        this.updateRectangle();
        this.layer.removeChild((PNode)this.rectangle);
        if (this.rectangle.getWidth() < 1.0 || this.rectangle.getHeight() < 1.0) {
            this.rectangle = null;
            return;
        }
        final Rectangle2D.Double r2d = new Rectangle2D.Double(this.rectangle.getX(), this.rectangle.getY(), this.rectangle.getWidth(), this.rectangle.getHeight());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RectZoomHandler.this.camera.animateViewToCenterBounds(r2d, true, 2000L);
            }
        });
        this.rectangle = null;
    }

    public void updateRectangle() {
        PBounds b = new PBounds();
        b.add(this.pressPoint);
        b.add(this.dragPoint);
        this.rectangle.setPathTo((Shape)b);
    }
}

