/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.prefuse;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.freehep.HEPWriter;
import com.hp.hpl.guess.prefuse.PrefuseNode;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.FrameListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import org.python.core.PyInstance;
import org.python.core.PySequence;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.force.ForceSimulator;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class PrefuseDisplay
extends Display
implements FrameListener {
    private static final String graph = "graph";
    private static final String nodes = "graph.nodes";
    private static final String edges = "graph.edges";
    protected Visualization m_vis = new Visualization();
    protected ForceSimulator fsim = null;
    protected GraphDistanceFilter filter = null;
    private Graph m_graph = null;
    protected int hops = 30;
    ForceDirectedLayout fdl = null;
    VisualGraph vg = null;

    public PrefuseDisplay(Graph m_graph) {
        this.m_graph = m_graph;
        this.setVisualization(this.m_vis);
        this.setSize(700, 700);
        this.pan(350.0, 350.0);
        this.setForeground(Color.GRAY);
        this.setBackground(Color.WHITE);
        this.addControlListener((Control)new FocusControl(1));
        this.addControlListener((Control)new DragControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new WheelZoomControl());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new NeighborHighlightControl());
        this.setForeground(Color.GRAY);
        this.setBackground(Color.WHITE);
    }

    public void toggleForce() {
        this.fdl.setEnabled(!this.fdl.isEnabled());
    }

    public void preRun() {
        LabelRenderer tr = new LabelRenderer();
        tr.setRoundedCorner(8, 8);
        this.m_vis.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)tr));
        this.setGraph(this.m_graph, "label");
        ActionList draw = new ActionList();
        draw.add((Action)new ColorAction(nodes, VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0)));
        ActionList animate = new ActionList(-1L);
        this.fdl = new ForceDirectedLayout(graph);
        this.fdl.setEnabled(false);
        animate.add((Action)this.fdl);
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("draw", (Action)draw);
        this.m_vis.putAction("layout", (Action)animate);
        this.m_vis.runAfter("draw", "layout");
        this.fsim = ((ForceDirectedLayout)animate.get(0)).getForceSimulator();
        VisualItem f = (VisualItem)this.vg.getNode(0);
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).setTuple((Tuple)f);
        f.setFixed(false);
    }

    public void runNow() {
        System.err.println("running...");
        this.m_vis.run("draw");
    }

    public void setGraph(Graph g, String label) {
        DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
        ((LabelRenderer)drf.getDefaultRenderer()).setTextField(label);
        this.m_vis.removeGroup(graph);
        this.vg = this.m_vis.addGraph(graph, g);
        this.m_vis.setValue(edges, null, VisualItem.INTERACTIVE, (Object)Boolean.FALSE);
    }

    @Override
    public void center() {
        Rectangle2D bounds = this.m_vis.getBounds(Visualization.ALL_ITEMS);
        GraphicsLib.expand((Rectangle2D)bounds, (double)(50 + (int)(1.0 / this.getScale())));
        DisplayLib.fitViewToBounds((Display)this, (Rectangle2D)bounds, (long)2000L);
    }

    @Override
    public void center(Object o) {
        this.center(o, 2000L);
    }

    public void center(Object o, long t) {
        if (o == null) {
            return;
        }
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        if (o instanceof Integer) {
            this.center();
            return;
        }
        if (o instanceof Node) {
            Rectangle2D bounds = ((PrefuseNode)((Node)o).getRep()).getBounds();
            GraphicsLib.expand((Rectangle2D)bounds, (double)(50 + (int)(1.0 / this.getScale())));
            DisplayLib.fitViewToBounds((Display)this, (Rectangle2D)bounds, (long)2000L);
            return;
        }
        if (o instanceof Edge) {
            Rectangle2D bounds1 = ((PrefuseNode)((Edge)o).getNode1().getRep()).getBounds();
            Rectangle2D bounds2 = ((PrefuseNode)((Edge)o).getNode2().getRep()).getBounds();
            Rectangle2D bounds = bounds1.createIntersection(bounds2);
            GraphicsLib.expand((Rectangle2D)bounds, (double)(50 + (int)(1.0 / this.getScale())));
            DisplayLib.fitViewToBounds((Display)this, (Rectangle2D)bounds, (long)2000L);
            return;
        }
        if (o instanceof PySequence) {
            PySequence q = (PySequence)o;
            int len = q.__len__();
            Rectangle2D bounds = null;
            for (int i = 0; i < len; ++i) {
                Rectangle2D bounds1;
                if (!(q.__getitem__(i) instanceof PyInstance)) continue;
                Object elem = ((PyInstance)q.__getitem__(i)).__tojava__(Object.class);
                if (elem instanceof Node) {
                    bounds1 = ((PrefuseNode)((Node)elem).getRep()).getBounds();
                    if (bounds == null) {
                        bounds = bounds1;
                        continue;
                    }
                    bounds = bounds.createIntersection(bounds1);
                    continue;
                }
                if (!(elem instanceof Edge)) continue;
                bounds1 = ((PrefuseNode)((Edge)elem).getNode1().getRep()).getBounds();
                Rectangle2D bounds2 = ((PrefuseNode)((Edge)elem).getNode2().getRep()).getBounds();
                bounds = bounds == null ? bounds1 : bounds.createIntersection(bounds1);
                bounds = bounds.createIntersection(bounds2);
            }
            if (bounds != null) {
                GraphicsLib.expand(bounds, (double)(50 + (int)(1.0 / this.getScale())));
                DisplayLib.fitViewToBounds((Display)this, bounds, (long)2000L);
            }
        } else if (o instanceof Collection) {
            Iterator it = ((Collection)o).iterator();
            Rectangle2D bounds = null;
            while (it.hasNext()) {
                Rectangle2D bounds1;
                Object elem = it.next();
                if (elem instanceof Node) {
                    bounds1 = ((PrefuseNode)((Node)elem).getRep()).getBounds();
                    if (bounds == null) {
                        bounds = bounds1;
                        continue;
                    }
                    bounds = bounds.createIntersection(bounds1);
                    continue;
                }
                if (!(elem instanceof Edge)) continue;
                bounds1 = ((PrefuseNode)((Edge)elem).getNode1().getRep()).getBounds();
                Rectangle2D bounds2 = ((PrefuseNode)((Edge)elem).getNode2().getRep()).getBounds();
                bounds = bounds == null ? bounds1 : bounds.createIntersection(bounds1);
                bounds = bounds.createIntersection(bounds2);
            }
            if (bounds != null) {
                GraphicsLib.expand(bounds, (double)(50 + (int)(1.0 / this.getScale())));
                DisplayLib.fitViewToBounds((Display)this, (Rectangle2D)bounds, (long)2000L);
            }
        } else {
            throw new Error("center() on " + o.getClass().toString() + " not implemented");
        }
    }

    public void center(double minx, double miny, double maxx, double maxy, long t) {
        if (minx == Double.MAX_VALUE || maxx == Double.MIN_VALUE || miny == Double.MAX_VALUE || maxy == Double.MIN_VALUE) {
            return;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(minx -= 10.0, miny -= 10.0, (maxx += 10.0) - minx, (maxy += 10.0) - miny);
        DisplayLib.fitViewToBounds((Display)this, (Rectangle2D)bounds, (long)t);
    }

    @Override
    public void setFrozen(boolean state) {
    }

    @Override
    public void exportGIF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 0);
    }

    @Override
    public void exportJPG(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 1);
    }

    @Override
    public void exportPDF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 2);
    }

    @Override
    public void exportPS(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 3);
    }

    @Override
    public void exportEPS(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 3);
    }

    @Override
    public void exportSVG(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 4);
    }

    @Override
    public void exportSWF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 5);
    }

    @Override
    public void exportJAVA(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 6);
    }

    @Override
    public void exportCGM(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 7);
    }

    @Override
    public void exportEMF(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 8);
    }

    @Override
    public void exportPNG(String filename) {
        HEPWriter.export(filename, (Component)((Object)this), 9);
    }

    @Override
    public Color getDisplayBackground() {
        return null;
    }

    @Override
    public void setDisplayBackground(Color bg) {
        this.setBackground(bg);
    }

    public void setDisplayBackground(String bg) {
        this.setBackground(Colors.getColor(bg, this.getDisplayBackground()));
    }

    @Override
    public void setBackgroundImage(String filename) {
    }

    @Override
    public void setBackgroundImage(String filename, double x, double y) {
    }

    @Override
    public void removeBackgroundImage() {
    }

    @Override
    public BufferedImage getFullImage() {
        return null;
    }
}

