/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.prefuse;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.prefuse.ForcePanel;
import com.hp.hpl.guess.prefuse.PrefuseDisplay;
import com.hp.hpl.guess.prefuse.PrefuseEdge;
import com.hp.hpl.guess.prefuse.PrefuseNode;
import com.hp.hpl.guess.ui.EdgeListener;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.NodeListener;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import prefuse.Visualization;
import prefuse.data.Graph;
import prefuse.visual.VisualItem;

public class PrefuseFactory
extends VisFactory {
    private PrefuseDisplay curFrame = null;
    protected Graph m_graph = null;
    protected static Visualization m_vis = null;
    private ForcePanel fp = null;

    public PrefuseFactory() {
        this.init();
    }

    private PrefuseDisplay init() {
        this.m_graph = new Graph(false);
        prefuse.data.Node n1 = this.m_graph.addNode();
        this.m_graph.getNodeTable().addColumn("label", String.class);
        this.m_graph.getNodeTable().addColumn(VisualItem.X, Double.TYPE);
        this.m_graph.getNodeTable().addColumn(VisualItem.Y, Double.TYPE);
        this.m_graph.getNodeTable().addColumn(VisualItem.STROKECOLOR, Integer.TYPE);
        this.m_graph.getEdgeTable().addColumn(VisualItem.FILLCOLOR, Integer.TYPE);
        this.m_graph.getEdgeTable().addColumn(VisualItem.STROKECOLOR, Integer.TYPE);
        this.curFrame = new PrefuseDisplay(this.m_graph);
        try {
            this.curFrame.preRun();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_graph.removeNode(n1);
        m_vis = this.curFrame.m_vis;
        return this.curFrame;
    }

    @Override
    public FrameListener getDisplay() {
        return this.curFrame;
    }

    @Override
    public synchronized void runNow() {
        this.curFrame.runNow();
        this.fp = new ForcePanel(this.curFrame);
        JMenu pMenu = new JMenu("Prefuse");
        JMenuItem fpan = new JMenuItem("Force controls...");
        ActionListener displayListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Force controls...")) {
                    Guess.getMainUIWindow().undock(PrefuseFactory.this.fp);
                }
            }
        };
        fpan.addActionListener(displayListener);
        pMenu.add(fpan);
        Guess.getMainUIWindow().getGMenuBar().add(pMenu);
        Guess.getMainUIWindow().undock(this.fp);
    }

    @Override
    public NodeListener generateNode(int type, double x, double y, double width, double height, Color clr, Node n) {
        NodeListener node = this.generateNode(n);
        node.set("x", new Double(x));
        node.set("y", new Double(y));
        return node;
    }

    @Override
    public NodeListener generateNode(Node n) {
        PrefuseNode pn = new PrefuseNode(this.m_graph);
        pn.set("label", n.getName());
        return pn;
    }

    @Override
    public void remove(Node n) {
    }

    @Override
    public void remove(Edge e) {
    }

    @Override
    public void add(Node n) {
    }

    @Override
    public void add(Edge e) {
    }

    @Override
    public EdgeListener generateEdge(Edge n) {
        PrefuseEdge pe = new PrefuseEdge(this.m_graph, (PrefuseNode)n.getNode1().getRep(), (PrefuseNode)n.getNode2().getRep());
        return pe;
    }
}

