/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.r;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.UndirectedEdge;
import java.util.HashMap;
import java.util.Set;

public class GraphMap
extends HashMap {
    private double[] conn = null;
    private Node[] graphMap = null;

    public double[] getConn() {
        return this.conn;
    }

    public Node getNode(int index) {
        return this.graphMap[index];
    }

    public int getNodeCount() {
        return this.graphMap.length;
    }

    public GraphMap(Graph g) {
        Set nodes = g.getNodes();
        this.graphMap = new Node[nodes.size()];
        nodes.toArray(this.graphMap);
        this.clear();
        for (int i = 0; i < this.graphMap.length; ++i) {
            this.put(this.graphMap[i], new Integer(i));
        }
        this.conn = new double[nodes.size() * nodes.size()];
        for (Edge e : g.getEdges()) {
            int loc;
            int j;
            int i;
            Node n2;
            Node n1;
            if (e instanceof UndirectedEdge) {
                n1 = e.getNode1();
                n2 = e.getNode2();
                i = (Integer)this.get(n1);
                j = (Integer)this.get(n2);
                loc = nodes.size() * i + j;
                this.conn[loc] = 1.0;
                loc = nodes.size() * j + i;
                this.conn[loc] = 1.0;
                continue;
            }
            if (!(e instanceof DirectedEdge)) continue;
            n1 = (Node)((DirectedEdge)e).getSource();
            n2 = (Node)((DirectedEdge)e).getDest();
            i = (Integer)this.get(n1);
            j = (Integer)this.get(n2);
            loc = nodes.size() * i + j;
            this.conn[loc] = 1.0;
        }
    }
}

