/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.r;

import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.GuessJFrame;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImageMonitor
extends GuessJFrame {
    private String toMonitor = "";
    private long lastModified = 0L;
    private BufferedImage bi = null;
    private ImagePanel ip = null;

    public ImageMonitor(String toMonitor) {
        super("R Image Output");
        this.setSize(500, 500);
        this.toMonitor = toMonitor;
        this.setResizable(false);
        try {
            File test = new File(toMonitor);
            test.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ip = new ImagePanel(this);
        this.getContentPane().add(this.ip);
        this.pack();
        this.validate();
    }

    @Override
    public void repaint() {
        super.repaint();
        try {
            File test = new File(this.toMonitor);
            if (test.exists() && test.length() > 5000L && test.lastModified() > this.lastModified) {
                this.show();
                this.bi = ImageIO.read(new FileInputStream(test));
                this.lastModified = test.lastModified();
                this.pack();
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    class ImagePanel
    extends JPanel {
        ImageMonitor im = null;

        public ImagePanel(ImageMonitor im) {
            this.im = im;
        }

        @Override
        public Dimension getMinimumSize() {
            if (ImageMonitor.this.bi == null) {
                return new Dimension(0, 0);
            }
            return new Dimension(ImageMonitor.this.bi.getWidth(), ImageMonitor.this.bi.getHeight());
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void paint(Graphics g) {
            try {
                if (ImageMonitor.this.bi != null) {
                    this.setSize(ImageMonitor.this.bi.getWidth(), ImageMonitor.this.bi.getHeight());
                    g.drawImage(ImageMonitor.this.bi, 0, 0, null);
                }
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
    }
}

