/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.r;

import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.r.GraphMap;
import com.hp.hpl.guess.r.ImageMonitor;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.StatusBar;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.rosuda.JRclient.REXP;
import org.rosuda.JRclient.RSrvException;
import org.rosuda.JRclient.Rconnection;

public class R {
    private static Rconnection c = null;
    private boolean trackImage = false;
    private String server = "127.0.0.1";
    private String imageMLoc = "/_output.jpg";
    private ImageMonitor myMon = null;
    private GraphMap gm = null;

    public GraphMap getGraphMap() {
        return this.gm;
    }

    public void initConnection(String server) {
        if (Guess.getGPLFreeMode()) {
            throw new Error("Running in GPL Free Mode, you will not be able to use this class");
        }
        this.server = server;
        this.initConnection();
    }

    public void initConnection() {
        try {
            this.myMon = new ImageMonitor(this.imageMLoc);
            c = new Rconnection(this.server);
            StatusBar.setStatus("R: Server vesion: " + c.getServerVersion());
            if (c.needLogin()) {
                c.login("guest", "guest");
            }
        }
        catch (RSrvException rse) {
            c = null;
            throw new Error(rse.getMessage());
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            c = null;
            throw new Error(e.getMessage());
        }
    }

    public boolean isConnected() {
        return c != null;
    }

    public Object __call__(Object o) {
        return null;
    }

    private Object unwrap(REXP rx) {
        if (rx == null) {
            return null;
        }
        int Xt = rx.getType();
        if (Xt == 3) {
            return rx.asString();
        }
        if (Xt == 1) {
            return new Integer(rx.asInt());
        }
        if (Xt == 2) {
            return new Double(rx.asDouble());
        }
        if (Xt == 16) {
            return rx.asVector();
        }
        if (Xt == 127) {
            return rx.asFactor();
        }
        if (Xt == 17) {
            return rx.asList();
        }
        if (Xt == 6) {
            return rx.asBool();
        }
        if (Xt == 33) {
            double[] t = rx.asDoubleArray();
            if (t.length == 1) {
                return new Double(t[0]);
            }
            return t;
        }
        if (Xt == 32) {
            int[] t = rx.asIntArray();
            if (t.length == 1) {
                return new Integer(t[0]);
            }
            return t;
        }
        double[][] matr = rx.asMatrix();
        if (matr != null) {
            return matr;
        }
        return rx;
    }

    public Object __getattr__(String fieldName) {
        if (!this.isConnected()) {
            this.initConnection();
        }
        if (!fieldName.startsWith("__")) {
            try {
                Object rx = this.evalString(fieldName);
                if (rx == null) {
                    return this;
                }
                return rx;
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
                return this;
            }
        }
        return this;
    }

    public void __setattr__(String fieldName, Object value) {
        block21: {
            if (!this.isConnected()) {
                this.initConnection();
            }
            if (!fieldName.startsWith("__")) {
                try {
                    if (value instanceof Double) {
                        this.evalString(fieldName + "<-" + value);
                        break block21;
                    }
                    if (value instanceof Integer) {
                        this.evalString(fieldName + "<-" + value);
                        break block21;
                    }
                    if (value instanceof double[][]) {
                        double[][] mdim = (double[][])value;
                        int m = mdim.length;
                        int n = mdim[0].length;
                        double[] newA = new double[m * n];
                        int loop = 0;
                        for (int i = 0; i < m; ++i) {
                            for (int j = 0; j < n; ++j) {
                                newA[loop] = mdim[i][j];
                            }
                        }
                        c.assign(fieldName, newA);
                        c.voidEval(fieldName + "<-matrix(" + fieldName + "," + m + "," + n + ")");
                        break block21;
                    }
                    if (value instanceof double[]) {
                        c.assign(fieldName, (double[])value);
                        break block21;
                    }
                    if (value instanceof int[]) {
                        c.assign(fieldName, (int[])value);
                        break block21;
                    }
                    if (value instanceof int[][]) {
                        int[][] mdim = (int[][])value;
                        int m = mdim.length;
                        int n = mdim[0].length;
                        int[] newA = new int[m * n];
                        int loop = 0;
                        for (int i = 0; i < m; ++i) {
                            for (int j = 0; j < n; ++j) {
                                newA[loop] = mdim[i][j];
                            }
                        }
                        c.assign(fieldName, newA);
                        c.voidEval(fieldName + "<-matrix(" + fieldName + "," + m + "," + n + ")");
                        break block21;
                    }
                    if (value instanceof Graph) {
                        this.gm = new GraphMap((Graph)((Object)value));
                        double[] conn = this.gm.getConn();
                        c.assign(fieldName, conn);
                        c.voidEval(fieldName + "<-matrix(" + fieldName + "," + this.gm.getNodeCount() + "," + this.gm.getNodeCount() + ")");
                        break block21;
                    }
                    if (value instanceof String) {
                        this.evalString(fieldName + "<-\"" + value + "\"");
                        break block21;
                    }
                    if (value instanceof PySequence) {
                        boolean str = false;
                        double[] vals = new double[((PySequence)value).__len__()];
                        for (int i = 0; i < ((PySequence)value).__len__(); ++i) {
                            Number d;
                            PyObject o = ((PySequence)value).__finditem__(i);
                            if (!(o instanceof PyInteger || o instanceof PyLong || o instanceof PyFloat)) {
                                throw new Error("Invalid type," + o.getClass() + " can't be sent to R as part of " + "an array");
                            }
                            if (o instanceof PyLong) {
                                d = (Long)((PyLong)o).__tojava__(Long.class);
                                vals[i] = ((Long)d).longValue();
                                continue;
                            }
                            if (o instanceof PyInteger) {
                                d = (Integer)((PyInteger)o).__tojava__(Integer.class);
                                vals[i] = ((Integer)d).intValue();
                                continue;
                            }
                            if (!(o instanceof PyFloat)) continue;
                            d = (Float)((PyFloat)o).__tojava__(Float.class);
                            vals[i] = ((Float)d).floatValue();
                        }
                        c.assign(fieldName, vals);
                        break block21;
                    }
                    throw new Error("Invalid R type");
                }
                catch (Exception e) {
                    throw new Error(e.toString());
                }
            }
        }
    }

    public void rmode(BufferedReader reader) {
        if (!this.isConnected()) {
            this.initConnection();
        }
        String toEval = R.readLine(reader);
        while (!toEval.equals(".")) {
            toEval = "paste(capture.output(print(" + toEval + ")),collapse=\"\\n\")";
            System.out.println(this.evalString(toEval));
            toEval = R.readLine(reader);
        }
    }

    private static String readLine(BufferedReader reader) {
        System.out.print("R> ");
        try {
            String s = reader.readLine();
            return s;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public Object evalString(String s) {
        block7: {
            s = "try(" + s + ")";
            REXP rx = null;
            try {
                if (s.length() > 1 && s.charAt(0) == '#') {
                    int i = (s = s.substring(1)).indexOf(32);
                    if (i < 1) {
                        int[] ti = new int[16];
                        for (int j = 0; j < 16; ++j) {
                            ti[j] = j == 0 ? 1 : ti[j - 1] * j;
                        }
                        REXP r = new REXP(32, ti);
                        c.assign(s, r);
                        System.out.println("assign(\"" + s + "\"," + r + ") OK");
                    } else {
                        c.assign(s.substring(0, i), s.substring(i + 1));
                        System.out.println("assign(\"" + s + "\") OK");
                    }
                    break block7;
                }
                c.eval("try(jpeg(\"" + this.imageMLoc + "\",quality=100))");
                rx = c.eval(s);
                c.eval("try(dev.off())");
                this.myMon.repaint();
                return this.unwrap(rx);
            }
            catch (RSrvException rse) {
                System.out.println("Rserve exception: " + rse.getMessage());
            }
            catch (Exception e) {
                System.out.println("Something went wrong, but it's not the Rserve: " + e.getMessage());
                ExceptionWindow.getExceptionWindow(e);
            }
        }
        return null;
    }

    public void shutdown() throws Exception {
        c.close();
    }

    public static void main(String[] arg) throws Exception {
        R myR = new R();
        myR.initConnection();
        BufferedReader ir = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("> ");
        String s = null;
        while ((s = ir.readLine()).length() > 0) {
            myR.evalString(s);
            System.out.print("> ");
        }
    }
}

