/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.storage;

import com.hp.hpl.guess.db.DBServer;
import com.hp.hpl.guess.storage.DumbStorage;
import com.hp.hpl.guess.storage.StorageListener;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.StatusBar;

public class StorageFactory {
    public static StorageListener singleton = null;

    public static StorageListener getSL() {
        if (singleton == null) {
            StatusBar.setStatus("Using basic storage engine (no DB)");
            StorageFactory.useDumbServer();
        }
        return singleton;
    }

    public static StorageListener useDBServer(String dbName) {
        if (singleton != null) {
            return singleton;
        }
        try {
            singleton = DBServer.init(dbName);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        return singleton;
    }

    public static StorageListener useDBServer() {
        if (singleton != null) {
            return singleton;
        }
        try {
            singleton = DBServer.initInMemory();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        return singleton;
    }

    public static void createEmpty() {
        try {
            if (singleton == null) {
                StorageFactory.useDBServer();
            }
            singleton.createEmpty();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public static void loadFromFile(String filename) {
        try {
            if (singleton == null) {
                StorageFactory.useDBServer();
            }
            singleton.loadFromFile(filename);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public static void loadFromText(String text) {
        try {
            if (singleton == null) {
                StorageFactory.useDBServer();
            }
            singleton.loadFromText(text);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public static StorageListener useDumbServer() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new DumbStorage();
        return singleton;
    }

    public static void shutdown() {
        if (singleton != null) {
            singleton.shutdown();
        }
        singleton = null;
    }
}

