/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.tg;

import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.NodeListener;
import com.touchgraph.graphlayout.Node;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;

public class TGNode
extends Node
implements NodeListener {
    public TGNode() {
    }

    public TGNode(String id) {
        super(id);
    }

    @Override
    public Object get(String field) {
        if (field.equals("label")) {
            return this.getLabel();
        }
        if (field.equals("color")) {
            return this.getBackColor();
        }
        if (field.equals("visible")) {
            return new Boolean(this.isVisible());
        }
        if (field.equals("fixed")) {
            return new Boolean(this.getFixed());
        }
        if (field.equals("style")) {
            return new Integer(this.getStyle());
        }
        if (field.equals("x")) {
            Point loc = this.getLocation();
            return new Double(((Point2D)loc).getX());
        }
        if (field.equals("y")) {
            Point loc = this.getLocation();
            return new Double(((Point2D)loc).getY());
        }
        if (field.equals("width")) {
            return new Double(this.getWidth());
        }
        if (field.equals("height")) {
            return new Double(this.getHeight());
        }
        return null;
    }

    @Override
    public void set(String field, Object o) {
        if (field.equals("label")) {
            this.setLabel((String)o);
        } else if (field.equals("color")) {
            if (o instanceof Color) {
                this.setBackColor((Color)o);
            } else {
                this.setBackColor(Colors.getColor((String)o, this.getBackColor()));
            }
        } else if (field.equals("visible")) {
            this.setVisible((Boolean)o);
        } else if (field.equals("fixed")) {
            this.setFixed((Boolean)o);
        } else if (field.equals("style")) {
            this.setStyle((Integer)o);
        } else if (field.equals("x")) {
            Point loc = this.getLocation();
            ((Point2D)loc).setLocation((Double)o, ((Point2D)loc).getY());
        } else if (field.equals("y")) {
            Point loc = this.getLocation();
            ((Point2D)loc).setLocation(((Point2D)loc).getX(), (Double)o);
        }
    }

    public void setBackColor(Color bg) {
        super.setBackColor(bg);
        double lum = (299 * bg.getRed() + 587 * bg.getGreen() + 114 * bg.getBlue()) / 1000;
        if (lum > 127.0) {
            this.setTextColor(Color.black);
        } else {
            this.setTextColor(Color.white);
        }
    }

    private int getStyle() {
        int t = this.getType();
        if (t == 4) {
            return 2;
        }
        if (t == 1) {
            return 1;
        }
        if (t == 2) {
            return 3;
        }
        return 2;
    }

    private void setStyle(int guessStyle) {
        if (guessStyle == 1 || guessStyle == 4) {
            this.setType(1);
        } else if (guessStyle == 3 || guessStyle == 6) {
            this.setType(2);
        } else {
            this.setType(3);
        }
    }

    @Override
    public void highlight(boolean state) {
    }

    @Override
    public void setLocation(double x, double y) {
    }

    @Override
    public void setLocation(double x, double y, double width, double height) {
    }
}

