/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.GuessColor;
import com.hp.hpl.guess.ui.StatusBar;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;

public abstract class Colors {
    public static Hashtable colors = new Hashtable();
    private static Random r;

    public static void main(String[] args) {
        ArrayList st = new ArrayList(colors.keySet());
        Collections.sort(st);
        System.out.println("<FONT FACE=ARIAL><TABLE>");
        int cnt = 0;
        Iterator it = st.iterator();
        while (it.hasNext()) {
            if (cnt == 0) {
                System.out.println("<TR>");
            }
            String s = (String)it.next();
            Color c = (Color)colors.get(s);
            String t = Colors.RGBtoHex(c);
            System.out.println("<TD BGCOLOR=" + t + ">" + "&nbsp;&nbsp;&nbsp;</TD><TD>" + s + " " + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "</TD>");
            if (++cnt != 4) continue;
            cnt = 0;
            System.out.println("</TR>");
        }
        System.out.println("</TABLE>");
    }

    public static String RGBtoHex(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String red = r < 20 ? "0" + Integer.toHexString(r) : Integer.toHexString(r);
        String green = g < 20 ? "0" + Integer.toHexString(g) : Integer.toHexString(g);
        String blue = b < 20 ? "0" + Integer.toHexString(b) : Integer.toHexString(b);
        String webcolor = "#" + red + green + blue + "";
        return webcolor.toUpperCase();
    }

    public static void putColor(String name, GuessColor clr) {
        name = name.toLowerCase();
        colors.put(name, clr);
        clr.setName(name);
    }

    public static Color getColor(String name, Color def) {
        if (name == null) {
            return def;
        }
        Color nc = (Color)colors.get(name = name.toLowerCase());
        if (nc == null) {
            StringTokenizer st = new StringTokenizer(name, ", ");
            if (st.countTokens() < 3 || st.countTokens() > 4) {
                nc = def;
            } else {
                try {
                    int r = Integer.parseInt(st.nextToken());
                    int g = Integer.parseInt(st.nextToken());
                    int b = Integer.parseInt(st.nextToken());
                    if (st.countTokens() == 0) {
                        nc = new GuessColor(r, g, b);
                    } else {
                        int a = Integer.parseInt(st.nextToken());
                        nc = new GuessColor(r, g, b, a);
                    }
                    colors.put(name, nc);
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                    StatusBar.setErrorStatus("Invalid color, using default");
                    nc = def;
                }
            }
        }
        return nc;
    }

    public static String toString(Color c) {
        if (c instanceof GuessColor) {
            return c.toString();
        }
        return c.getRed() + "," + c.getBlue() + "," + c.getGreen() + "," + c.getAlpha();
    }

    public static String randomColor() {
        return r.nextInt(255) + "," + r.nextInt(255) + "," + r.nextInt(255);
    }

    public static String randomColor(int alpha) {
        return r.nextInt(255) + "," + r.nextInt(255) + "," + r.nextInt(255) + "," + alpha;
    }

    public static String averageColor(String c1, String c2) {
        return Colors.averageColor(Colors.getColor(c1, Color.black), Colors.getColor(c2, Color.white));
    }

    public static String averageColor(Color c1, Color c2) {
        double avgR = c1.getRed() + c2.getRed();
        double avgB = c1.getBlue() + c2.getBlue();
        double avgG = c1.getGreen() + c2.getGreen();
        double avgA = c1.getAlpha() + c2.getAlpha();
        return (int)(avgR / 2.0) + "," + (int)(avgG / 2.0) + "," + (int)(avgB / 2.0) + "," + (int)(avgA / 2.0);
    }

    public static ArrayList generateColors(String startC, String endC, int inBetween) {
        return Colors.generateColors(Colors.getColor(startC, Color.red), Colors.getColor(endC, Color.blue), inBetween);
    }

    public static ArrayList generateColors(Color startColor, Color endColor, int inBetween) {
        ArrayList<String> al = new ArrayList<String>(inBetween);
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        double alpha = 0.0;
        for (int i = 0; i < inBetween; ++i) {
            double percent = (double)i / (double)(inBetween - 1);
            red = (double)startColor.getRed() + (double)(endColor.getRed() - startColor.getRed()) * percent;
            green = (double)startColor.getGreen() + (double)(endColor.getGreen() - startColor.getGreen()) * percent;
            blue = (double)startColor.getBlue() + (double)(endColor.getBlue() - startColor.getBlue()) * percent;
            alpha = (double)startColor.getAlpha() + (double)(endColor.getAlpha() - startColor.getAlpha()) * percent;
            red = Math.max(0.0, Math.min(red, 255.0));
            green = Math.max(0.0, Math.min(green, 255.0));
            blue = Math.max(0.0, Math.min(blue, 255.0));
            alpha = Math.max(0.0, Math.min(alpha, 255.0));
            al.add((int)red + "," + (int)green + "," + (int)blue + "," + (int)alpha);
        }
        return al;
    }

    public static ArrayList generateColors(String startC, String middleC, String endC, int inBetween) {
        return Colors.generateColors(Colors.getColor(startC, Color.red), Colors.getColor(middleC, Color.green), Colors.getColor(endC, Color.blue), inBetween);
    }

    public static ArrayList generateColors(Color sColor, Color mColor, Color eColor, int inBetween) {
        double percent;
        int i;
        ArrayList<String> al = new ArrayList<String>(inBetween);
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        double alpha = 0.0;
        int middle = inBetween / 2;
        Color startColor = sColor;
        Color endColor = mColor;
        for (i = 0; i < middle; ++i) {
            percent = (double)i / (double)(middle - 1);
            red = (double)startColor.getRed() + (double)(endColor.getRed() - startColor.getRed()) * percent;
            green = (double)startColor.getGreen() + (double)(endColor.getGreen() - startColor.getGreen()) * percent;
            blue = (double)startColor.getBlue() + (double)(endColor.getBlue() - startColor.getBlue()) * percent;
            alpha = (double)startColor.getAlpha() + (double)(endColor.getAlpha() - startColor.getAlpha()) * percent;
            red = Math.max(0.0, Math.min(red, 255.0));
            green = Math.max(0.0, Math.min(green, 255.0));
            blue = Math.max(0.0, Math.min(blue, 255.0));
            alpha = Math.max(0.0, Math.min(alpha, 255.0));
            al.add((int)red + "," + (int)green + "," + (int)blue + "," + (int)alpha);
        }
        startColor = mColor;
        endColor = eColor;
        for (i = middle; i < inBetween; ++i) {
            percent = (double)i / (double)(inBetween - 1);
            red = (double)startColor.getRed() + (double)(endColor.getRed() - startColor.getRed()) * percent;
            green = (double)startColor.getGreen() + (double)(endColor.getGreen() - startColor.getGreen()) * percent;
            blue = (double)startColor.getBlue() + (double)(endColor.getBlue() - startColor.getBlue()) * percent;
            alpha = (double)startColor.getAlpha() + (double)(endColor.getAlpha() - startColor.getAlpha()) * percent;
            red = Math.max(0.0, Math.min(red, 255.0));
            green = Math.max(0.0, Math.min(green, 255.0));
            blue = Math.max(0.0, Math.min(blue, 255.0));
            alpha = Math.max(0.0, Math.min(alpha, 255.0));
            al.add((int)red + "," + (int)green + "," + (int)blue + "," + (int)alpha);
        }
        return al;
    }

    static {
        Colors.putColor("black", new GuessColor(Color.black));
        Colors.putColor("blue", new GuessColor(Color.blue));
        Colors.putColor("cyan", new GuessColor(Color.cyan));
        Colors.putColor("darkGray", new GuessColor(Color.darkGray));
        Colors.putColor("gray", new GuessColor(Color.gray));
        Colors.putColor("green", new GuessColor(Color.green));
        Colors.putColor("lightGray", new GuessColor(Color.lightGray));
        Colors.putColor("magenta", new GuessColor(Color.magenta));
        Colors.putColor("orange", new GuessColor(Color.orange));
        Colors.putColor("pink", new GuessColor(Color.pink));
        Colors.putColor("red", new GuessColor(Color.red));
        Colors.putColor("white", new GuessColor(Color.white));
        Colors.putColor("yellow", new GuessColor(Color.yellow));
        Colors.putColor("GreenYellow", new GuessColor(236, 252, 151));
        Colors.putColor("Yellow", new GuessColor(255, 255, 0));
        Colors.putColor("Goldenrod", new GuessColor(253, 241, 112));
        Colors.putColor("Dandelion", new GuessColor(252, 216, 112));
        Colors.putColor("Apricot", new GuessColor(251, 213, 184));
        Colors.putColor("Peach", new GuessColor(252, 186, 148));
        Colors.putColor("Melon", new GuessColor(252, 192, 187));
        Colors.putColor("YellowOrange", new GuessColor(253, 198, 7));
        Colors.putColor("Orange", new GuessColor(255, 200, 0));
        Colors.putColor("BurntOrange", new GuessColor(253, 184, 7));
        Colors.putColor("Bittersweet", new GuessColor(223, 45, 2));
        Colors.putColor("RedOrange", new GuessColor(252, 130, 101));
        Colors.putColor("Mahogany", new GuessColor(209, 0, 2));
        Colors.putColor("Maroon", new GuessColor(213, 0, 31));
        Colors.putColor("BrickRed", new GuessColor(218, 1, 2));
        Colors.putColor("Red", new GuessColor(255, 0, 0));
        Colors.putColor("OrangeRed", new GuessColor(251, 11, 187));
        Colors.putColor("RubineRed", new GuessColor(250, 14, 239));
        Colors.putColor("WildStrawberry", new GuessColor(251, 59, 203));
        Colors.putColor("Salmon", new GuessColor(252, 181, 205));
        Colors.putColor("CarnationPink", new GuessColor(250, 163, 253));
        Colors.putColor("Magenta", new GuessColor(255, 0, 255));
        Colors.putColor("VioletRed", new GuessColor(250, 121, 253));
        Colors.putColor("Rhodamine", new GuessColor(250, 118, 253));
        Colors.putColor("Mulberry", new GuessColor(204, 82, 251));
        Colors.putColor("RedViolet", new GuessColor(197, 13, 211));
        Colors.putColor("Fuchsia", new GuessColor(174, 47, 244));
        Colors.putColor("Lavender", new GuessColor(251, 190, 254));
        Colors.putColor("Thistle", new GuessColor(237, 170, 253));
        Colors.putColor("Orchid", new GuessColor(210, 161, 253));
        Colors.putColor("DarkOrchid", new GuessColor(199, 124, 230));
        Colors.putColor("Purple", new GuessColor(191, 106, 253));
        Colors.putColor("Plum", new GuessColor(182, 18, 253));
        Colors.putColor("Violet", new GuessColor(119, 99, 253));
        Colors.putColor("RoyalPurple", new GuessColor(130, 91, 253));
        Colors.putColor("BlueViolet", new GuessColor(79, 66, 249));
        Colors.putColor("Periwinkle", new GuessColor(170, 178, 254));
        Colors.putColor("CadetBlue", new GuessColor(161, 174, 226));
        Colors.putColor("CornflowerBlue", new GuessColor(156, 238, 253));
        Colors.putColor("MidnightBlue", new GuessColor(0, 176, 198));
        Colors.putColor("NavyBlue", new GuessColor(57, 180, 254));
        Colors.putColor("RoyalBlue", new GuessColor(0, 187, 253));
        Colors.putColor("Blue", new GuessColor(0, 0, 255));
        Colors.putColor("Cerulean", new GuessColor(61, 240, 253));
        Colors.putColor("Cyan", new GuessColor(0, 255, 255));
        Colors.putColor("ProcessBlue", new GuessColor(46, 253, 253));
        Colors.putColor("SkyBlue", new GuessColor(162, 253, 240));
        Colors.putColor("Turquoise", new GuessColor(104, 253, 230));
        Colors.putColor("TealBlue", new GuessColor(95, 250, 208));
        Colors.putColor("Aquamarine", new GuessColor(115, 253, 217));
        Colors.putColor("BlueGreen", new GuessColor(106, 253, 212));
        Colors.putColor("Emerald", new GuessColor(0, 253, 187));
        Colors.putColor("JungleGreen", new GuessColor(23, 253, 184));
        Colors.putColor("SeaGreen", new GuessColor(150, 253, 187));
        Colors.putColor("Green", new GuessColor(0, 255, 0));
        Colors.putColor("ForestGreen", new GuessColor(39, 239, 34));
        Colors.putColor("PineGreen", new GuessColor(8, 222, 111));
        Colors.putColor("LimeGreen", new GuessColor(188, 252, 9));
        Colors.putColor("YellowGreen", new GuessColor(196, 252, 139));
        Colors.putColor("SpringGreen", new GuessColor(221, 252, 134));
        Colors.putColor("OliveGreen", new GuessColor(13, 201, 7));
        Colors.putColor("RawSienna", new GuessColor(194, 1, 1));
        Colors.putColor("Sepia", new GuessColor(147, 0, 1));
        Colors.putColor("Brown", new GuessColor(168, 0, 1));
        Colors.putColor("Tan", new GuessColor(236, 198, 176));
        Colors.putColor("Gray", new GuessColor(128, 128, 128));
        Colors.putColor("Black", new GuessColor(0, 0, 0));
        Colors.putColor("White", new GuessColor(255, 255, 255));
        Colors.putColor("LightYellow", new GuessColor(252, 252, 202));
        Colors.putColor("LightCyan", new GuessColor(227, 253, 254));
        Colors.putColor("LightMagenta", new GuessColor(251, 229, 254));
        Colors.putColor("LightPurple", new GuessColor(227, 229, 253));
        Colors.putColor("LightGreen", new GuessColor(228, 253, 216));
        Colors.putColor("LightOrange", new GuessColor(252, 229, 216));
        Colors.putColor("Canary", new GuessColor(251, 252, 187));
        Colors.putColor("LFadedGreen", new GuessColor(241, 253, 230));
        Colors.putColor("Pink", new GuessColor(255, 175, 175));
        Colors.putColor("LSkyBlue", new GuessColor(234, 247, 254));
        r = new Random();
    }
}

