/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.ui.ExceptionWindow;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.python.util.PythonInterpreter;

public class CommandStack
extends JPanel {
    PythonInterpreter interp = null;
    DefaultListModel model = null;
    JList list = null;
    Hashtable userFriendly = new Hashtable();
    String filename = null;

    public CommandStack(PythonInterpreter interp) {
        this(interp, null);
    }

    public CommandStack(PythonInterpreter interp, String filename) {
        this.interp = interp;
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        myML mListener = new myML(interp, this.list, this.userFriendly);
        this.list.addMouseListener(mListener);
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add((Component)scrollPane, "Center");
        if (filename != null) {
            this.filename = filename;
            this.load(filename);
        }
    }

    public void addCommand(String command) {
        this.model.addElement(command);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void addCommand(String command, String uf) {
        this.model.addElement(uf);
        this.userFriendly.put(uf, command);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void shutdown() {
        this.save(this.filename);
    }

    public void save(String filename) {
        if (filename != null) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
                Enumeration en = this.model.elements();
                while (en.hasMoreElements()) {
                    String elem = (String)en.nextElement();
                    bw.write(elem + "|");
                    if (this.userFriendly.containsKey(elem)) {
                        bw.write((String)this.userFriendly.get(elem));
                    }
                    bw.write("\n");
                }
                bw.close();
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
    }

    public void load(String filename) {
        if (filename != null) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                String line = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    int brk = line.indexOf("|");
                    String c1 = line.substring(0, brk);
                    String c2 = null;
                    try {
                        c2 = line.substring(brk + 1);
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    if (c2 == null || c2.equals("")) {
                        this.addCommand(c1);
                    } else {
                        this.addCommand(c2, c1);
                    }
                    this.setVisible(true);
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                ExceptionWindow.getExceptionWindow(e);
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
    }

    class myML
    extends MouseAdapter {
        PythonInterpreter interp = null;
        JList list = null;
        Hashtable userFriendly = null;

        public myML(PythonInterpreter interp, JList list, Hashtable uf) {
            this.interp = interp;
            this.list = list;
            this.userFriendly = uf;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            String selected = (String)this.list.getSelectedValue();
            if (this.userFriendly.containsKey(selected)) {
                this.interp.exec("" + this.userFriendly.get(selected));
            } else {
                this.interp.exec("" + selected);
            }
        }
    }
}

