/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.GuessJFrame;
import com.hp.hpl.guess.ui.SimpleButton;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DrawWindow
extends JPanel
implements Dockable,
ActionListener {
    private static DrawWindow singleton = null;
    public static final int RECTANGLE = 1;
    public static final int ELLIPSE = 2;
    public static final int RRECTANGLE = 3;
    public static final int TEXT = 4;
    public static final int SELECT = 5;
    public static final int LINE = 6;
    private static int tool = 1;
    private static Color myColor = Color.gray;
    private static Stroke myStroke = new BasicStroke(1.0f);
    private static int myArrow = 0;
    private static SimpleButton[] sbList = new SimpleButton[6];
    private JComboBox arrowJCB = null;
    private JComboBox styleJCB = null;
    private JComboBox widthJCB = null;
    private JButton colorBut = null;
    private JLabel jl = new JLabel("Draw Window", 0);
    private boolean visible = false;
    private GuessJFrame myParent = null;
    private static final float[] dashPattern = new float[]{30.0f, 10.0f, 10.0f, 10.0f};

    public static void setTool(int tool) {
        DrawWindow.tool = tool;
    }

    public static int getTool() {
        return tool;
    }

    public static Color getDrawColor() {
        return myColor;
    }

    public static Stroke getStroke() {
        return myStroke;
    }

    public static int getArrow() {
        return myArrow;
    }

    public static DrawWindow getDrawWindow() {
        if (singleton == null) {
            singleton = new DrawWindow("Draw Window");
        }
        return singleton;
    }

    public static void create() {
        Guess.getMainUIWindow().dock(DrawWindow.getDrawWindow());
    }

    public static void uncreate() {
        Guess.getMainUIWindow().close(DrawWindow.getDrawWindow());
    }

    @Override
    public int getDirectionPreference() {
        return 2;
    }

    @Override
    public void opening(boolean state) {
        this.visible = state;
    }

    @Override
    public void attaching(boolean state) {
    }

    @Override
    public String getTitle() {
        return "Draw Window";
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(80, 200);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(80, 200);
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        myArrow = this.arrowJCB.getSelectedIndex();
        double width = this.widthJCB.getSelectedIndex() + 1;
        int style = this.styleJCB.getSelectedIndex();
        myStroke = style == 0 ? new BasicStroke((float)width) : new BasicStroke((float)width, 0, 0, 10.0f, dashPattern, 0.0f);
    }

    private DrawWindow(String title) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JPanel stuff = new JPanel();
        stuff.setLayout(new GridLayout(2, 1));
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (int i = 0; i < sbList.length; ++i) {
                    sbList[i].click(false);
                }
                SimpleButton sb = (SimpleButton)e.getSource();
                sb.click(true);
                DrawWindow.setTool(sb.bType);
                FrameListener fl = VisFactory.getFactory().getDisplay();
                if (fl instanceof GFrame) {
                    if (sb.bType == 5) {
                        ((GFrame)fl).switchHandler(5);
                        DrawWindow.this.styleJCB.setEnabled(false);
                        DrawWindow.this.widthJCB.setEnabled(false);
                        DrawWindow.this.arrowJCB.setEnabled(false);
                        DrawWindow.this.colorBut.setEnabled(false);
                    } else {
                        ((GFrame)fl).switchHandler(4);
                        DrawWindow.this.styleJCB.setEnabled(true);
                        DrawWindow.this.widthJCB.setEnabled(true);
                        if (sb.bType == 6) {
                            DrawWindow.this.arrowJCB.setEnabled(true);
                        } else {
                            DrawWindow.this.arrowJCB.setEnabled(false);
                        }
                        DrawWindow.this.colorBut.setEnabled(true);
                    }
                }
            }
        };
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(3, 2));
        SimpleButton sb = new SimpleButton("drawsel.gif", 5, "Select objects");
        sb.addMouseListener(ma);
        buttonPanel.add(sb);
        DrawWindow.sbList[0] = sb;
        sb = new SimpleButton("s1.gif", 1, "Draw a square");
        sb.addMouseListener(ma);
        buttonPanel.add(sb);
        DrawWindow.sbList[1] = sb;
        sb.click(true);
        sb = new SimpleButton("e1.gif", 2, "Draw an ellipse");
        sb.addMouseListener(ma);
        buttonPanel.add(sb);
        DrawWindow.sbList[2] = sb;
        sb = new SimpleButton("rr1.gif", 3, "Draw a rounded rectangle");
        sb.addMouseListener(ma);
        buttonPanel.add(sb);
        DrawWindow.sbList[3] = sb;
        sb = new SimpleButton("line.gif", 6, "Draw a line");
        sb.addMouseListener(ma);
        buttonPanel.add(sb);
        DrawWindow.sbList[4] = sb;
        sb = new SimpleButton("a.gif", 4, "Add Text");
        sb.addMouseListener(ma);
        buttonPanel.add(sb);
        DrawWindow.sbList[5] = sb;
        stuff.add((Component)buttonPanel, c);
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new GridLayout(4, 1));
        this.styleJCB = new JComboBox();
        this.styleJCB.addItem(new ImageIcon(this.getClass().getResource("/images/linesolid.gif")));
        this.styleJCB.addItem(new ImageIcon(this.getClass().getResource("/images/linedash.gif")));
        selectionPanel.add(this.styleJCB);
        this.styleJCB.setToolTipText("Pick a line style");
        this.styleJCB.addActionListener(this);
        this.arrowJCB = new JComboBox();
        this.arrowJCB.addItem(new ImageIcon(this.getClass().getResource("/images/linenoarrow.gif")));
        this.arrowJCB.addItem(new ImageIcon(this.getClass().getResource("/images/line1arrow.gif")));
        this.arrowJCB.addItem(new ImageIcon(this.getClass().getResource("/images/line2arrow.gif")));
        this.arrowJCB.setToolTipText("Pick an arrow style");
        selectionPanel.add(this.arrowJCB);
        this.arrowJCB.setEnabled(false);
        this.arrowJCB.addActionListener(this);
        this.widthJCB = new JComboBox();
        this.widthJCB.addItem("1 px");
        this.widthJCB.addItem("2 px");
        this.widthJCB.addItem("3 px");
        this.widthJCB.addItem("4 px");
        this.widthJCB.addItem("5 px");
        this.widthJCB.addItem("6 px");
        this.widthJCB.setToolTipText("Pick a line width");
        selectionPanel.add(this.widthJCB);
        this.widthJCB.addActionListener(this);
        this.colorBut = new JButton(" ");
        this.colorBut.setBackground(myColor);
        this.colorBut.setToolTipText("Pick a color");
        selectionPanel.add(this.colorBut);
        this.colorBut.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JButton cb = (JButton)e.getSource();
                Color newCol = JColorChooser.showDialog(null, "Please pick a color", cb.getBackground());
                cb.setBackground(newCol);
                myColor = newCol;
            }
        });
        stuff.add(selectionPanel);
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)stuff, c);
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)new JPanel(), c);
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(50, 50, 80, 200);
    }
}

