/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Version;
import com.hp.hpl.guess.ui.StatusBar;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.python.core.PyException;

public class ExceptionWindow
extends JFrame {
    JTextArea eMain = new JTextArea();
    JLabel eLabel = new JLabel();
    JButton copyButton = new JButton();
    JButton forwardB = new JButton();
    JButton backB = new JButton();
    JScrollPane jscrollpane1 = null;
    private Vector exceptions = new Vector();
    private int location = 0;
    private static ExceptionWindow singleton = null;
    private Clipboard clipboard = null;

    public static ExceptionWindow getExceptionWindow() {
        return ExceptionWindow.getExceptionWindow(null);
    }

    public static ExceptionWindow getExceptionWindow(Throwable t) {
        if (singleton == null) {
            singleton = new ExceptionWindow();
        }
        singleton.newException(t);
        return singleton;
    }

    public void newException(Throwable t) {
        if (t != null) {
            this.exceptions.add(t);
            this.setLocation(this.exceptions.size() - 1);
            if (t instanceof PyException) {
                StatusBar.setErrorStatus(((PyException)t).userFriendlyString());
            } else {
                StatusBar.setErrorStatus(t.toString());
            }
        }
    }

    public void addToClipboard() {
        if (this.clipboard == null) {
            try {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Exception ex) {
                ExceptionWindow.getExceptionWindow(ex);
            }
        }
        if (this.clipboard != null) {
            try {
                StringSelection ss = new StringSelection(this.eMain.getText());
                this.clipboard.setContents(ss, ss);
            }
            catch (Exception ex) {
                ExceptionWindow.getExceptionWindow(ex);
            }
        }
    }

    private void setLocation(int loc) {
        this.location = loc;
        if (loc <= 0) {
            this.location = 0;
            this.backB.setEnabled(false);
        } else {
            this.backB.setEnabled(true);
        }
        if (loc >= this.exceptions.size() - 1) {
            this.location = this.exceptions.size() - 1;
            this.forwardB.setEnabled(false);
        } else {
            this.forwardB.setEnabled(true);
        }
        this.displayException((Throwable)this.exceptions.elementAt(this.location));
    }

    public void displayException(Throwable t) {
        if (t != null) {
            this.eMain.setText(ExceptionWindow.getStackTrace(t));
            if (t instanceof PyException) {
                this.eLabel.setText(((PyException)t).userFriendlyString());
            } else {
                this.eLabel.setText(t.toString());
            }
            this.eMain.setCaretPosition(0);
        }
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        printWriter.println("\n\nGUESS version: " + Version.MAJOR_VERSION + "/" + Version.MINOR_VERSION);
        return ((Object)result).toString();
    }

    private ExceptionWindow() {
        super("Error Log");
        this.setSize(550, 250);
        this.setLocation(100, 100);
        this.initializePanel();
        this.backB.setEnabled(false);
        this.forwardB.setEnabled(false);
        this.eMain.setEditable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExceptionWindow.this.setVisible(false);
            }
        });
        this.copyButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExceptionWindow.this.addToClipboard();
            }
        });
        this.backB.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExceptionWindow.this.setLocation(ExceptionWindow.this.location - 1);
            }
        });
        this.forwardB.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExceptionWindow.this.setLocation(ExceptionWindow.this.location + 1);
            }
        });
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    public ImageIcon loadImage(String imageName) {
        try {
            ClassLoader classloader = this.getClass().getClassLoader();
            URL url = classloader.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                return icon;
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        throw new IllegalArgumentException("Unable to load image: " + imageName);
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE,FILL:132PX:NONE,FILL:290PX:NONE,FILL:46PX:NONE,FILL:47PX:NONE,FILL:DEFAULT:NONE", "CENTER:4DLU:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:4DLU:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:4DLU:NONE,CENTER:DEFAULT:NONE,CENTER:4DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.eMain.setName("eMain");
        this.jscrollpane1 = new JScrollPane();
        this.jscrollpane1.setViewportView(this.eMain);
        this.jscrollpane1.setVerticalScrollBarPolicy(20);
        this.jscrollpane1.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)this.jscrollpane1, cc.xywh(2, 5, 4, 15));
        this.eLabel.setForeground(new Color(255, 0, 0));
        this.eLabel.setName("eLabel");
        this.eLabel.setText("No exception reported");
        jpanel1.add((Component)this.eLabel, cc.xywh(2, 2, 4, 2));
        this.copyButton.setActionCommand("Copy to clipboard");
        this.copyButton.setName("copyButton");
        this.copyButton.setText("Copy to clipboard");
        jpanel1.add((Component)this.copyButton, cc.xy(2, 21));
        this.forwardB.setActionCommand(">");
        this.forwardB.setName("forwardB");
        this.forwardB.setText(">");
        jpanel1.add((Component)this.forwardB, cc.xy(5, 21));
        this.backB.setActionCommand("<");
        this.backB.setName("backB");
        this.backB.setText("<");
        jpanel1.add((Component)this.backB, cc.xy(4, 21));
        this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5, 6}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22});
        return jpanel1;
    }

    protected void initializePanel() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createPanel(), "Center");
    }
}

