/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.VisFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class FieldModWindow
extends JFrame
implements TreeSelectionListener {
    final DefaultListModel model = new DefaultListModel();
    JTree attributeTree = new JTree(this.getTreeRoot());
    JTextField newValue = new JTextField();
    JList applyList = new JList(this.model);
    JButton okB = new JButton();
    JButton cancelB = new JButton();
    JButton selectB = new JButton();
    Collection nodes = null;
    Collection edges = null;
    boolean showingNodes = false;
    boolean showingEdges = false;
    Field selectedField = null;
    private static FieldModWindow singleton = null;

    public static FieldModWindow getFieldModWindow() {
        if (singleton == null) {
            singleton = new FieldModWindow();
        } else {
            singleton.setNE(Guess.getGraph().getNodes(), Guess.getGraph().getEdges());
        }
        return singleton;
    }

    public static FieldModWindow getFieldModWindow(Collection n, Collection e) {
        if (singleton == null) {
            singleton = new FieldModWindow(n, e);
        } else {
            singleton.setNE(n, e);
        }
        return singleton;
    }

    public void setNE(Collection nodes, Collection edges) {
        this.nodes = nodes;
        this.edges = edges;
        this.model.removeAllElements();
        if (this.selectedField != null) {
            this.showingNodes = false;
            this.showingEdges = false;
            this.valueChanged(null);
        }
    }

    private FieldModWindow() {
        this(Guess.getGraph().getNodes(), Guess.getGraph().getEdges());
    }

    private FieldModWindow(Collection nodes, Collection edges) {
        super("Field Editor");
        this.setNE(nodes, edges);
        this.setSize(440, 220);
        this.setLocation(100, 100);
        this.initializePanel();
        this.setVisible(true);
        this.getRootPane().setDefaultButton(this.cancelB);
        this.okB.setEnabled(false);
        this.attributeTree.getSelectionModel().setSelectionMode(1);
        this.attributeTree.addTreeSelectionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                singleton = null;
                FieldModWindow.this.dispose();
            }
        });
        this.applyList.setSelectionMode(2);
        this.okB.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FieldModWindow.this.applyToList();
            }
        });
        this.cancelB.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                singleton = null;
                FieldModWindow.this.dispose();
            }
        });
        this.selectB.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FieldModWindow.this.applyList.getSelectionModel().setSelectionInterval(0, FieldModWindow.this.model.getSize());
                FieldModWindow.this.applyList.repaint();
            }
        });
    }

    public Object newValueData() {
        if (this.selectedField.getSQLType() == 4 || this.selectedField.getSQLType() == -6 || this.selectedField.getSQLType() == 5 || this.selectedField.getSQLType() == -5) {
            return new Integer(this.newValue.getText());
        }
        if (this.selectedField.getSQLType() == 16) {
            return new Boolean(this.newValue.getText());
        }
        if (this.selectedField.isNumeric()) {
            return new Double(this.newValue.getText());
        }
        return this.newValue.getText();
    }

    public void applyToList() {
        int start = -1;
        int end = -1;
        try {
            start = this.applyList.getSelectionModel().getMinSelectionIndex();
            end = this.applyList.getSelectionModel().getMaxSelectionIndex();
            if (end >= this.model.getSize()) {
                end = this.model.getSize() - 1;
            }
            if (start == -1 || end == -1) {
                return;
            }
            for (int i = start; i <= end; ++i) {
                if (!this.applyList.isSelectedIndex(i)) continue;
                GraphElement o = (GraphElement)this.model.getElementAt(i);
                o.__setattr__(this.selectedField.getName(), this.newValueData());
            }
            VisFactory.getFactory().getDisplay().repaint();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(this, "Error setting value " + e.toString() + " range: (" + start + "-" + end + ")", "Error", 0);
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public static void main(String[] args) {
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    public ImageIcon loadImage(String imageName) {
        try {
            ClassLoader classloader = this.getClass().getClassLoader();
            URL url = classloader.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                return icon;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Unable to load image: " + imageName);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.attributeTree.getLastSelectedPathComponent();
        this.selectedField = null;
        this.okB.setEnabled(false);
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        if (o instanceof Field) {
            if (((Field)o).getType() == 1) {
                if (!this.showingNodes) {
                    this.loadData(this.nodes);
                }
                this.showingNodes = true;
                this.showingEdges = false;
            } else {
                if (!this.showingEdges) {
                    this.loadData(this.edges);
                }
                this.showingNodes = false;
                this.showingEdges = true;
            }
            this.selectedField = (Field)o;
            this.okB.setEnabled(true);
        }
    }

    public void loadData(Collection c) {
        this.model.removeAllElements();
        Iterator it = c.iterator();
        int last = 0;
        while (it.hasNext()) {
            this.model.addElement(it.next());
            ++last;
        }
        this.applyList.getSelectionModel().setSelectionInterval(0, this.model.getSize());
        this.applyList.repaint();
    }

    public DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode("Fields");
        DefaultMutableTreeNode nodeB = new DefaultMutableTreeNode("Node");
        ArrayList al = new ArrayList();
        al.addAll(Guess.getGraph().getNodeSchema().allFields());
        Collections.sort(al);
        for (Field f : al) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(f.getName());
            t.setUserObject(f);
            nodeB.add(t);
        }
        DefaultMutableTreeNode edgeB = new DefaultMutableTreeNode("Edge");
        Collection nEs = Guess.getGraph().getEdgeSchema().fieldNames();
        al = new ArrayList();
        al.addAll(Guess.getGraph().getEdgeSchema().allFields());
        Collections.sort(al);
        for (Field f : al) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(f.getName());
            t.setUserObject(f);
            edgeB.add(t);
        }
        dmtn.add(nodeB);
        dmtn.add(edgeB);
        return dmtn;
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE,FILL:71PX:NONE,FILL:4DLU:NONE,FILL:153PX:NONE,FILL:4DLU:NONE,FILL:69PX:NONE,FILL:4DLU:NONE,FILL:88PX:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:88PX:NONE,CENTER:4DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:4DLU:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.attributeTree.setName("attributeTree");
        JScrollPane jscrollpane1 = new JScrollPane();
        jscrollpane1.setViewportView(this.attributeTree);
        jscrollpane1.setVerticalScrollBarPolicy(20);
        jscrollpane1.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane1, cc.xywh(2, 3, 3, 3));
        JLabel jlabel1 = new JLabel();
        jlabel1.setText("Select Field...");
        jpanel1.add((Component)jlabel1, cc.xy(2, 2));
        JLabel jlabel2 = new JLabel();
        jlabel2.setText("New value:");
        jlabel2.setHorizontalAlignment(4);
        jpanel1.add((Component)jlabel2, cc.xy(2, 8));
        this.newValue.setName("newValue");
        jpanel1.add((Component)this.newValue, cc.xy(4, 8));
        JLabel jlabel3 = new JLabel();
        jlabel3.setText("Apply to...");
        jpanel1.add((Component)jlabel3, cc.xy(6, 2));
        this.applyList.setName("applyList");
        JScrollPane jscrollpane2 = new JScrollPane();
        jscrollpane2.setViewportView(this.applyList);
        jscrollpane2.setVerticalScrollBarPolicy(20);
        jscrollpane2.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane2, cc.xywh(6, 3, 3, 1));
        this.okB.setActionCommand("Apply");
        this.okB.setName("okB");
        this.okB.setText("Apply");
        jpanel1.add((Component)this.okB, cc.xy(6, 8));
        this.cancelB.setActionCommand("Done");
        this.cancelB.setName("cancelB");
        this.cancelB.setText("Done");
        jpanel1.add((Component)this.cancelB, cc.xy(8, 8));
        this.selectB.setActionCommand("Select All");
        this.selectB.setText("Select All");
        jpanel1.add((Component)this.selectB, cc.xywh(6, 5, 3, 1));
        this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        return jpanel1;
    }

    protected void initializePanel() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createPanel(), "Center");
    }
}

