/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.ui.StandardDialog;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontDialog
extends StandardDialog
implements ListSelectionListener,
ActionListener {
    private static final int MIN_SIZE = 6;
    private static final int MAX_SIZE = 72;
    private static final int DEFAULT_SIZE = 12;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static final Font BOLD_FONT = new Font("SansSerif", 1, 12);
    private static final int DIALOG_ICON_SIZE = 48;
    private static final int DIALOG_TEXT_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width / 4;
    private Font createdFont = DEFAULT_FONT;
    private boolean antialiased = false;
    private JLabel info;
    private JButton applyButton;
    private JPanel fontPanel;
    private JList fontList;
    private JList styleList;
    private JComboBox sizeDropDown;
    private final JCheckBox[] checkBoxes = null;
    private JCheckBox antialiasBox = new JCheckBox("Antialiased");
    private JTextArea textArea = new JTextArea(){

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, FontDialog.this.antialiased ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            super.paint(g2);
        }
    };
    private static FontDialog singleton = null;
    private static PText node = null;

    public static FontDialog getDialog() {
        if (singleton == null) {
            singleton = new FontDialog();
        }
        return singleton;
    }

    public static FontDialog getDialog(PText n) {
        if (singleton == null) {
            singleton = new FontDialog();
        }
        node = n;
        singleton.apply();
        singleton.setModal(true);
        singleton.show();
        return singleton;
    }

    private FontDialog() {
        super((JFrame)null, "Font Selection");
        this.createGui();
        this.update();
    }

    public final void setAntialiased(boolean aFlag) {
        if (this.antialiased != aFlag) {
            this.antialiased = aFlag;
            this.antialiasBox.setSelected(aFlag);
            this.invalidate();
        }
    }

    public final boolean isAntialiased() {
        return this.antialiased;
    }

    @Override
    public final Font getFont() {
        if (this.getResult() == 1) {
            return this.createdFont;
        }
        return null;
    }

    public String getText() {
        return this.textArea.getText().trim();
    }

    public void apply() {
        if (node != null) {
            node.setText(this.getText());
            node.setFont(this.createdFont);
            VisFactory.getFactory().getDisplay().repaint();
        }
    }

    @Override
    protected void approve() {
        super.approve();
        if (node != null) {
            node.setText(this.getText());
            node.setFont(this.createdFont);
        }
        node = null;
    }

    @Override
    protected void abort() {
        super.abort();
        node = null;
    }

    @Override
    protected void cancel() {
        super.cancel();
        if (node != null) {
            node.removeFromParent();
        }
        node = null;
    }

    private void createGui() {
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
        this.setUndecorated(false);
        this.setResizable(true);
        this.setDefaultBorder();
        this.fontPanel = this.createFontPanel();
        this.main.add((Component)this.fontPanel, "Center");
        this.antialiasBox.setSelected(this.antialiased);
        this.antialiasBox.addActionListener(this);
        this.fontList.setSelectedIndex(0);
        this.fontList.addListSelectionListener(this);
        this.sizeDropDown.setSelectedIndex(6);
        this.sizeDropDown.addActionListener(this);
        this.styleList.setSelectedIndex(0);
        this.styleList.addListSelectionListener(this);
        this.textArea.setText("Enter your text here...");
        this.applyButton = new JButton("Apply");
        this.addLeftButton(this.applyButton);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontDialog.this.apply();
            }
        });
        this.pack();
    }

    private JLabel createLabel(String text, int top, int leftSpace) {
        JLabel label = new JLabel(text);
        label.setFont(BOLD_FONT);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        label.setBorder(new EmptyBorder(top, leftSpace, 0, 10));
        return label;
    }

    private JPanel createFontPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 23;
        gc.fill = 1;
        gc.insets = new Insets(2, 2, 2, 2);
        gc.gridheight = 4;
        gc.weightx = 0.8;
        gc.weighty = 1.0;
        panel.add((Component)this.createFontList(), gc);
        gc.gridheight = 1;
        ++gc.gridx;
        gc.weightx = 0.2;
        gc.weighty = 0.0;
        JLabel sizeLabel = this.createLabel("Size:", 0, 10);
        panel.add((Component)sizeLabel, gc);
        ++gc.gridx;
        panel.add((Component)this.createSizeComp(), gc);
        gc.gridx = 1;
        ++gc.gridy;
        JLabel styleLabel = this.createLabel("Style:", 0, 10);
        panel.add((Component)styleLabel, gc);
        ++gc.gridx;
        panel.add((Component)this.createStyleList(), gc);
        JPanel p = new JPanel(new GridLayout(0, 1));
        gc.gridx = 2;
        ++gc.gridy;
        panel.add((Component)p, gc);
        if (this.checkBoxes != null) {
            int boxes = this.checkBoxes.length;
            for (int i = 0; i < boxes; ++i) {
                p.add(this.checkBoxes[i]);
            }
        }
        ++gc.gridy;
        panel.add(Box.createVerticalGlue(), gc);
        gc.gridx = 0;
        ++gc.gridy;
        JLabel textLabel = this.createLabel("Text:", 10, 0);
        panel.add((Component)textLabel, gc);
        gc.weightx = 0.5;
        gc.weighty = 0.5;
        ++gc.gridy;
        gc.gridwidth = 3;
        panel.add((Component)this.createTextComp(), gc);
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        ++gc.gridy;
        this.info = this.createLabel(" ", 10, 0);
        this.info.setBorder(null);
        this.info.setFont(DEFAULT_FONT);
        panel.add((Component)this.info, gc);
        return panel;
    }

    public static Rectangle getStringWidth(String aText, Font f, boolean antiAliased) {
        FontRenderContext rc = new FontRenderContext(null, antiAliased, true);
        Rectangle2D r2d = f.getStringBounds(aText, rc);
        Rectangle r = new Rectangle();
        r.x = (int)Math.round(r2d.getX());
        r.y = (int)Math.round(r2d.getY());
        r.width = (int)Math.round(r2d.getWidth());
        r.height = (int)Math.round(r2d.getHeight());
        return r;
    }

    private JComponent createSizeComp() {
        ArrayList<SizeEntry> list = new ArrayList<SizeEntry>();
        for (int i = 6; i < 72; ++i) {
            list.add(new SizeEntry(new Integer(i)));
        }
        SizeEntry[] entries = new SizeEntry[list.size()];
        list.toArray(entries);
        this.sizeDropDown = new JComboBox<SizeEntry>(entries);
        this.sizeDropDown.setEditable(true);
        Rectangle r = FontDialog.getStringWidth("7777", DEFAULT_FONT, true);
        Dimension dim = this.sizeDropDown.getPreferredSize();
        dim.width = r.width;
        this.sizeDropDown.setPreferredSize(dim);
        return this.sizeDropDown;
    }

    private JComponent createTextComp() {
        this.textArea.setFont(DEFAULT_FONT);
        JScrollPane pane = new JScrollPane(this.textArea);
        pane.setPreferredSize(new Dimension(160, 80));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)pane, "Center");
        return p;
    }

    private JComponent createFontList() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = env.getAvailableFontFamilyNames();
        int count = fontNames.length;
        FontEntry[] entries = new FontEntry[count];
        for (int i = 0; i < count; ++i) {
            entries[i] = new FontEntry(fontNames[i]);
        }
        this.fontList = new JList<FontEntry>(entries);
        JScrollPane pane = new JScrollPane(this.fontList);
        return pane;
    }

    private JComponent createStyleList() {
        ArrayList<StyleEntry> list = new ArrayList<StyleEntry>();
        list.add(new StyleEntry("Plain", 0));
        list.add(new StyleEntry("Bold", 1));
        list.add(new StyleEntry("Italic", 2));
        list.add(new StyleEntry("Bold+Italic", 3));
        StyleEntry[] entries = new StyleEntry[list.size()];
        list.toArray(entries);
        this.styleList = new JList<StyleEntry>(entries);
        this.styleList.setBorder(new SoftBevelBorder(1));
        return this.styleList;
    }

    private String getFontString(Font f) {
        StringBuffer buf = new StringBuffer();
        buf.append(f.getName());
        buf.append(", ");
        buf.append(f.getSize());
        buf.append(", ");
        StringBuffer style = new StringBuffer();
        style.append(f.isPlain() ? "plain " : "");
        if (f.isBold() && f.isItalic()) {
            style.append("bold+italic");
        } else {
            style.append(f.isBold() ? "bold " : "");
            style.append(f.isItalic() ? "italic " : "");
        }
        buf.append(style.toString());
        return buf.toString();
    }

    public static int asInt(String s) {
        return FontDialog.asInt(s, 10);
    }

    public static int asInt(String s, int radix) {
        return FontDialog.asInt(s, radix, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int asInt(String s, int radix, int min, int max) {
        if (FontDialog.isNumber(s, radix, min, max)) {
            return Integer.parseInt(s, radix);
        }
        return 0;
    }

    public static boolean isNumber(String aNumber, int radix) {
        return FontDialog.isNumber(aNumber, radix, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static boolean isNumber(String aNumber, int min, int max) {
        return FontDialog.isNumber(aNumber, 10, min, max);
    }

    public static boolean isNumber(String aNumber, int radix, int min, int max) {
        if (aNumber == null) {
            return false;
        }
        String s = aNumber.trim();
        if (s.length() == 0) {
            return false;
        }
        try {
            int i = Integer.parseInt(aNumber, radix);
            return i >= min && i <= max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected void update() {
        String s;
        Font f = DEFAULT_FONT;
        this.antialiased = this.antialiasBox.isSelected();
        FontEntry font = (FontEntry)this.fontList.getSelectedValue();
        SizeEntry size = null;
        Object o = this.sizeDropDown.getSelectedItem();
        if (o instanceof SizeEntry) {
            size = (SizeEntry)o;
        } else if (o instanceof String && FontDialog.isNumber(s = (String)o, 1, 300)) {
            size = new SizeEntry(new Integer(FontDialog.asInt(s)));
        }
        StyleEntry style = (StyleEntry)this.styleList.getSelectedValue();
        if (font != null && size != null && style != null) {
            try {
                f = new Font(font.toString(), style.style, size.size);
            }
            catch (ArithmeticException e) {
                // empty catch block
            }
        }
        this.createdFont = f;
        this.textArea.setFont(f);
        this.info.setText(this.getFontString(f));
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }

    public final void setFontBackground(Color colour) {
        this.textArea.setOpaque(colour.getAlpha() == 255);
        this.textArea.setBackground(colour);
    }

    public final void setFontForeground(Color colour) {
        this.textArea.setForeground(colour);
    }

    private final class StyleEntry {
        public final int style;
        public final String name;

        public StyleEntry(String aName, int aStyle) {
            this.name = aName;
            this.style = aStyle;
        }

        public String toString() {
            return this.name;
        }
    }

    private final class SizeEntry {
        public final Integer size;

        public SizeEntry(Integer aSize) {
            this.size = aSize;
        }

        public String toString() {
            return String.valueOf(this.size);
        }
    }

    private final class FontEntry {
        public final String fontName;

        public FontEntry(String aFont) {
            this.fontName = aFont;
        }

        public String toString() {
            return this.fontName;
        }
    }
}

