/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.Version;
import com.hp.hpl.guess.freehep.HEPDialog;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.FieldModWindow;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.InfoWindow;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.SunFileFilter;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class GMenuBar
extends JMenuBar {
    String[] fileItems = new String[]{"Export Image...", "Export Screenshot...", "Run Script...", "Save GDF..."};
    char[] fileShortcuts = new char[]{'I', 'S', 'R'};
    String[] layoutItems = new String[]{"Bin Pack", "GEM", "Circular", "Physics", "Kamada-Kawai", "Fruchterman-Rheingold", "Spring", "MDS", "Random", "Radial"};
    JCheckBoxMenuItem logItem = new JCheckBoxMenuItem("Log...");
    HEPDialog hd = new HEPDialog(null);
    protected JMenu fileMenu = new JMenu("File");
    protected JMenu editMenu = new JMenu("Edit");
    protected JMenu displayMenu = new JMenu("Display");
    protected JMenu layoutMenu = new JMenu("Layout");
    protected JMenu helpMenu = new JMenu("Help");
    File prevRun = null;
    File prevLog = null;
    File prevGDF = null;
    File prevLoad = null;

    public String getInputFromUser(Object question, String title, Object def) {
        String toRet = JOptionPane.showInputDialog(question, def);
        return toRet;
    }

    public boolean displayProtected() {
        return !Guess.getAppletMode() || Guess.getSignedAppletMode();
    }

    public GMenuBar() {
        this.putClientProperty("jgoodies.headerStyle", Boolean.TRUE);
        ActionListener displayListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Background Color")) {
                    FrameListener fl = VisFactory.getFactory().getDisplay();
                    Color c = JColorChooser.showDialog(null, "Please pick a color", fl.getDisplayBackground());
                    if (c != null) {
                        fl.setDisplayBackground(c);
                        StatusBar.setStatus("v.setDisplayBackground(\"" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "\")");
                    }
                } else if (event.getActionCommand().equals("Information Window")) {
                    InfoWindow.create();
                } else if (event.getActionCommand().equals("Center")) {
                    VisFactory.getFactory().getDisplay().center();
                } else if (event.getActionCommand().equals("Toggle Arrows")) {
                    VisFactory.getFactory().setDirected(!VisFactory.getFactory().getDirected());
                }
            }
        };
        JMenuItem bgcolor = new JMenuItem("Center");
        bgcolor.addActionListener(displayListener);
        this.displayMenu.add(bgcolor);
        bgcolor = new JMenuItem("Background Color");
        bgcolor.addActionListener(displayListener);
        this.displayMenu.add(bgcolor);
        bgcolor = new JMenuItem("Information Window");
        bgcolor.addActionListener(displayListener);
        this.displayMenu.add(bgcolor);
        bgcolor = new JMenuItem("Toggle Arrows");
        bgcolor.addActionListener(displayListener);
        this.displayMenu.add(bgcolor);
        ActionListener printListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Exit")) {
                    Guess.shutdown();
                } else if (event.getActionCommand().equals("Export Image...")) {
                    if (VisFactory.getUIMode() == 1) {
                        GMenuBar.this.hd.showHEPDialog(null, "Export Image", (Component)((Object)((GFrame)VisFactory.getFactory().getDisplay())), "output.jpg", true);
                    } else {
                        StatusBar.setErrorStatus("This method is only supported in piccolo mode right now");
                    }
                } else if (event.getActionCommand().equals("Export Screenshot...")) {
                    GMenuBar.this.hd.showHEPDialog(null, "Export Screenshot", (Component)((Object)((GFrame)VisFactory.getFactory().getDisplay())), "output.jpg", false);
                } else if (event.getActionCommand().equals("Run Script...")) {
                    GMenuBar.this.runScript();
                } else if (event.getActionCommand().equals("Save GDF...")) {
                    GMenuBar.this.saveGDF();
                } else if (event.getActionCommand().equals("Log...")) {
                    GMenuBar.this.logToggle();
                }
            }
        };
        ActionListener loadListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("GDF")) {
                    GMenuBar.this.loadFromFile("GDF");
                } else if (event.getActionCommand().equals("XML/GML")) {
                    GMenuBar.this.loadFromFile("XML");
                } else if (event.getActionCommand().equals("Pajek")) {
                    GMenuBar.this.loadFromFile("Pajek");
                }
            }
        };
        JMenu load = new JMenu("Load from file");
        JMenuItem l1 = new JMenuItem("GDF");
        l1.addActionListener(loadListener);
        load.add(l1);
        l1 = new JMenuItem("XML/GML");
        l1.addActionListener(loadListener);
        load.add(l1);
        l1 = new JMenuItem("Pajek");
        l1.addActionListener(loadListener);
        load.add(l1);
        this.fileMenu.add(load);
        if (!this.displayProtected()) {
            load.setEnabled(false);
        }
        for (int i = 0; i < this.fileItems.length; ++i) {
            JMenuItem item = null;
            if (i < this.fileShortcuts.length) {
                item = new JMenuItem(this.fileItems[i], this.fileShortcuts[i]);
                item.setAccelerator(KeyStroke.getKeyStroke(this.fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            } else {
                item = new JMenuItem(this.fileItems[i]);
            }
            item.addActionListener(printListener);
            this.fileMenu.add(item);
            if (this.displayProtected()) continue;
            item.setEnabled(false);
        }
        this.logItem.addActionListener(printListener);
        this.fileMenu.add(this.logItem);
        if (!this.displayProtected()) {
            this.logItem.setEnabled(false);
        }
        JMenuItem item2 = new JMenuItem("Exit");
        item2.addActionListener(printListener);
        this.fileMenu.add(item2);
        ActionListener layoutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String command = event.getActionCommand();
                StatusBar.runProgressBar(true);
                try {
                    if (command.equals("GEM")) {
                        Guess.getGraph().gemLayout();
                    } else if (command.equals("Radial")) {
                        String centerN = GMenuBar.this.getInputFromUser("Please enter a node to use a the center", "User input", "");
                        if (centerN != null) {
                            Node x = Guess.getGraph().getNodeByName(centerN);
                            if (x != null) {
                                Guess.getGraph().radialLayout(x);
                                StatusBar.setStatus("radialLayout(" + centerN + ")");
                            } else {
                                StatusBar.setErrorStatus("Can't find node named " + centerN);
                            }
                        }
                    } else if (command.equals("Circular")) {
                        Guess.getGraph().circleLayout();
                        StatusBar.setStatus("circleLayout()");
                    } else if (command.equals("Physics")) {
                        Guess.getGraph().physicsLayout();
                        StatusBar.setStatus("physicsLayout()");
                    } else if (command.equals("Kamada-Kawai")) {
                        Guess.getGraph().jkkLayout1();
                        StatusBar.setStatus("jkkLayout1()");
                    } else if (command.equals("Fruchterman-Rheingold")) {
                        Guess.getGraph().frLayout();
                        StatusBar.setStatus("frLayout()");
                    } else if (command.equals("Spring")) {
                        Guess.getGraph().springLayout();
                        StatusBar.setStatus("springLayout()");
                    } else if (command.equals("MDS")) {
                        Guess.getGraph().mdsLayout();
                        StatusBar.setStatus("mdsLayout()");
                    } else if (command.equals("Random")) {
                        Guess.getGraph().randomLayout();
                        StatusBar.setStatus("randomLayout()");
                    } else if (command.equals("Bin Pack")) {
                        Guess.getGraph().binPackLayout();
                        StatusBar.setStatus("binPackLayout()");
                    }
                }
                catch (Exception e) {
                    StatusBar.setErrorStatus(e.toString());
                }
                StatusBar.runProgressBar(false);
            }
        };
        for (int i = 0; i < this.layoutItems.length; ++i) {
            JMenuItem item = new JMenuItem(this.layoutItems[i]);
            item.addActionListener(layoutListener);
            this.layoutMenu.add(item);
        }
        ActionListener helpListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("About GUESS")) {
                    JOptionPane.showMessageDialog(null, "Major version: " + Version.MAJOR_VERSION + "\nMinor version: " + Version.MINOR_VERSION);
                } else if (event.getActionCommand().equals("Error Log")) {
                    ExceptionWindow.getExceptionWindow(null).setVisible(true);
                }
            }
        };
        JMenuItem ver = new JMenuItem("Error Log");
        ver.addActionListener(helpListener);
        this.helpMenu.add(ver);
        ver = new JMenuItem("About GUESS");
        ver.addActionListener(helpListener);
        this.helpMenu.add(ver);
        ActionListener editListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Modify Field...")) {
                    FieldModWindow.getFieldModWindow();
                }
            }
        };
        ver = new JMenuItem("Modify Field...");
        ver.addActionListener(editListener);
        this.editMenu.add(ver);
        super.add(this.fileMenu);
        super.add(this.editMenu);
        super.add(this.displayMenu);
        super.add(this.layoutMenu);
        super.add(this.helpMenu);
    }

    @Override
    public JMenu add(JMenu c) {
        JMenu temp = this.getMenu(this.getMenuCount() - 1);
        if (temp == this.helpMenu) {
            this.remove(this.getMenuCount() - 1);
        }
        super.add(c);
        super.add(this.helpMenu);
        return c;
    }

    public void runScript() {
        SunFileFilter filter = new SunFileFilter();
        try {
            if (this.prevRun == null) {
                this.prevRun = new File(".");
            }
            JFileChooser chooser = new JFileChooser(this.prevRun.getCanonicalPath());
            filter.addExtension("py");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                Guess.getInterpreter().execfile(fileName);
                this.prevRun = new File(fileName);
            }
        }
        catch (IOException e) {
            ExceptionWindow.getExceptionWindow(e);
            JOptionPane.showMessageDialog(null, "Error loading file " + e, "Error", 0);
        }
    }

    public void saveGDF() {
        SunFileFilter filter = new SunFileFilter();
        try {
            if (this.prevGDF == null) {
                this.prevGDF = new File(".");
            }
            JFileChooser chooser = new JFileChooser(this.prevGDF.getCanonicalPath());
            filter.addExtension("gdf");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                Guess.getGraph().exportGDF(fileName);
                this.prevGDF = new File(fileName);
            }
        }
        catch (IOException e) {
            ExceptionWindow.getExceptionWindow(e);
            JOptionPane.showMessageDialog(null, "Error saving file " + e, "Error", 0);
        }
    }

    public void loadFromFile(String type) {
        SunFileFilter filter = new SunFileFilter();
        try {
            if (this.prevLoad == null) {
                this.prevLoad = new File(".");
            }
            JFileChooser chooser = new JFileChooser(this.prevLoad.getCanonicalPath());
            if (type.equals("GDF")) {
                filter.addExtension("gdf");
            } else if (type.equals("XML")) {
                filter.addExtension("xml");
                filter.addExtension("gml");
                filter.addExtension("graphml");
            } else if (type.equals("Pajek")) {
                filter.addExtension("net");
            }
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                if (type.equals("GDF")) {
                    Guess.getGraph().makeFromGDF(fileName);
                } else if (type.equals("XML")) {
                    Guess.getGraph().makeFromGML(fileName);
                } else if (type.equals("Pajek")) {
                    Guess.getGraph().makeFromPajek(fileName);
                }
                this.prevLoad = new File(fileName);
                VisFactory.getFactory().getDisplay().center();
            }
        }
        catch (IOException e) {
            ExceptionWindow.getExceptionWindow(e);
            JOptionPane.showMessageDialog(null, "Error loading file " + e, "Error", 0);
        }
    }

    public void logToggle() {
        SunFileFilter filter = new SunFileFilter();
        if (!this.logItem.isSelected()) {
            Guess.getInterpreter().stoplog();
            this.logItem.setSelected(false);
            StatusBar.setStatus("Logging stopped...");
            return;
        }
        try {
            if (this.prevLog == null) {
                this.prevLog = new File(".");
            }
            JFileChooser chooser = new JFileChooser(this.prevLog.getCanonicalPath());
            filter.addExtension("py");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                int yn;
                File f = chooser.getSelectedFile();
                String fileExtension = filter.getExtension(f);
                String fileName = f.getAbsolutePath();
                if (fileExtension == null) {
                    fileName = fileName + ".py";
                    f = new File(fileName);
                }
                if (f.exists() && (yn = JOptionPane.showConfirmDialog(null, "File " + fileName + " exists, overwrite?", "Exists", 0)) == 1) {
                    return;
                }
                Guess.getInterpreter().log(fileName);
                this.prevLog = new File(fileName);
                this.logItem.setSelected(true);
                StatusBar.setStatus("Logging started...");
            }
        }
        catch (IOException e) {
            ExceptionWindow.getExceptionWindow(e);
            JOptionPane.showMessageDialog(null, "Error loading file " + e, "Error", 0);
        }
    }
}

