/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.InterpreterAbstraction;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.EditorPopup;
import com.hp.hpl.guess.ui.FieldModWindow;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class GraphElementEditorPopup
extends EditorPopup {
    String[] menuItems = new String[]{"Center On...", "Color...", "Remove", "Add", "Modify Field...", "Copy as Variable..."};
    public static EditorPopup singleton = null;

    @Override
    public String getHeader() {
        return "Node/Edge Options";
    }

    public static JMenuItem addItem(String s) {
        EditorPopup ep = GraphElementEditorPopup.getPopup();
        if (!ep.sep) {
            ep.addSeparator();
            ep.sep = true;
        }
        JMenuItem jmi = ep.createJMI(s);
        ep.add(jmi);
        return jmi;
    }

    public static EditorPopup getPopup() {
        if (singleton == null) {
            singleton = new GraphElementEditorPopup(Guess.getInterpreter());
        }
        return singleton;
    }

    protected GraphElementEditorPopup(InterpreterAbstraction jython2) {
        super(jython2);
        this.setLabel("Graph Element Menu");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String ac = event.getActionCommand();
                if (ac.equals("Center On...")) {
                    GraphElementEditorPopup.this.centerOn();
                } else if (ac.equals("Color...")) {
                    GraphElementEditorPopup.this.colorSelected();
                } else if (ac.equals("Copy as Variable...")) {
                    GraphElementEditorPopup.this.copyAsVariable();
                } else if (ac.equals("Add")) {
                    GraphElementEditorPopup.this.addSelected();
                } else if (ac.equals("Remove")) {
                    GraphElementEditorPopup.this.removeSelected();
                } else if (ac.equals("Modify Field...")) {
                    GraphElementEditorPopup.this.modifyWindow();
                }
            }
        };
        for (int i = 0; i < this.menuItems.length; ++i) {
            JMenuItem jmi1 = this.add(this.menuItems[i]);
            jmi1.addActionListener(al);
        }
    }

    public void modifyWindow() {
        HashSet<GraphElement> nodes = new HashSet<GraphElement>();
        HashSet<GraphElement> edges = new HashSet<GraphElement>();
        for (GraphElement ge : this.selected) {
            if (ge instanceof Node) {
                nodes.add(ge);
                continue;
            }
            if (!(ge instanceof Edge)) continue;
            edges.add(ge);
        }
        FieldModWindow.getFieldModWindow(nodes, edges);
    }

    public void addSelected() {
        if (this.selected != null) {
            for (GraphElement ge : this.selected) {
                if (ge instanceof Node) {
                    Guess.getGraph().addNode((Node)ge);
                    continue;
                }
                if (!(ge instanceof Edge)) continue;
                Guess.getGraph().addEdge((Edge)ge);
            }
        }
    }

    public void removeSelected() {
        if (this.selected != null) {
            for (GraphElement ge : this.selected) {
                if (ge instanceof Node) {
                    Guess.getGraph().removeNode((Node)ge);
                    continue;
                }
                if (!(ge instanceof Edge)) continue;
                Guess.getGraph().removeEdge((Edge)ge);
            }
        }
    }

    public void copyAsVariable() {
        String s;
        if (this.currentH == null) {
            return;
        }
        String ch = this.currentH.toString();
        if (ch.length() > 60) {
            ch = ch.substring(0, 60) + "...";
        }
        if ((s = (String)JOptionPane.showInputDialog(null, "Please enter a variable name for:\n" + ch, "Customized Dialog", -1, UIManager.getIcon("OptionPane.questionIcon"), null, "")) != null && s.length() > 0) {
            this.jython.set(s, this.currentH);
            StatusBar.setStatus(s + " = " + this.currentH);
        }
    }

    public void colorSelected() {
        Color c = JColorChooser.showDialog(null, "Please pick a color", Color.yellow);
        if (this.selected == null) {
            return;
        }
        if (c != null) {
            String col = c.getRed() + "," + c.getGreen() + "," + c.getBlue();
            for (GraphElement ge : this.selected) {
                ge.__setattr__("color", col);
            }
        }
    }

    public void centerOn() {
        if (this.selected == null) {
            return;
        }
        VisFactory.getFactory().getDisplay().center(this.selected);
    }
}

