/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.GraphMouseListener;
import com.hp.hpl.guess.ui.UIListener;
import java.util.HashSet;
import java.util.Iterator;

public class GraphEvents {
    private static GraphEvents singleton = null;
    private HashSet gmls = new HashSet();

    public static GraphEvents getGraphEvents() {
        if (singleton == null) {
            singleton = new GraphEvents();
        }
        return singleton;
    }

    public void addUIListener(UIListener gml) {
        this.gmls.add(gml);
    }

    public void removeUIListener(UIListener gml) {
        this.gmls.remove(gml);
    }

    public void addGraphMouseListener(GraphMouseListener gml) {
        this.gmls.add(gml);
    }

    public void removeGraphMouseListener(GraphMouseListener gml) {
        this.gmls.remove(gml);
    }

    public static void click(GraphElement ge) {
        if (ge instanceof Node) {
            GraphEvents.getGraphEvents().clickNodeI((Node)ge);
        } else {
            GraphEvents.getGraphEvents().clickEdgeI((Edge)ge);
        }
    }

    public static void shiftClick(GraphElement ge) {
        if (ge instanceof Node) {
            GraphEvents.getGraphEvents().shiftClickNodeI((Node)ge);
        } else {
            GraphEvents.getGraphEvents().shiftClickEdgeI((Edge)ge);
        }
    }

    public static void mouseEnter(GraphElement ge) {
        if (ge instanceof Node) {
            GraphEvents.getGraphEvents().mouseEnterNodeI((Node)ge);
        } else {
            GraphEvents.getGraphEvents().mouseEnterEdgeI((Edge)ge);
        }
    }

    public static void mouseLeave(GraphElement ge) {
        if (ge instanceof Node) {
            GraphEvents.getGraphEvents().mouseLeaveNodeI((Node)ge);
        } else {
            GraphEvents.getGraphEvents().mouseLeaveEdgeI((Edge)ge);
        }
    }

    public synchronized void shiftClickNodeI(Node n) {
        try {
            for (GraphMouseListener gml : this.gmls) {
                if (!(gml instanceof UIListener)) continue;
                ((UIListener)gml).shiftClickNode(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void shiftClickEdgeI(Edge e) {
        try {
            for (GraphMouseListener gml : this.gmls) {
                if (!(gml instanceof UIListener)) continue;
                ((UIListener)gml).shiftClickEdge(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void clickNodeI(Node n) {
        try {
            for (GraphMouseListener gml : this.gmls) {
                if (!(gml instanceof UIListener)) continue;
                ((UIListener)gml).clickNode(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void clickEdgeI(Edge e) {
        try {
            for (GraphMouseListener gml : this.gmls) {
                if (!(gml instanceof UIListener)) continue;
                ((UIListener)gml).clickEdge(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void mouseEnterNodeI(Node n) {
        try {
            Iterator it = this.gmls.iterator();
            while (it.hasNext()) {
                ((GraphMouseListener)it.next()).mouseEnterNode(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void mouseEnterEdgeI(Edge e) {
        try {
            Iterator it = this.gmls.iterator();
            while (it.hasNext()) {
                ((GraphMouseListener)it.next()).mouseEnterEdge(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void mouseLeaveNodeI(Node n) {
        try {
            Iterator it = this.gmls.iterator();
            while (it.hasNext()) {
                ((GraphMouseListener)it.next()).mouseLeaveNode(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void mouseLeaveEdgeI(Edge e) {
        try {
            Iterator it = this.gmls.iterator();
            while (it.hasNext()) {
                ((GraphMouseListener)it.next()).mouseLeaveEdge(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

