/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.freehep.HEPDialog;
import com.hp.hpl.guess.freehep.HEPWriter;
import com.hp.hpl.guess.ui.Dockable;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class GuessJFrame
extends JFrame {
    private JMenuBar jm = new JMenuBar();
    private Dockable dockable = null;

    public GuessJFrame() {
        this.initMenus();
    }

    public GuessJFrame(Dockable d) {
        super(d.getTitle());
        this.initMenus();
        this.getContentPane().add((Component)((Object)d));
        d.setWindow(this);
        JMenu fileMenu = new JMenu("Window");
        JMenuItem jmi = new JMenuItem("Dock");
        this.dockable = d;
        final Dockable dc = d;
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Dock")) {
                    GuessJFrame.this.getContentPane().removeAll();
                    GuessJFrame.this.hide();
                    Guess.getMainUIWindow().dock(dc);
                }
            }
        });
        fileMenu.add(jmi);
        this.jm.add(fileMenu);
    }

    public GuessJFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initMenus();
    }

    public GuessJFrame(String title) {
        super(title);
        this.initMenus();
    }

    public GuessJFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initMenus();
    }

    public void initMenus() {
        this.jm.putClientProperty("jgoodies.headerStyle", Boolean.TRUE);
        JMenu fileMenu = new JMenu("File");
        JMenuItem jmi = new JMenuItem("Export Image");
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Export Image")) {
                    HEPDialog hd = new HEPDialog(null);
                    hd.showHEPDialog(null, "Export File", GuessJFrame.this.getContentPane(), "output.jpg", false);
                }
            }
        });
        fileMenu.add(jmi);
        this.jm.add(fileMenu);
        this.setJMenuBar(this.jm);
        this.validate();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (GuessJFrame.this.dockable != null) {
                    GuessJFrame.this.dockable.opening(false);
                }
            }
        });
    }

    public void exportGIF(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 0);
    }

    public void exportJPG(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 1);
    }

    public void exportPDF(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 2);
    }

    public void exportPS(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 3);
    }

    public void exportEPS(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 3);
    }

    public void exportSVG(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 4);
    }

    public void exportSWF(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 5);
    }

    public void exportJAVA(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 6);
    }

    public void exportCGM(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 7);
    }

    public void exportEMF(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 8);
    }

    public void exportPNG(String filename) {
        HEPWriter.export(filename, this.getContentPane(), 9);
    }
}

