/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.ui.GuessDropListener;
import com.hp.hpl.guess.ui.GuessSelectable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class GuessTransferHandler
extends TransferHandler {
    DataFlavor guessFlavor;
    String guessType = "application/x-java-jvm-local-objectref;class=java.util.Collection";
    Object source = null;

    public GuessTransferHandler() {
        try {
            this.guessFlavor = new DataFlavor(this.guessType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("GuessTransferHandler: unable to create data flavor");
        }
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (this.hasGuessFlavor(t.getTransferDataFlavors())) {
                Object o = t.getTransferData(this.guessFlavor);
                if (c instanceof GuessDropListener) {
                    ((GuessDropListener)((Object)c)).receiveDrop(o);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    private boolean hasGuessFlavor(DataFlavor[] flavors) {
        if (this.guessFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.guessFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasGuessFlavor(flavors);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof GuessSelectable) {
            return new GuessTransferable(((GuessSelectable)((Object)c)).getGuessSelected());
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    public class GuessTransferable
    implements Transferable {
        Object data;

        public GuessTransferable(Object data) {
            this.data = data;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{GuessTransferHandler.this.guessFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return GuessTransferHandler.this.guessFlavor.equals(flavor);
        }
    }
}

