/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.GraphMouseListener;
import com.hp.hpl.guess.ui.GuessJFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class InfoWindow
extends JPanel
implements Dockable,
GraphMouseListener {
    private static InfoWindow singleton = null;
    private GuessTableModel gtm = null;
    private JLabel jl = new JLabel("Information Window", 0);
    protected boolean visible = false;
    private GuessJFrame myParent = null;

    @Override
    public void mouseEnterNode(Node n) {
        InfoWindow.details(n);
    }

    @Override
    public void mouseEnterEdge(Edge e) {
        InfoWindow.details(e);
    }

    @Override
    public void mouseLeaveNode(Node n) {
    }

    @Override
    public void mouseLeaveEdge(Edge e) {
    }

    public static boolean isIWVisible() {
        if (singleton == null) {
            return false;
        }
        return InfoWindow.singleton.visible;
    }

    public static InfoWindow getInfoWindow() {
        if (singleton == null) {
            singleton = new InfoWindow("Information Window");
        }
        return singleton;
    }

    public static void create() {
        if (InfoWindow.getInfoWindow().getWindow() == null || !InfoWindow.getInfoWindow().getWindow().isVisible()) {
            Guess.getMainUIWindow().dock(InfoWindow.getInfoWindow());
        }
    }

    public static void details(GraphElement n) {
        InfoWindow.getInfoWindow().updateInt(n);
    }

    public void updateInt(GraphElement n) {
        if (this.visible) {
            if (n instanceof Node) {
                this.gtm.details((Node)n);
            } else {
                this.gtm.details((Edge)n);
            }
            this.jl.setText(n.toString());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 600);
    }

    @Override
    public int getDirectionPreference() {
        return 2;
    }

    @Override
    public void opening(boolean state) {
        this.visible = state;
    }

    @Override
    public void attaching(boolean state) {
    }

    @Override
    public String getTitle() {
        return "Information Window";
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    private InfoWindow(String title) {
        GraphEvents.getGraphEvents().addGraphMouseListener(this);
        this.gtm = new GuessTableModel();
        JTable table = new JTable(this.gtm);
        JScrollPane scrollpane = new JScrollPane(table);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font fnt = this.jl.getFont();
        fnt = fnt.deriveFont(1, 15.0f);
        this.jl.setFont(fnt);
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.jl, c);
        c.fill = 1;
        c.weighty = 1.0;
        c.gridy = 1;
        this.add((Component)scrollpane, c);
        this.setBounds(this.getDefaultFrameBounds());
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(50, 50, 300, 600);
    }

    class GuessTableModel
    extends AbstractTableModel {
        private int nRowCount = 0;
        private Vector nFields = new Vector();
        private int eRowCount = 0;
        private Vector eFields = new Vector();
        private GraphElement lastSel = null;

        GuessTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public void details(Node n) {
            NodeSchema schema = Guess.getGraph().getNodeSchema();
            int trc = schema.fieldCount();
            if (trc != this.nRowCount) {
                this.nRowCount = trc;
                this.nFields.clear();
                Enumeration en = schema.getFields();
                while (en.hasMoreElements()) {
                    Field f = (Field)en.nextElement();
                    this.nFields.add(f.getName());
                }
                Collections.sort(this.nFields);
                this.lastSel = null;
            }
            GraphElement temp = this.lastSel;
            this.lastSel = n;
            if (temp instanceof Node) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.nRowCount, 1, 0));
            } else {
                this.fireTableDataChanged();
            }
        }

        public void details(Edge n) {
            EdgeSchema schema = Guess.getGraph().getEdgeSchema();
            int trc = schema.fieldCount();
            if (trc != this.eRowCount) {
                this.eRowCount = trc;
                this.eFields.clear();
                Enumeration en = schema.getFields();
                while (en.hasMoreElements()) {
                    Field f = (Field)en.nextElement();
                    this.eFields.add(f.getName());
                }
                Collections.sort(this.eFields);
                this.lastSel = null;
            }
            GraphElement temp = this.lastSel;
            this.lastSel = n;
            if (temp instanceof Edge) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.eRowCount, 1, 0));
            } else {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            if (this.lastSel == null) {
                return 0;
            }
            if (this.lastSel instanceof Node) {
                return this.nRowCount;
            }
            return this.eRowCount;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.lastSel == null) {
                return "";
            }
            if (this.lastSel instanceof Node) {
                if (row <= this.nRowCount) {
                    String fld = (String)this.nFields.elementAt(row);
                    if (col == 0) {
                        return fld;
                    }
                    if (col == 1) {
                        return this.lastSel.__getattr__(fld);
                    }
                }
            } else if (row <= this.eRowCount) {
                String fld = (String)this.eFields.elementAt(row);
                if (col == 0) {
                    return fld;
                }
                if (col == 1) {
                    return this.lastSel.__getattr__(fld);
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Field";
            }
            return "Value";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String f = null;
            Field fld = null;
            if (this.lastSel != null) {
                if (this.lastSel instanceof Node) {
                    f = (String)this.nFields.elementAt(row);
                    fld = Guess.getGraph().getNodeSchema().getField(f);
                } else {
                    f = (String)this.eFields.elementAt(row);
                    fld = Guess.getGraph().getEdgeSchema().getField(f);
                }
                try {
                    if (fld.getSQLType() == 4 || fld.getSQLType() == -6 || fld.getSQLType() == 5 || fld.getSQLType() == -5) {
                        this.lastSel.__setattr__(f, new Integer((String)value));
                    } else if (fld.getSQLType() == 16) {
                        this.lastSel.__setattr__(f, new Boolean((String)value));
                    } else if (fld.isNumeric()) {
                        this.lastSel.__setattr__(f, new Double((String)value));
                    } else {
                        this.lastSel.__setattr__(f, value);
                    }
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

