/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.ExceptionWindow;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.python.core.PyInstance;
import org.python.core.PyJavaInstance;
import org.python.util.PythonInterpreter;

public class LabNotebook
extends JFrame {
    JTextPane pane = null;
    HTMLDocument doc = null;
    private PythonInterpreter jython = null;
    private static LabNotebook singleton = null;
    private JScrollPane jsp = null;
    private int counter = 1;
    private int lineNum = 0;
    boolean color = false;
    private static final Rectangle bottom = new Rectangle(0, Integer.MAX_VALUE, 0, 0);

    public static LabNotebook createNotebook(PythonInterpreter j) {
        if (singleton == null) {
            singleton = new LabNotebook(j);
        }
        return singleton;
    }

    public static LabNotebook getNotebook() {
        return singleton;
    }

    public Element getElementByTag(Element parent, HTML.Tag tag) {
        if (parent == null || tag == null) {
            return null;
        }
        for (int k = 0; k < parent.getElementCount(); ++k) {
            Element child = parent.getElement(k);
            if (child.getAttributes().getAttribute(StyleConstants.NameAttribute).equals(tag)) {
                return child;
            }
            Element e = this.getElementByTag(child, tag);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    private LabNotebook(PythonInterpreter jython2) {
        this.jython = jython2;
        this.pane = new JTextPane();
        this.pane.setEditable(false);
        this.pane.setEditorKit(new HTMLEditorKit());
        this.pane.setText("<HTML><BODY><H1>Lab Notebook</H1><TABLE><TR ID=1><TD>&nbsp;</TD><TD>&nbsp;</TD></TR><DIV></TABLE></BODY></HTML>");
        this.doc = (HTMLDocument)this.pane.getStyledDocument();
        StyleSheet styleSheet = this.doc.getStyleSheet();
        styleSheet.addRule("body {font-family: Dialog}");
        SimpleLinkListener sll = new SimpleLinkListener(this.pane);
        this.pane.addHyperlinkListener(sll);
        this.jsp = new JScrollPane(this.pane);
        this.setContentPane(this.jsp);
        this.setSize(400, 500);
        this.setVisible(true);
    }

    public void addText(String command, Object result) {
        try {
            Element root = this.doc.getRootElements()[0];
            Element body = this.doc.getElement("" + this.counter);
            ++this.counter;
            String cl = "#FFFFFF";
            if (!this.color) {
                cl = "#CCFFFF";
            }
            this.color = !this.color;
            ++this.lineNum;
            StringBuffer toInsert = new StringBuffer("<TR ID=" + this.counter + " BGCOLOR=" + cl + "><TD VALIGN=TOP><B>" + this.lineNum + "</B></TD><TD VALIGN=TOP><PRE>" + command + "</PRE></TD></TR>\n");
            String res = null;
            if (result instanceof PyJavaInstance) {
                Object o = ((PyInstance)result).__tojava__(Object.class);
                if (o instanceof Node) {
                    String name = ((Node)o).getName();
                    res = "<A HREF=\"http://" + name + "\">" + name + "</A>";
                } else if (o instanceof Edge) {
                    String name = ((Edge)o).toString();
                    res = "<A HREF=\"http://" + name + "\">" + name + "</A>";
                }
            }
            if (res != null) {
                ++this.counter;
                toInsert.append("<TR ID=" + this.counter + "><TD>&nbsp;<TD BGCOLOR=" + cl + ">" + res + "</TD></TR>\n");
            }
            this.doc.insertAfterEnd(body, toInsert.toString());
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
        this.jsp.scrollRectToVisible(bottom);
    }

    public void addImage(String url, int width, int height) {
        try {
            Element root = this.doc.getRootElements()[0];
            Element body = this.doc.getElement("" + this.counter);
            double scale = Math.min((double)this.getHeight() / (double)height, (double)this.getWidth() / (double)width) * 0.8;
            height = (int)((double)height * scale);
            width = (int)((double)width * scale);
            ++this.counter;
            url = new File(url).toURL().toString();
            StringBuffer toInsert = new StringBuffer("<TR ID=" + this.counter + "><TD VALIGN=TOP>&nbsp;" + "</TD><TD VALIGN=TOP>" + "<IMG SRC=\"" + url + "\" HEIGHT=" + height + " WIDTH=" + width + "></TD></TR>\n");
            this.doc.insertAfterEnd(body, toInsert.toString());
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
        this.jsp.scrollRectToVisible(bottom);
    }

    class SimpleLinkListener
    implements HyperlinkListener {
        private JEditorPane pane;

        public SimpleLinkListener(JEditorPane jep) {
            this.pane = jep;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent he) {
            HyperlinkEvent.EventType type = he.getEventType();
            URL testURL = he.getURL();
            if (testURL == null) {
                return;
            }
            String host = testURL.getHost();
            if (type == HyperlinkEvent.EventType.ENTERED) {
                System.out.println("over: " + host);
            } else if (type != HyperlinkEvent.EventType.EXITED && type == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    LabNotebook.this.jython.exec("center(" + host + ")");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

