/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.GMenuBar;
import com.hp.hpl.guess.ui.GuessJFrame;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.VerticalTextIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class MainUIWindow
extends JFrame {
    public static final int HORIZONTAL_DOCK = 1;
    public static final int VERTICAL_DOCK = 2;
    private Component canvas;
    private GraphicsDevice graphicsDevice;
    private DisplayMode originalDisplayMode;
    private EventListener escapeFullScreenModeListener;
    private JTabbedPane tabbedPaneH = null;
    private JTabbedPane tabbedPaneV = null;
    private JSplitPane splitPaneH = null;
    private JSplitPane splitPaneV = null;
    private GMenuBar myMenu = null;
    private final JPopupMenu jpop = new JPopupMenu("Dock Menu");
    private JTabbedPane selected = null;

    public Set getVerticalDockedComponents() {
        HashSet<Component> s = new HashSet<Component>();
        for (int i = 0; i < this.tabbedPaneV.getTabCount(); ++i) {
            s.add(this.tabbedPaneV.getComponentAt(i));
        }
        return s;
    }

    public Set getHorizontalDockedComponents() {
        HashSet<Component> s = new HashSet<Component>();
        for (int i = 0; i < this.tabbedPaneH.getTabCount(); ++i) {
            s.add(this.tabbedPaneH.getComponentAt(i));
        }
        return s;
    }

    public void enableButtons(boolean state) {
        StatusBar.enableButtons(state);
    }

    public MainUIWindow(Component aCanvas) {
        this(false, aCanvas);
    }

    public GMenuBar getGMenuBar() {
        return this.myMenu;
    }

    public MainUIWindow(boolean fullScreenMode, Component aCanvas) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), fullScreenMode, aCanvas);
    }

    public MainUIWindow(GraphicsDevice aDevice, boolean fullScreenMode, Component aCanvas) {
        super(aDevice.getDefaultConfiguration());
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.graphicsDevice = aDevice;
        try {
            this.originalDisplayMode = this.graphicsDevice.getDisplayMode();
        }
        catch (InternalError e) {
            // empty catch block
        }
        this.setBounds(this.getDefaultFrameBounds());
        this.setBackground(null);
        try {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Guess.shutdown();
                }
            });
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.canvas = aCanvas;
        if (this.canvas == null) {
            System.err.println("null canvas");
        }
        this.tabbedPaneH = new JTabbedPane();
        this.tabbedPaneH.setTabPlacement(3);
        this.tabbedPaneV = MainUIWindow.createTabbedPane(2);
        this.splitPaneH = new JSplitPane(0, this.canvas, this.tabbedPaneH);
        this.splitPaneV = new JSplitPane(1, this.tabbedPaneV, this.splitPaneH);
        this.splitPaneH.setDividerLocation(this.getHeight());
        this.splitPaneH.setEnabled(false);
        this.splitPaneV.setEnabled(false);
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.getContentPane().add((Component)this.splitPaneV, c);
        StatusBar jp = new StatusBar();
        c.fill = 2;
        c.weighty = 0.0;
        c.gridy = 1;
        this.getContentPane().add((Component)jp, c);
        this.myMenu = new GMenuBar();
        this.setJMenuBar(this.myMenu);
        this.validate();
        this.setFullScreenMode(fullScreenMode);
        this.canvas.requestFocus();
        this.setTitle("Guess Visualization");
        JMenuItem jmi1 = this.jpop.add("Undock");
        JMenuItem jmi2 = this.jpop.add("Close");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Undock")) {
                    if (MainUIWindow.this.selected == MainUIWindow.this.tabbedPaneH) {
                        Component c = MainUIWindow.this.tabbedPaneH.getSelectedComponent();
                        if (c != null && c instanceof Dockable) {
                            MainUIWindow.this.undock((Dockable)((Object)c));
                        }
                    } else {
                        Component c = MainUIWindow.this.tabbedPaneV.getSelectedComponent();
                        if (c != null && c instanceof Dockable) {
                            MainUIWindow.this.undock((Dockable)((Object)c));
                        }
                    }
                } else if (event.getActionCommand().equals("Close")) {
                    if (MainUIWindow.this.selected == MainUIWindow.this.tabbedPaneH) {
                        Component c = MainUIWindow.this.tabbedPaneH.getSelectedComponent();
                        if (c != null && c instanceof Dockable) {
                            MainUIWindow.this.selected.remove(c);
                            ((Dockable)((Object)c)).opening(false);
                        }
                    } else {
                        Component c = MainUIWindow.this.tabbedPaneV.getSelectedComponent();
                        if (c != null && c instanceof Dockable) {
                            MainUIWindow.this.selected.remove(c);
                            ((Dockable)((Object)c)).opening(false);
                        }
                    }
                    if (MainUIWindow.this.selected.getTabCount() == 0) {
                        if (MainUIWindow.this.selected == MainUIWindow.this.tabbedPaneV) {
                            MainUIWindow.this.splitPaneV.setDividerLocation(0);
                            MainUIWindow.this.splitPaneV.setEnabled(false);
                        } else {
                            MainUIWindow.this.splitPaneH.setDividerLocation(MainUIWindow.this.getHeight());
                            MainUIWindow.this.splitPaneH.setEnabled(false);
                        }
                    }
                }
            }
        };
        jmi1.addActionListener(al);
        jmi2.addActionListener(al);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 2 || e.getButton() == 3) {
                    MainUIWindow.this.selected = (JTabbedPane)e.getComponent();
                    MainUIWindow.this.jpop.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.tabbedPaneH.addMouseListener(ma);
        this.tabbedPaneV.addMouseListener(ma);
    }

    public static JTabbedPane createTabbedPane(int tabPlacement) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                Object textIconGap = UIManager.get("TabbedPane.textIconGap");
                Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
                UIManager.put("TabbedPane.textIconGap", new Integer(5));
                UIManager.put("TabbedPane.tabInsets", new Insets(tabInsets.left, tabInsets.top, tabInsets.right, tabInsets.bottom));
                JTabbedPane tabPane = new JTabbedPane(tabPlacement);
                UIManager.put("TabbedPane.textIconGap", textIconGap);
                UIManager.put("TabbedPane.tabInsets", tabInsets);
                return tabPane;
            }
        }
        return new JTabbedPane(tabPlacement);
    }

    public void dock(Dockable d) {
        try {
            if (d.getDirectionPreference() == 2) {
                this.splitPaneV.setEnabled(true);
                this.splitPaneV.setDividerLocation((int)Math.max((double)this.splitPaneV.getDividerLocation(), ((Component)((Object)d)).getPreferredSize().getWidth()));
                this.tabbedPaneV.addTab(null, new VerticalTextIcon(d.getTitle(), false), (Component)((Object)d));
                this.tabbedPaneV.setBackgroundAt(0, Color.darkGray);
                this.tabbedPaneV.setSelectedComponent((Component)((Object)d));
            } else {
                this.splitPaneH.setEnabled(true);
                double m1 = Math.max(200, this.tabbedPaneH.getHeight());
                double m2 = ((Component)((Object)d)).getPreferredSize().getHeight();
                int m3 = (int)Math.max(m1, m2);
                this.splitPaneH.setDividerLocation(this.getHeight() - m3);
                this.tabbedPaneH.addTab(d.getTitle(), (Component)((Object)d));
                this.tabbedPaneH.setSelectedComponent((Component)((Object)d));
            }
            d.opening(true);
            d.attaching(true);
            this.splitPaneH.setOneTouchExpandable(true);
            this.splitPaneV.setOneTouchExpandable(true);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public void undock(Dockable d) {
        GuessJFrame gjf = d.getWindow();
        if (gjf == null) {
            gjf = new GuessJFrame(d);
        } else {
            gjf.getContentPane().removeAll();
            gjf.getContentPane().add((Component)((Object)d));
        }
        d.opening(true);
        d.attaching(false);
        gjf.setBounds(20, 20, (int)((Component)((Object)d)).getPreferredSize().getWidth(), (int)((Component)((Object)d)).getPreferredSize().getHeight() + 50);
        gjf.show();
        if (this.selected == null) {
            this.selected = d.getDirectionPreference() == 1 ? this.tabbedPaneH : this.tabbedPaneV;
        }
        if (this.selected != null) {
            this.selected.remove((Component)((Object)d));
            if (this.selected.getTabCount() == 0) {
                if (this.selected == this.tabbedPaneV) {
                    this.splitPaneV.setEnabled(false);
                    this.splitPaneV.setDividerLocation(0);
                } else {
                    this.splitPaneH.setEnabled(false);
                    this.splitPaneH.setDividerLocation(this.getHeight());
                }
            }
        }
    }

    public void close(Dockable d) {
        try {
            JTabbedPane selected = null;
            selected = d.getDirectionPreference() == 2 ? this.tabbedPaneV : this.tabbedPaneH;
            d.opening(false);
            selected.remove((Component)((Object)d));
            if (selected.getTabCount() == 0) {
                if (selected == this.tabbedPaneV) {
                    this.splitPaneV.setEnabled(false);
                    this.splitPaneV.setDividerLocation(0);
                } else {
                    this.splitPaneH.setEnabled(false);
                    this.splitPaneH.setDividerLocation(this.getHeight());
                }
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public Component getCanvas() {
        return this.canvas;
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(100, 100, 800, 600);
    }

    public void setFullScreenMode(boolean fullScreenMode) {
        if (fullScreenMode) {
            this.addEscapeFullScreenModeListener();
            if (this.isDisplayable()) {
                this.dispose();
            }
            this.setUndecorated(true);
            this.setResizable(false);
            this.graphicsDevice.setFullScreenWindow(this);
            if (this.graphicsDevice.isDisplayChangeSupported()) {
                this.chooseBestDisplayMode(this.graphicsDevice);
            }
            this.validate();
        } else {
            this.removeEscapeFullScreenModeListener();
            if (this.isDisplayable()) {
                this.dispose();
            }
            this.setUndecorated(false);
            this.setResizable(true);
            this.graphicsDevice.setFullScreenWindow(null);
            this.validate();
            this.setVisible(true);
        }
    }

    protected void chooseBestDisplayMode(GraphicsDevice device) {
        DisplayMode best = this.getBestDisplayMode(device);
        if (best != null) {
            device.setDisplayMode(best);
        }
    }

    protected DisplayMode getBestDisplayMode(GraphicsDevice device) {
        try {
            for (DisplayMode each : this.getPreferredDisplayModes(device)) {
                DisplayMode[] modes = device.getDisplayModes();
                for (int i = 0; i < modes.length; ++i) {
                    if (modes[i].getWidth() != each.getWidth() || modes[i].getHeight() != each.getHeight() || modes[i].getBitDepth() != each.getBitDepth()) continue;
                    return each;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Collection getPreferredDisplayModes(GraphicsDevice device) {
        ArrayList<DisplayMode> result = new ArrayList<DisplayMode>();
        result.add(device.getDisplayMode());
        return result;
    }

    public void addEscapeFullScreenModeListener() {
        this.removeEscapeFullScreenModeListener();
        this.escapeFullScreenModeListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent aEvent) {
                if (aEvent.getKeyCode() == 27) {
                    MainUIWindow.this.setFullScreenMode(false);
                }
            }
        };
        this.canvas.addKeyListener((KeyListener)this.escapeFullScreenModeListener);
    }

    public void removeEscapeFullScreenModeListener() {
        if (this.escapeFullScreenModeListener != null) {
            this.canvas.removeKeyListener((KeyListener)this.escapeFullScreenModeListener);
            this.escapeFullScreenModeListener = null;
        }
    }
}

