/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class PSTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Insets NO_INSETS = new Insets(2, 0, 0, 0);
    private Font boldFont;
    private FontMetrics boldFontMetrics;
    private Color fillColor;

    public static ComponentUI createUI(JComponent c) {
        return new PSTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets.left = 4;
        this.tabInsets = this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
        Color background = this.tabPane.getBackground();
        this.fillColor = background.darker();
        this.boldFont = this.tabPane.getFont().deriveFont(1);
        this.boldFontMetrics = this.tabPane.getFontMetrics(this.boldFont);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return NO_INSETS;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int vHeight = fontHeight;
        if (vHeight % 2 > 0) {
            ++vHeight;
        }
        return vHeight;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + metrics.getHeight();
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.rects.length == 0) {
            return;
        }
        Polygon shape = new Polygon();
        shape.addPoint(x, y + h);
        shape.addPoint(x, y);
        shape.addPoint(x + (w += 4) - h / 2, y);
        if (isSelected || tabIndex == this.rects.length - 1) {
            shape.addPoint(x + w + h / 2, y + h);
        } else {
            shape.addPoint(x + w, y + h / 2);
            shape.addPoint(x + w, y + h);
        }
        g.setColor(this.tabPane.getBackground());
        g.fillPolygon(shape);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.rects.length == 0) {
            return;
        }
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x, y + h);
        g.drawLine(x, y, x + (w += 4) - h / 2, y);
        g.drawLine(x + w - h / 2, y, x + w + h / 2, y + h);
        if (isSelected) {
            g.setColor(Color.WHITE);
            g.drawLine(x + 1, y + 1, x + 1, y + h);
            g.drawLine(x + 1, y + 1, x + w - h / 2, y + 1);
            g.setColor(this.shadow);
            g.drawLine(x + w - h / 2, y + 1, x + w + h / 2 - 1, y + h);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.rects.length == 0) {
            return;
        }
        Rectangle selectedRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        selectedRect.width = selectedRect.width + selectedRect.height / 2 - 1 + 4;
        g.setColor(Color.BLACK);
        g.drawLine(x, y, selectedRect.x, y);
        g.drawLine(selectedRect.x + selectedRect.width + 1, y, x + w, y);
        g.setColor(Color.WHITE);
        g.drawLine(x, y + 1, selectedRect.x, y + 1);
        g.drawLine(selectedRect.x + 1, y + 1, selectedRect.x + 1, y);
        g.drawLine(selectedRect.x + selectedRect.width + 2, y + 1, x + w, y + 1);
        g.setColor(this.shadow);
        g.drawLine(selectedRect.x + selectedRect.width, y, selectedRect.x + selectedRect.width + 1, y + 1);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.rects.length == 0) {
            return;
        }
        int tw = this.tabPane.getBounds().width;
        g.setColor(this.fillColor);
        g.fillRect(0, 0, tw, this.rects[0].height + 3);
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        if (this.rects.length == 0) {
            return;
        }
        if (isSelected) {
            int vDifference = (int)this.boldFontMetrics.getStringBounds(title, g).getWidth() - textRect.width;
            textRect.x -= vDifference / 2;
            super.paintText(g, tabPlacement, this.boldFont, this.boldFontMetrics, tabIndex, title, textRect, isSelected);
        } else {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }
}

