/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.SunFileFilter;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.FontSizeHints;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class PickFile
extends JPanel
implements ActionListener {
    JFormattedTextField m_jformattedtextfield1 = new JFormattedTextField();
    JButton m_jbutton1 = new JButton();
    JButton m_jbutton2 = new JButton();
    JButton m_jbutton3 = new JButton();
    JComboBox m_jcombobox1 = new JComboBox();
    JFormattedTextField m_jformattedtextfield2 = new JFormattedTextField();
    JButton m_jbutton4 = new JButton();
    JFormattedTextField m_jformattedtextfield3 = new JFormattedTextField();
    JDialog owner = null;
    File approved = null;
    private JLabel jlabel2 = null;
    private JLabel jlabel3 = null;
    private JLabel jlabel4 = null;
    private static final char sep = File.separatorChar;

    public static void configureUI() {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setGlobalFontSizeHints((FontSizeHints)FontSizeHints.MIXED);
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        String lafName = LookUtils.IS_OS_WINDOWS_XP ? Options.getCrossPlatformLookAndFeelClassName() : Options.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            System.err.println("Can't set look & feel:" + e);
        }
    }

    public PickFile() {
        this.initializePanel();
        this.owner = new JDialog();
    }

    public static void main(String[] args) {
        PickFile.configureUI();
        PickFile pf = new PickFile();
        File f = pf.showDialog();
        if (f == null) {
            System.out.println("Cancel");
        } else {
            System.out.println(f);
            if (pf.isPersistent()) {
                System.out.println(pf.getName());
                System.out.println(pf.getDirectory());
            } else {
                System.out.println("in memory");
            }
        }
        System.exit(0);
    }

    public File showDialog() {
        this.owner.setTitle("Please select a file");
        this.owner.setResizable(false);
        this.owner.setLocation(200, 200);
        this.owner.getContentPane().setLayout(new FlowLayout());
        this.owner.getContentPane().add(this);
        this.owner.pack();
        this.owner.setDefaultCloseOperation(2);
        this.owner.setModal(true);
        this.owner.show();
        return this.getSelectedFile();
    }

    public File getSelectedFile() {
        return this.approved;
    }

    public File getDirectory() {
        return new File(this.m_jformattedtextfield3.getText());
    }

    @Override
    public String getName() {
        return this.m_jformattedtextfield2.getText();
    }

    public boolean isPersistent() {
        return this.m_jcombobox1.getSelectedIndex() != 0;
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    public ImageIcon loadImage(String imageName) {
        try {
            ClassLoader classloader = this.getClass().getClassLoader();
            URL url = classloader.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                return icon;
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        throw new IllegalArgumentException("Unable to load image: " + imageName);
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:8DLU:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:59PX:NONE,FILL:66PX:NONE,FILL:55PX:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:8DLU:NONE", "CENTER:4DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:4DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        JLabel jlabel1 = new JLabel();
        jlabel1.setText("Please enter a file name (.gdf/.graphml)");
        jpanel1.add((Component)jlabel1, cc.xywh(2, 2, 6, 1));
        jpanel1.add((Component)this.m_jformattedtextfield1, cc.xywh(2, 4, 6, 1));
        this.m_jbutton1.setActionCommand("JButton");
        this.m_jbutton1.setText("...");
        jpanel1.add((Component)this.m_jbutton1, cc.xy(9, 4));
        this.m_jbutton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    String toLoad = ".";
                    try {
                        toLoad = System.getProperty("gHome");
                        if (toLoad == null) {
                            toLoad = ".";
                        } else {
                            File testF = new File(toLoad);
                            if (!testF.exists() || !testF.isDirectory()) {
                                toLoad = ".";
                            }
                        }
                    }
                    catch (Exception hde) {
                        toLoad = ".";
                    }
                    JFileChooser chooser = new JFileChooser(new File(toLoad).getCanonicalPath());
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        PickFile.this.m_jformattedtextfield1.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    ExceptionWindow.getExceptionWindow(ex);
                }
            }
        });
        this.m_jbutton2.setActionCommand("Cancel");
        this.m_jbutton2.setText("Cancel");
        jpanel1.add((Component)this.m_jbutton2, cc.xy(9, 6));
        this.m_jbutton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PickFile.this.owner.dispose();
            }
        });
        this.m_jbutton3.setActionCommand("OK");
        this.m_jbutton3.setText("OK");
        this.m_jbutton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    File f = new File(PickFile.this.m_jformattedtextfield1.getText());
                    if (!f.exists()) {
                        JOptionPane.showMessageDialog(null, "File does not exist", "Error", 0);
                        return;
                    }
                    PickFile.this.approved = f;
                    if (PickFile.this.m_jcombobox1.getSelectedIndex() == 1) {
                        int yn;
                        f = new File(PickFile.this.m_jformattedtextfield3.getText());
                        if (!f.exists() || !f.isDirectory()) {
                            JOptionPane.showMessageDialog(null, "Directory does not exist", "Error", 0);
                            return;
                        }
                        if (PickFile.this.m_jformattedtextfield2.getText() == null || PickFile.this.m_jformattedtextfield2.getText().equals("")) {
                            JOptionPane.showMessageDialog(null, "You must declare a database name", "Error", 0);
                            return;
                        }
                        f = new File(PickFile.this.m_jformattedtextfield3.getText() + sep + PickFile.this.m_jformattedtextfield2.getText() + ".properties");
                        if (f.exists() && (yn = JOptionPane.showConfirmDialog(null, "Database exists, overwrite?", "Exists", 0)) == 1) {
                            return;
                        }
                    }
                    PickFile.this.owner.dispose();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                }
            }
        });
        jpanel1.add((Component)this.m_jbutton3, cc.xy(7, 6));
        jpanel1.add((Component)this.m_jcombobox1, cc.xywh(2, 6, 4, 1));
        this.m_jcombobox1.addItem("In memory");
        this.m_jcombobox1.addItem("Persistent");
        this.m_jcombobox1.addActionListener(this);
        this.jlabel2 = new JLabel();
        this.jlabel2.setText("Database Configuration");
        jpanel1.add((Component)this.jlabel2, cc.xywh(2, 8, 6, 1));
        jpanel1.add((Component)this.m_jformattedtextfield2, cc.xywh(5, 10, 3, 1));
        this.m_jbutton4.setActionCommand("JButton");
        this.m_jbutton4.setText("...");
        jpanel1.add((Component)this.m_jbutton4, cc.xy(9, 12));
        this.m_jbutton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser(new File(".").getCanonicalPath());
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle("Please select a directory");
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        PickFile.this.m_jformattedtextfield3.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    ExceptionWindow.getExceptionWindow(ex);
                }
            }
        });
        this.jlabel3 = new JLabel();
        this.jlabel3.setText("Name");
        jpanel1.add((Component)this.jlabel3, cc.xy(3, 10));
        this.jlabel4 = new JLabel();
        this.jlabel4.setText("Directory");
        jpanel1.add((Component)this.jlabel4, cc.xy(3, 12));
        jpanel1.add((Component)this.m_jformattedtextfield3, cc.xywh(5, 12, 3, 1));
        this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13});
        this.persistentEnable(false);
        return jpanel1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_jcombobox1.getSelectedIndex() == 0) {
            this.persistentEnable(false);
        } else {
            this.persistentEnable(true);
        }
    }

    public void persistentEnable(boolean state) {
        this.jlabel2.setEnabled(state);
        this.m_jformattedtextfield2.setEnabled(state);
        this.m_jbutton4.setEnabled(state);
        this.jlabel3.setEnabled(state);
        this.m_jformattedtextfield3.setEnabled(state);
        this.jlabel4.setEnabled(state);
        if (state) {
            String simp;
            if ((this.m_jformattedtextfield2.getText() == null || this.m_jformattedtextfield2.getText().equals("")) && (simp = this.m_jformattedtextfield1.getText()) != null && !simp.equals("")) {
                try {
                    SunFileFilter filter = new SunFileFilter();
                    String fileExtension = filter.getExtension(new File(simp));
                    simp = simp.substring(0, simp.length() - 1 - fileExtension.length());
                    int seploc = simp.lastIndexOf(sep);
                    simp = simp.substring(++seploc);
                    this.m_jformattedtextfield2.setText(simp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.m_jformattedtextfield3.getText() == null || this.m_jformattedtextfield3.getText().equals("")) {
                try {
                    this.m_jformattedtextfield3.setText(new File(".").getCanonicalPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanel(), "Center");
    }
}

