/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class StandardDialog
extends JDialog
implements KeyEventDispatcher,
WindowFocusListener {
    public static final int APPROVE = 1;
    public static final int CANCEL = 0;
    public static final int ABORT = 2;
    private JButton approveButton = null;
    private final ArrayList buttonList = new ArrayList();
    private final JPanel buttons = new JPanel(new BorderLayout(0, 0));
    private JButton cancelButton = null;
    private JButton abortButton = null;
    private boolean disposeOnClose = true;
    private JComponent firstFocusComponent = null;
    private final boolean ignoreEscapeKey;
    private boolean ignoreKeys = true;
    private final JPanel leftButtons = new JPanel(new FlowLayout(0, 0, 0));
    public final JPanel main = new JPanel(new BorderLayout(0, 0));
    private int result = 0;
    private final JPanel rightButtons = new JPanel(new FlowLayout(2, 0, 0));

    public StandardDialog(JFrame parent, String title, boolean ignoreESCKey) {
        super((Frame)parent, title);
        this.ignoreEscapeKey = ignoreESCKey;
        this.setUndecorated(true);
        this.setContentPane(this.main);
        this.buttons.add((Component)this.leftButtons, "West");
        this.buttons.add((Component)this.rightButtons, "East");
        this.buttons.setBorder(new EmptyBorder(15, 0, 0, 0));
    }

    public StandardDialog(JDialog parent, String title, boolean ignoreESCKey) {
        super((Dialog)parent, title);
        this.ignoreEscapeKey = ignoreESCKey;
        this.setUndecorated(true);
        this.setContentPane(this.main);
        this.buttons.add((Component)this.leftButtons, "West");
        this.buttons.add((Component)this.rightButtons, "East");
        this.buttons.setBorder(new EmptyBorder(15, 0, 0, 0));
    }

    public JPanel getButtonPanel() {
        return this.buttons;
    }

    public JPanel getLeftButtonPanel() {
        return this.leftButtons;
    }

    public JPanel getRightButtonPanel() {
        return this.rightButtons;
    }

    public StandardDialog(JFrame parent, String title) {
        this(parent, title, false);
    }

    public final void addButtonPanel() {
        this.main.add((Component)this.buttons, "South");
    }

    public final void addLeftButton(JButton button) {
        this.buttonList.add(button);
        this.leftButtons.add(button);
        this.leftButtons.add(Box.createHorizontalStrut(4));
    }

    public final void addRightButton(JButton button) {
        this.buttonList.add(button);
        this.rightButtons.add(Box.createHorizontalStrut(4));
        this.rightButtons.add(button);
    }

    protected void approve() {
        this.result = 1;
        this.close();
    }

    protected void abort() {
        this.result = 2;
        this.close();
    }

    protected void cancel() {
        this.result = 0;
        this.close();
    }

    public final void center() {
        Point p;
        Dimension screen;
        if (this.hasValidParent()) {
            screen = this.getParent().getSize();
            p = this.getParent().getLocation();
        } else {
            screen = Toolkit.getDefaultToolkit().getScreenSize();
            p = new Point(0, 0);
        }
        Dimension dim = this.getPreferredSize();
        p.x = Math.max(0, p.x + screen.width / 2 - dim.width / 2);
        p.y = Math.max(0, p.y + screen.height / 2 - dim.height / 2);
        this.setLocation(p.x, p.y);
    }

    public final void close() {
        this.setVisible(false);
        if (this.disposeOnClose) {
            this.dispose();
        }
    }

    @Override
    public final boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.isActive()) {
            return false;
        }
        if (e.getID() == 400 && e.getKeyChar() == '\u001b' && e.getModifiers() == 0 && !this.ignoreEscapeKey) {
            this.cancel();
            return true;
        }
        return this.handleKey(e);
    }

    public JButton getApproveButton() {
        if (this.approveButton == null) {
            this.approveButton = new JButton("OK");
            this.approveButton.setMnemonic('o');
            this.approveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardDialog.this.approve();
                }
            });
        }
        return this.approveButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setMnemonic('c');
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardDialog.this.cancel();
                }
            });
        }
        return this.cancelButton;
    }

    public JButton getAbortButton() {
        if (this.abortButton == null) {
            this.abortButton = new JButton("Abort");
            this.abortButton.setMnemonic('a');
            this.abortButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardDialog.this.abort();
                }
            });
        }
        return this.abortButton;
    }

    public final int getResult() {
        return this.result;
    }

    protected final void setResult(int result) {
        this.result = result;
    }

    protected boolean handleKey(KeyEvent e) {
        return false;
    }

    private final boolean hasValidParent() {
        boolean valid;
        Window parent = (Window)this.getParent();
        boolean bl = valid = parent != null && parent.isVisible();
        if (parent instanceof Frame) {
            return valid && (((Frame)parent).getState() & 1) == 0;
        }
        return valid;
    }

    public final void open() {
        if (this.buttonList.size() > 0) {
            this.resizeButtons();
            this.buttons.add(Box.createHorizontalStrut(20), "Center");
        }
        this.pack();
        this.center();
        this.setVisible(true);
    }

    private void resizeButtons() {
        int maxHeight = 0;
        Iterator it = this.buttonList.iterator();
        while (it.hasNext()) {
            int h = ((JButton)it.next()).getPreferredSize().height;
            if (h <= maxHeight) continue;
            maxHeight = h;
        }
        for (JButton b : this.buttonList) {
            Dimension dim = b.getPreferredSize();
            dim.height = maxHeight;
            b.setPreferredSize(dim);
        }
    }

    public final void setDefaultBorder() {
        this.main.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
    }

    public void setDisposeOnClose(boolean flag) {
        this.disposeOnClose = flag;
    }

    protected final void setFirstFocusComponent(JComponent c) {
        this.firstFocusComponent = c;
    }

    private final void setIgnoreKeys(boolean b) {
        this.ignoreKeys = b;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.setIgnoreKeys(false);
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.setIgnoreKeys(true);
    }
}

