/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.PreviewCorner;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.storage.StorageListener;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.SimpleButton;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusBar
extends JPanel
implements ActionListener {
    protected static JProgressBar progressBar = null;
    protected static JLabel label = null;
    private static StatusBar sb = null;
    private static JComboBox stateList = null;
    private static boolean ignoreChange = false;
    private SimpleButton[] sbList = new SimpleButton[5];
    private static HashSet states = new HashSet();
    public static boolean useButtons = true;

    public static boolean buttonsEnabled() {
        return useButtons;
    }

    public static void enableButtons(boolean state) {
        if (sb != null) {
            for (int i = 0; i < 5; ++i) {
                StatusBar.sb.sbList[i].setEnabled(state);
            }
        }
        useButtons = state;
    }

    public static void setState(String state) {
        if (stateList != null) {
            if (!states.contains(state)) {
                ignoreChange = true;
                stateList.addItem(state);
                states.add(state);
            }
            ignoreChange = true;
            stateList.setSelectedItem(state);
            ignoreChange = false;
        }
    }

    public static void repaintNow() {
        if (sb != null) {
            sb.repaint();
        }
    }

    public static void setValue(int max, int nv) {
        if (progressBar != null) {
            progressBar.setIndeterminate(false);
            progressBar.setMaximum(max);
            progressBar.setValue(nv);
        }
    }

    public static void setStatus(String status) {
        if (label != null) {
            label.setForeground(Color.black);
            label.setText("     " + status);
            label.setToolTipText(null);
        }
    }

    public static void setErrorStatus(String status) {
        if (label != null) {
            label.setForeground(Color.red);
            label.setText("     " + status);
            label.setToolTipText(status);
        }
    }

    public static void runProgressBar(boolean state) {
        if (progressBar != null) {
            if (state) {
                // empty if block
            }
            progressBar.setIndeterminate(state);
        }
    }

    public static void setStatus(String status, boolean state) {
        StatusBar.runProgressBar(state);
        StatusBar.setStatus(status);
    }

    public StatusBar() {
        this.setPreferredSize(new Dimension(800, 25));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        label = new JLabel("     Welcome to GUESS");
        label.setPreferredSize(new Dimension(200, 20));
        label.setMaximumSize(new Dimension(200, 20));
        c.fill = 2;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 0, 5);
        progressBar = new ErrorTolerantProgressBar();
        progressBar.setPreferredSize(new Dimension(100, 18));
        progressBar.setMinimumSize(new Dimension(100, 18));
        progressBar.setMaximumSize(new Dimension(100, 18));
        this.add((Component)progressBar, c);
        c.fill = 2;
        c.weighty = 1.0;
        c.gridx = 1;
        String[] stateStrings = new String[]{"Select a state"};
        stateList = new JComboBox<String>(stateStrings);
        stateList.setSelectedIndex(0);
        StorageListener sl = StorageFactory.getSL();
        for (String s : sl.getStates()) {
            stateList.addItem(s);
            states.add(s);
        }
        stateList.addActionListener(this);
        c.insets = new Insets(0, 5, 0, 10);
        this.add((Component)stateList, c);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!StatusBar.buttonsEnabled()) {
                    return;
                }
                Component c = e.getComponent();
                if (c instanceof SimpleButton) {
                    for (int i = 0; i < StatusBar.this.sbList.length; ++i) {
                        StatusBar.this.sbList[i].click(false);
                    }
                    ((SimpleButton)c).click(true);
                    int bType = ((SimpleButton)c).bType;
                    FrameListener fl = VisFactory.getFactory().getDisplay();
                    if (fl instanceof GFrame) {
                        ((GFrame)fl).switchHandler(bType - 1);
                    }
                }
            }
        };
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.insets = new Insets(1, 1, 1, 1);
        SimpleButton sb = new SimpleButton("browse.gif", 1, "Browse");
        this.add((Component)sb, c);
        this.sbList[0] = sb;
        sb.click(true);
        sb.addMouseListener(ma);
        c.gridx = 3;
        sb = new SimpleButton("nodeed.gif", 2, "Manipulate Nodes");
        this.add((Component)sb, c);
        this.sbList[1] = sb;
        sb.addMouseListener(ma);
        c.gridx = 4;
        sb = new SimpleButton("edgeed.gif", 3, "Manipulate Edges");
        this.add((Component)sb, c);
        this.sbList[2] = sb;
        sb.addMouseListener(ma);
        c.gridx = 5;
        sb = new SimpleButton("hulled.gif", 4, "Manipulate Hulls");
        this.add((Component)sb, c);
        this.sbList[3] = sb;
        sb.addMouseListener(ma);
        c.gridx = 6;
        sb = new SimpleButton("draw.gif", 5, "Draw");
        this.add((Component)sb, c);
        this.sbList[4] = sb;
        sb.addMouseListener(ma);
        c.fill = 2;
        c.weightx = 0.8;
        c.gridx = 7;
        this.add((Component)label, c);
        if (VisFactory.getUIMode() == 1) {
            c.gridx = 8;
            c.weightx = 0.0;
            ImageIcon previewIcon = new ImageIcon(this.getClass().getResource("/images/previewscroller.png"));
            this.add(new PreviewCorner((GFrame)VisFactory.getFactory().getDisplay(), previewIcon, true, "whatever"));
        }
        StatusBar.sb = this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object newItem = stateList.getSelectedItem();
        if ("comboBoxChanged".equals(e.getActionCommand()) && !((String)newItem).equals("Select a state")) {
            if (ignoreChange) {
                ignoreChange = false;
                return;
            }
            StatusBar.setStatus("ls(g," + newItem + ")");
            StorageFactory.getSL().loadState(Guess.getGraph(), (String)newItem);
        }
    }

    class ErrorTolerantProgressBar
    extends JProgressBar {
        @Override
        public void paint(Graphics g) {
            try {
                super.paint(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

