/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.EdgeEditorPopup;
import com.hp.hpl.guess.ui.EditorPopup;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.GraphElementEditorPopup;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.GuessJFrame;
import com.hp.hpl.guess.ui.GuessSelectable;
import com.hp.hpl.guess.ui.GuessTransferHandler;
import com.hp.hpl.guess.ui.LabNotebook;
import com.hp.hpl.guess.ui.NodeEditorPopup;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.ThrowableEditorPopup;
import com.hp.hpl.guess.ui.VisFactory;
import com.hp.hpl.guess.util.intervals.IntervalNode;
import com.hp.hpl.guess.util.intervals.TextPaneIntervalNode;
import com.hp.hpl.guess.util.intervals.Tracker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Keymap;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PySyntaxError;
import org.python.util.PythonInterpreter;

public class TextPaneJythonConsole
extends JScrollPane
implements Dockable {
    private int lineNumber = 1;
    protected static int fontSize = 11;
    private InternalTextPane itp = null;
    private boolean docked = true;
    private GuessJFrame myParent = null;

    public static void setFontSize(int size) {
        fontSize = size;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.docked) {
            return super.getPreferredSize();
        }
        return new Dimension(800, 600);
    }

    public TextPaneJythonConsole(PythonInterpreter jython2) {
        this.itp = new InternalTextPane(jython2);
        this.setViewportView(this.itp);
    }

    public void shutdown() {
        this.itp.shutdown();
    }

    @Override
    public int getDirectionPreference() {
        return 1;
    }

    @Override
    public String getTitle() {
        return "Interpreter";
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    public void opening(boolean state) {
    }

    @Override
    public void attaching(boolean state) {
        this.docked = state;
        if (state && this.myParent != null) {
            this.myParent.hide();
        }
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    class InternalTextPane
    extends JTextPane
    implements GuessSelectable {
        public static final String REVISION = "1.0";
        private static final String COMMAND_STYLE = "command";
        private static final String COMMAND_UNDERLINE_STYLE = "ucommand";
        private static final String PROMPT_STYLE = "prompt";
        private static final String ANSWER_STYLE = "answer";
        private static final String ANSWER_UNDERLINE_STYLE = "uanswer";
        private static final String ERROR_STYLE = "error";
        private static final String ERROR_UNDERLINE_STYLE = "uerror";
        private PythonInterpreter jython;
        private ConsoleDocument document;
        private int currentItem;
        private Vector history;
        private Object currentH = null;
        private HashSet currentHighlights = new HashSet();
        private IntervalNode vin = null;
        private boolean demoMode = false;
        private PyDictionary func_dict = null;

        public void shutdown() {
            this.document.shutdown();
        }

        @Override
        public Object getGuessSelected() {
            IntervalNode[] matching = Tracker.searchContained(this.getSelectionStart(), this.getSelectionEnd() - 1);
            HashSet<Object> pl = new HashSet<Object>();
            for (int i = 0; i < matching.length; ++i) {
                IntervalNode in = matching[i];
                Object o = in.getProxy();
                if (o instanceof PyString) continue;
                if (o instanceof PySequence) {
                    Iterator it = ((PySequence)o).findGraphElements().iterator();
                    while (it.hasNext()) {
                        pl.add(it.next());
                    }
                    continue;
                }
                if (!(o instanceof PyInstance) || !((PyInstance)o).isGraphElementProxy()) continue;
                pl.add(((PyInstance)o).__tojava__(Object.class));
            }
            return pl;
        }

        private void underline(IntervalNode nvin) {
            int t;
            int start1;
            int length1;
            if (nvin != null && this.vin == nvin) {
                return;
            }
            if (this.vin != null) {
                length1 = this.vin.getHigh() - this.vin.getLow() + 1;
                start1 = this.vin.getLow();
                try {
                    t = ((TextPaneIntervalNode)this.vin).getStyle();
                    if (t == 1) {
                        this.document.superSetCharacterAttributes(start1, length1, this.getStyle(COMMAND_STYLE), true);
                    } else if (t == 2) {
                        this.document.superSetCharacterAttributes(start1, length1, this.getStyle(ERROR_STYLE), true);
                    } else {
                        this.document.superSetCharacterAttributes(start1, length1, this.getStyle(ANSWER_STYLE), true);
                    }
                }
                catch (Exception ex) {
                    ExceptionWindow.getExceptionWindow(ex);
                }
            }
            if (nvin != null) {
                length1 = nvin.getHigh() - nvin.getLow() + 1;
                start1 = nvin.getLow();
                try {
                    t = ((TextPaneIntervalNode)nvin).getStyle();
                    if (t == 1) {
                        this.document.superSetCharacterAttributes(start1, length1, this.getStyle(COMMAND_UNDERLINE_STYLE), true);
                    } else if (t == 2) {
                        this.document.superSetCharacterAttributes(start1, length1, this.getStyle(ERROR_UNDERLINE_STYLE), true);
                    } else {
                        this.document.superSetCharacterAttributes(start1, length1, this.getStyle(ANSWER_UNDERLINE_STYLE), true);
                    }
                }
                catch (Exception ex) {
                    ExceptionWindow.getExceptionWindow(ex);
                }
            }
            this.vin = nvin;
        }

        private void centerHighlights() {
            if (this.currentHighlights.size() > 0) {
                VisFactory.getFactory().getDisplay().center(this.currentHighlights.clone());
            }
        }

        private void highlight(Object o) {
            if (o != null && this.currentH == o) {
                return;
            }
            StatusBar.setStatus("");
            for (GraphElement el : this.currentHighlights) {
                GraphEvents.mouseLeave(el);
            }
            this.currentHighlights.clear();
            this.currentH = null;
            if (o instanceof PySequence) {
                Iterator it = ((PySequence)o).findGraphElements().iterator();
                int test = 0;
                while (it.hasNext()) {
                    ++test;
                    GraphElement ge = (GraphElement)it.next();
                    this.currentHighlights.add(ge);
                    GraphEvents.mouseEnter(ge);
                }
            } else if (o instanceof PyInstance) {
                if (((PyInstance)o).isGraphElementProxy()) {
                    try {
                        GraphElement element = (GraphElement)((PyInstance)o).__tojava__(GraphElement.class);
                        this.currentHighlights.add(element);
                        GraphEvents.mouseEnter(element);
                    }
                    catch (Exception exception) {}
                } else if (((PyInstance)o).isTypeOfInterest()) {
                    StatusBar.setStatus(Tracker.generateStatusString(o));
                }
            } else if (o instanceof PyFunctionWrapper) {
                StatusBar.setStatus("Function: " + ((PyFunctionWrapper)o).name);
            }
            this.currentH = o;
        }

        public EditorPopup getMenu(Object o) {
            if (o instanceof PyInstance) {
                if (((PyInstance)o).isNodeProxy()) {
                    return NodeEditorPopup.getPopup();
                }
                if (((PyInstance)o).isEdgeProxy()) {
                    return EdgeEditorPopup.getPopup();
                }
            } else {
                if (o instanceof PyString) {
                    return null;
                }
                if (o instanceof PySequence) {
                    return GraphElementEditorPopup.getPopup();
                }
                if (o instanceof Throwable) {
                    return ThrowableEditorPopup.getPopup();
                }
            }
            return null;
        }

        public InternalTextPane(PythonInterpreter jython2) {
            try {
                this.jython = jython2;
                this.setTransferHandler(new GuessTransferHandler());
                this.setDragEnabled(true);
                jython2 = this.prepareInterpreter();
                this.history = this.prepareHistory();
                this.document = this.prepareDocument();
                this.setStyledDocument(this.document);
                this.prepareKeymap(this.getKeymap());
                this.document.insertString(0, this.getEnvironment("PS1"), this.getStyle(PROMPT_STYLE));
                InternalTextPane thisitp = this;
                MouseAdapter test = new MouseAdapter(){

                    private void selectionHandler(MouseEvent e) {
                        IntervalNode[] matching = Tracker.searchContained(InternalTextPane.this.getSelectionStart(), InternalTextPane.this.getSelectionEnd() - 1);
                        if (matching.length <= 0) {
                            InternalTextPane.this.setSelectionStart(InternalTextPane.this.getSelectionStart());
                            InternalTextPane.this.setSelectionEnd(InternalTextPane.this.getSelectionStart());
                            return;
                        }
                        int min = Integer.MAX_VALUE;
                        int max = Integer.MIN_VALUE;
                        HashSet<Object> pl = new HashSet<Object>();
                        for (int i = 0; i < matching.length; ++i) {
                            IntervalNode in = matching[i];
                            min = Math.min(in.getLow(), min);
                            max = Math.max(in.getHigh(), max);
                            Object o = in.getProxy();
                            if (o instanceof PyString) continue;
                            if (o instanceof PySequence) {
                                Iterator it = ((PySequence)o).findGraphElements().iterator();
                                while (it.hasNext()) {
                                    pl.add(it.next());
                                }
                                continue;
                            }
                            if (!(o instanceof PyInstance) || !((PyInstance)o).isGraphElementProxy()) continue;
                            pl.add(((PyInstance)o).__tojava__(Object.class));
                        }
                        InternalTextPane.this.setSelectionStart(min);
                        InternalTextPane.this.setSelectionEnd(max + 1);
                        if (pl.size() > 0) {
                            JEditorPane editor = (JEditorPane)e.getSource();
                            GraphElementEditorPopup.getPopup().show(editor, e.getX(), e.getY(), pl, pl);
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (InternalTextPane.this.getSelectedText() != null) {
                            if (e.getButton() == 3) {
                                this.selectionHandler(e);
                            }
                            return;
                        }
                        if (e.getButton() == 1) {
                            InternalTextPane.this.centerHighlights();
                        }
                        if (e.getButton() == 3) {
                            JEditorPane editor = (JEditorPane)e.getSource();
                            EditorPopup mpup = InternalTextPane.this.getMenu(InternalTextPane.this.currentH);
                            if (mpup != null) {
                                mpup.show(editor, e.getX(), e.getY(), (HashSet)InternalTextPane.this.currentHighlights.clone(), InternalTextPane.this.currentH);
                            }
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        InternalTextPane.this.highlight(null);
                        InternalTextPane.this.underline(null);
                    }
                };
                this.addMouseListener(test);
                MouseMotionAdapter test2 = new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (InternalTextPane.this.getSelectedText() != null) {
                            InternalTextPane.this.highlight(null);
                            InternalTextPane.this.underline(null);
                            return;
                        }
                        Point pt = new Point(e.getX(), e.getY());
                        int pos = InternalTextPane.this.viewToModel(pt);
                        IntervalNode min = InternalTextPane.this.findBestIN(pos);
                        if (min == null) {
                            InternalTextPane.this.highlight(null);
                            InternalTextPane.this.underline(null);
                            return;
                        }
                        if (min != null) {
                            InternalTextPane.this.highlight(min.getProxy());
                        }
                        InternalTextPane.this.underline(min);
                    }
                };
                this.addMouseMotionListener(test2);
                ToolTipManager.sharedInstance().registerComponent(this);
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }

        private IntervalNode findBestIN(int pos) {
            IntervalNode[] matching = Tracker.searchContains(pos, pos);
            if (matching.length <= 0) {
                return null;
            }
            IntervalNode min = null;
            int minSize = Integer.MAX_VALUE;
            for (int m = 0; m < matching.length; ++m) {
                if (matching[m].getHigh() - matching[m].getLow() >= minSize) continue;
                minSize = matching[m].getHigh() - matching[m].getLow();
                min = matching[m];
            }
            return min;
        }

        private void addToIntervals(String text, int commandstart) {
            TextPaneIntervalNode tin;
            PyObject value;
            int locstart = commandstart;
            char[] temp = new char[text.length()];
            text.getChars(0, temp.length, temp, 0);
            StringBuffer toAdd = null;
            boolean inQuotes = false;
            block0: for (int i = 0; i < temp.length; ++i) {
                if (temp[i] == '\\') {
                    ++i;
                    continue;
                }
                if (temp[i] == '\'') {
                    for (int j = i + 1; j < temp.length; ++j) {
                        ++i;
                        if (temp[j] == '\'') continue block0;
                    }
                    continue;
                }
                if (temp[i] == '\"') {
                    for (int j = i + 1; j < temp.length; ++j) {
                        ++i;
                        if (temp[j] == '\"') continue block0;
                    }
                    continue;
                }
                if (Character.isLetterOrDigit(temp[i])) {
                    if (toAdd == null) {
                        toAdd = new StringBuffer();
                        locstart = commandstart + i;
                    }
                    toAdd.append(temp[i]);
                    continue;
                }
                if (toAdd == null) continue;
                PyObject value2 = this.jython.get(toAdd.toString());
                if (value2 != null) {
                    TextPaneIntervalNode tin2 = null;
                    tin2 = value2 instanceof PyFunction ? Tracker.addNode(locstart - 1, toAdd.length() - 1, new PyFunctionWrapper((PyFunction)value2, toAdd.toString())) : Tracker.addNode(locstart - 1, toAdd.length() - 1, value2);
                    if (tin2 != null) {
                        tin2.setStyle(1);
                    }
                }
                toAdd = null;
            }
            if (toAdd != null && (value = this.jython.get(toAdd.toString())) != null && (tin = Tracker.addNode(locstart - 1, toAdd.length() - 1, value)) != null) {
                tin.setStyle(1);
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            block14: {
                if (this.getSelectedText() != null) {
                    return null;
                }
                int pos = this.viewToModel(new Point(e.getX(), e.getY()));
                try {
                    IntervalNode match = this.findBestIN(pos);
                    if (match == null) {
                        return null;
                    }
                    Object value = match.getProxy();
                    if (value == null) break block14;
                    if (value instanceof PySequence) {
                        String anno;
                        StringBuffer toRet = new StringBuffer("<html>");
                        if (value instanceof PyList && (anno = ((PyList)value).annotation) != null) {
                            toRet.append("<B>" + anno + "</B><BR>");
                        }
                        int size = ((PySequence)value).__len__();
                        int max = Math.min(size, 15);
                        int left = size;
                        for (int i = 0; i < max; ++i) {
                            String test = ((PySequence)value).__finditem__(i).toString();
                            if (test.length() > 80) {
                                test = test.substring(0, 80) + "...";
                            }
                            toRet.append(test);
                            if (i < max - 1) {
                                toRet.append("<BR>");
                            }
                            --left;
                        }
                        if (size > 15) {
                            toRet.append("<BR>...(" + left + " more)");
                        }
                        toRet.append("</html>");
                        return toRet.toString();
                    }
                    if (value instanceof PyFunctionWrapper) {
                        StatusBar.setStatus("Function: " + ((PyFunctionWrapper)value).name);
                        if (this.func_dict == null) {
                            this.func_dict = (PyDictionary)this.jython.get("__FUNCTION_DICTIONARY");
                        }
                        if (this.func_dict != null) {
                            PyObject foo = this.func_dict.__finditem__(new PyString(((PyFunctionWrapper)value).name));
                            if (foo != null) {
                                return "<HTML><PRE>" + foo.toString() + "</PRE></HTML>";
                            }
                            return null;
                        }
                        break block14;
                    }
                    return "<html>" + value.toString() + "</html>";
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }

        private Vector prepareHistory() {
            Vector<String> answer = new Vector<String>();
            answer.add("");
            answer.add("");
            this.currentItem = 0;
            return answer;
        }

        private PythonInterpreter prepareInterpreter() {
            this.jython.exec("ENV = {}");
            this.setEnvironment("PS1", ">>> ");
            this.setEnvironment("PS2", "... ");
            this.setEnvironment("PATH_SEPARATOR", System.getProperty("path.separator"));
            this.setEnvironment("COLS", "80");
            return this.jython;
        }

        public String getEnvironment(String key) {
            try {
                return this.jython.eval("ENV['" + key + "']").toString();
            }
            catch (Exception e) {
                return "";
            }
        }

        public void setEnvironment(String key, String value) {
            this.jython.exec(new StringBuffer("ENV['").append(key).append("'] = '").append(value).append("'").toString());
        }

        private ConsoleDocument prepareDocument() {
            ConsoleDocument answer = new ConsoleDocument();
            return answer;
        }

        private void prepareKeymap(Keymap map) {
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), new PreviousHistoryItemAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), new NextHistoryItemAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), new MoveLeftAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(36, 0), new MoveStartAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), new MoveRightAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), new TabulationAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(65, 2), new MoveStartAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(66, 2), new MoveLeftAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(69, 2), new MoveEndAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(70, 2), new MoveRightAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 2), new CancelAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(68, 2), new DeleteAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(75, 2), new KillAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(76, 2), new ClearAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(78, 2), new NextHistoryItemAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(80, 2), new PreviousHistoryItemAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(82, 2), new SearchHistoryItemAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(84, 2), new SwapAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(85, 2), new YankAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(87, 2), new YankWordAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(89, 2), new PasteAction());
        }

        public void move(int offset) {
            if (this.document.isOffsetOnCommandLine(offset)) {
                this.setCaretPosition(offset);
            }
        }

        public void moveStart() {
            this.move(this.document.getCommandLineStartOffset());
        }

        public void moveEnd() {
            this.move(this.document.getCommandLineEndOffset());
        }

        public void moveLeft() {
            this.move(this.getCaretPosition() - 1);
        }

        public void moveRight() {
            this.move(this.getCaretPosition() + 1);
        }

        private class CompletionFilenameFilter
        implements FilenameFilter {
            private String begin = "";

            public CompletionFilenameFilter(String begin) {
                this.begin = begin;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".py") && name.startsWith(this.begin);
            }
        }

        private class DeleteAction
        extends AbstractAction {
            private DeleteAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.delete();
            }
        }

        private class CancelAction
        extends AbstractAction {
            private CancelAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.cancel();
            }
        }

        private class TabulationAction
        extends AbstractAction {
            private TabulationAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.completeCommandLine();
            }
        }

        private class PasteAction
        extends AbstractAction {
            private PasteAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.pasteBuffer();
            }
        }

        private class KillAction
        extends AbstractAction {
            private KillAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.killCommandLine();
            }
        }

        private class YankAction
        extends AbstractAction {
            private YankAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.yankCommandLine();
            }
        }

        private class YankWordAction
        extends AbstractAction {
            private YankWordAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.yankWord();
            }
        }

        private class SwapAction
        extends AbstractAction {
            private SwapAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.swapCharacters();
            }
        }

        private class ClearAction
        extends AbstractAction {
            private ClearAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.clear();
            }
        }

        private class MoveRightAction
        extends AbstractAction {
            private MoveRightAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.moveRight();
            }
        }

        private class MoveLeftAction
        extends AbstractAction {
            private MoveLeftAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.moveLeft();
            }
        }

        private class MoveEndAction
        extends AbstractAction {
            private MoveEndAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.moveEnd();
            }
        }

        private class MoveStartAction
        extends AbstractAction {
            private MoveStartAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.moveStart();
            }
        }

        private class NextHistoryItemAction
        extends AbstractAction {
            private NextHistoryItemAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.selectNextHistoryItem();
            }
        }

        private class PreviousHistoryItemAction
        extends AbstractAction {
            private PreviousHistoryItemAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                InternalTextPane.this.document.selectPreviousHistoryItem();
            }
        }

        private class SearchHistoryItemAction
        extends AbstractAction {
            private SearchHistoryItemAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        }

        private class DocumentWriter
        extends Writer {
            private ConsoleDocument doc = null;
            private Style style = null;

            public DocumentWriter(ConsoleDocument doc, Style style) {
                this.doc = doc;
                this.style = style;
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
                this.write(cbuf, off, len);
            }

            @Override
            public void write(String text) {
                try {
                    this.doc.superInsertString(this.doc.getLength(), text, this.style);
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }

        private class ConsoleDocument
        extends DefaultStyledDocument {
            private String yank = "";
            private int multilining = 0;
            private StringBuffer multiline;
            private boolean CLEARING = false;
            private Hashtable styles;
            private Clipboard clipboard = null;
            private final DataFlavor stringFlavor = DataFlavor.stringFlavor;

            public ConsoleDocument() {
                this.initializeStyles();
                this.addHistoryFromFile();
                Tracker.setDocument(this);
                this.setMenuOptions();
            }

            private void setMenuOptions() {
                JMenu editMenu = Guess.getMainUIWindow().getGMenuBar().editMenu;
                JMenuItem copy = new JMenuItem("Copy from console");
                JMenuItem paste = new JMenuItem("Paste to console");
                ActionListener cpListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        if (event.getActionCommand().equals("Copy from console")) {
                            if (InternalTextPane.this.getSelectedText() != null) {
                                ConsoleDocument.this.yank = InternalTextPane.this.getSelectedText();
                                ConsoleDocument.this.addToClipboard(ConsoleDocument.this.yank);
                            }
                        } else if (event.getActionCommand().equals("Paste to console")) {
                            ConsoleDocument.this.pasteBuffer();
                        }
                    }
                };
                copy.addActionListener(cpListener);
                paste.addActionListener(cpListener);
                editMenu.add(copy);
                editMenu.add(paste);
            }

            protected void initializeStyles() {
                Style def = StyleContext.getDefaultStyleContext().getStyle("default");
                def = this.addStyle(null, def);
                if (Guess.getDefaultFont() != null) {
                    StyleConstants.setFontFamily(def, Guess.getDefaultFont());
                }
                Style style = this.addStyle(InternalTextPane.PROMPT_STYLE, def);
                StyleConstants.setBold(style, true);
                StyleConstants.setFontSize(style, fontSize);
                style = this.addStyle(InternalTextPane.COMMAND_STYLE, def);
                StyleConstants.setBold(style, true);
                StyleConstants.setFontSize(style, fontSize);
                style = this.addStyle(InternalTextPane.COMMAND_UNDERLINE_STYLE, def);
                StyleConstants.setBold(style, true);
                StyleConstants.setFontSize(style, fontSize);
                StyleConstants.setForeground(style, Color.blue);
                StyleConstants.setUnderline(style, true);
                style = this.addStyle(InternalTextPane.ANSWER_STYLE, def);
                StyleConstants.setForeground(style, Color.darkGray);
                StyleConstants.setFontSize(style, fontSize);
                style = this.addStyle(InternalTextPane.ANSWER_UNDERLINE_STYLE, def);
                StyleConstants.setForeground(style, Color.blue);
                StyleConstants.setFontSize(style, fontSize);
                StyleConstants.setUnderline(style, true);
                style = this.addStyle(InternalTextPane.ERROR_STYLE, def);
                StyleConstants.setForeground(style, Color.red);
                StyleConstants.setFontSize(style, fontSize);
                style = this.addStyle(InternalTextPane.ERROR_UNDERLINE_STYLE, def);
                StyleConstants.setForeground(style, Color.red);
                StyleConstants.setFontSize(style, fontSize);
                StyleConstants.setUnderline(style, true);
            }

            protected void addHistoryItem(String command) {
                if (InternalTextPane.this.demoMode) {
                    System.out.println("...");
                    return;
                }
                if (command.indexOf(10) == -1 && !InternalTextPane.this.history.get(InternalTextPane.this.history.size() - 2).equals(command)) {
                    InternalTextPane.this.history.insertElementAt(command, InternalTextPane.this.history.size() - 1);
                }
                InternalTextPane.this.currentItem = InternalTextPane.this.history.size() - 1;
            }

            public void shutdown() {
                this.saveHistoryToFile();
            }

            protected void saveHistoryToFile() {
                if (Guess.getAppletMode() && !Guess.getSignedAppletMode()) {
                    return;
                }
                try {
                    String toLoad = System.getProperty("gHome");
                    if (toLoad == null) {
                        toLoad = ".";
                    }
                    File f = new File(toLoad + File.separatorChar + ".guess_history");
                    PrintStream out = new PrintStream(new FileOutputStream(f));
                    int len = InternalTextPane.this.history.size();
                    int start = InternalTextPane.this.history.size() - 100;
                    if (start < 0) {
                        start = 0;
                    }
                    for (int i = start; i < InternalTextPane.this.history.size(); ++i) {
                        out.println(InternalTextPane.this.history.elementAt(i));
                    }
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            protected void addHistoryFromFile() {
                if (Guess.getAppletMode() && !Guess.getSignedAppletMode()) {
                    return;
                }
                try {
                    File f;
                    String toLoad = System.getProperty("gHome");
                    if (toLoad == null) {
                        toLoad = ".";
                    }
                    if (!(f = new File(toLoad + File.separatorChar + ".guess_history")).exists()) {
                        return;
                    }
                    BufferedReader in = new BufferedReader(new FileReader(f));
                    while (in.ready()) {
                        String command = in.readLine();
                        if (command.indexOf(10) == -1 && !InternalTextPane.this.history.get(InternalTextPane.this.history.size() - 2).equals(command)) {
                            InternalTextPane.this.history.insertElementAt(command, InternalTextPane.this.history.size() - 1);
                        }
                        InternalTextPane.this.currentItem = InternalTextPane.this.history.size() - 1;
                    }
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void selectPreviousHistoryItem() {
                InternalTextPane.this.currentItem = Math.max(1, --InternalTextPane.this.currentItem);
                this.setCommandLine((String)InternalTextPane.this.history.get(InternalTextPane.this.currentItem));
            }

            public void selectNextHistoryItem() {
                InternalTextPane.this.currentItem = Math.min(InternalTextPane.this.history.size() - 1, ++InternalTextPane.this.currentItem);
                this.setCommandLine((String)InternalTextPane.this.history.get(InternalTextPane.this.currentItem));
            }

            public void setCommandLine(String command) {
                this.clearCommandLine();
                try {
                    this.insertString(this.getCommandLineStartOffset(), command, this.getStyle(InternalTextPane.COMMAND_STYLE));
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void swapCharacters() {
                int start = this.getCommandLineStartOffset(InternalTextPane.this.getCaretPosition());
                int current = InternalTextPane.this.getCaretPosition();
                int end = this.getLength();
                try {
                    if (current == start) {
                        return;
                    }
                    String swap = this.getText(current - 1, 1);
                    this.remove(current - 1, 1);
                    if (current == end) {
                        this.superInsertString(this.getLength() - 1, swap, this.getStyle(InternalTextPane.COMMAND_STYLE));
                        InternalTextPane.this.move(this.getLength());
                    } else {
                        this.superInsertString(current, swap, this.getStyle(InternalTextPane.COMMAND_STYLE));
                        InternalTextPane.this.move(current + 1);
                    }
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void addToClipboard(String s) {
                if (this.clipboard == null) {
                    try {
                        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    }
                    catch (Exception ex) {
                        ExceptionWindow.getExceptionWindow(ex);
                    }
                }
                if (this.clipboard != null) {
                    try {
                        StringSelection ss = new StringSelection(s);
                        this.clipboard.setContents(ss, ss);
                    }
                    catch (Exception ex) {
                        ExceptionWindow.getExceptionWindow(ex);
                    }
                }
            }

            public void getFromClipboard() {
                if (this.clipboard == null) {
                    try {
                        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    }
                    catch (Exception ex) {
                        ExceptionWindow.getExceptionWindow(ex);
                    }
                }
                if (this.clipboard != null) {
                    try {
                        Transferable tf = this.clipboard.getContents(this);
                        if (tf.isDataFlavorSupported(this.stringFlavor)) {
                            this.yank = (String)tf.getTransferData(this.stringFlavor);
                        }
                    }
                    catch (Exception ex) {
                        ExceptionWindow.getExceptionWindow(ex);
                    }
                }
            }

            public void yankWord() {
                try {
                    int end = InternalTextPane.this.getCaretPosition();
                    int start = this.getWordStartOffset(end);
                    this.yank = this.getText(start, end - start);
                    this.addToClipboard(this.yank);
                    this.remove(start, end - start);
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void yankCommandLine() {
                try {
                    int start = this.getCommandLineStartOffset(InternalTextPane.this.getCaretPosition());
                    int end = InternalTextPane.this.getCaretPosition();
                    this.yank = this.getText(start, end - start);
                    this.addToClipboard(this.yank);
                    this.remove(start, end - start);
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void killCommandLine() {
                try {
                    int start = InternalTextPane.this.getCaretPosition();
                    int end = this.getCommandLineEndOffset();
                    this.yank = this.getText(start, end - start);
                    this.addToClipboard(this.yank);
                    this.remove(start, end - start);
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void completeCommandLine() {
                block15: {
                    try {
                        int start = this.getCommandLineStartOffset();
                        int end = InternalTextPane.this.getCaretPosition();
                        String command = this.getText(start, end - start);
                        if (command.trim().startsWith("./")) {
                            CompletionFilenameFilter filter = new CompletionFilenameFilter(command.substring(command.indexOf("./") + 2));
                            StringTokenizer tokens = new StringTokenizer(InternalTextPane.this.getEnvironment("PATH"), InternalTextPane.this.getEnvironment("PATH_SEPARATOR"));
                            Vector<String> candidates = new Vector<String>();
                            int longestCandidate = -1;
                            if (tokens.countTokens() <= 0) break block15;
                            this.yank = command;
                            this.addToClipboard(this.yank);
                            while (tokens.hasMoreElements()) {
                                try {
                                    File dir = new File(tokens.nextToken());
                                    if (!dir.isDirectory()) continue;
                                    String[] files = dir.list(filter);
                                    for (int index = 0; index < files.length; ++index) {
                                        candidates.addElement(files[index]);
                                        if (files[index].length() <= longestCandidate) continue;
                                        longestCandidate = files[index].length();
                                    }
                                }
                                catch (Exception e) {
                                }
                            }
                            if (candidates.size() == 0) {
                                return;
                            }
                            if (candidates.size() == 1) {
                                this.yankCommandLine();
                                this.insertString(InternalTextPane.this.getCaretPosition(), command.substring(0, command.indexOf("./") + 2), this.getStyle(InternalTextPane.COMMAND_STYLE));
                                this.insertString(InternalTextPane.this.getCaretPosition(), (String)candidates.elementAt(0), this.getStyle(InternalTextPane.COMMAND_STYLE));
                                break block15;
                            }
                            this.superInsertString(InternalTextPane.this.getCaretPosition(), "\n", this.getStyle(InternalTextPane.COMMAND_STYLE));
                            Iterator list = candidates.iterator();
                            StringBuffer line = new StringBuffer();
                            String each = null;
                            longestCandidate += 2;
                            int columns = 1;
                            try {
                                columns = Integer.parseInt(InternalTextPane.this.getEnvironment("COLS"));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            while (list.hasNext()) {
                                each = (String)list.next();
                                if (line.length() + each.length() > columns && line.length() > 0) {
                                    this.superInsertString(this.getLength(), line.append("\n").toString(), this.getStyle(InternalTextPane.ANSWER_STYLE));
                                    line = new StringBuffer();
                                }
                                line.append(each);
                                for (int count = longestCandidate - each.length(); count > 0; --count) {
                                    line.append(" ");
                                }
                            }
                            if (line.length() > 0) {
                                this.superInsertString(this.getLength(), line.append("\n").toString(), this.getStyle(InternalTextPane.ANSWER_STYLE));
                            }
                            this.superInsertString(this.getLength(), this.multiline != null ? InternalTextPane.this.getEnvironment("PS2") : InternalTextPane.this.getEnvironment("PS1"), this.getStyle(InternalTextPane.PROMPT_STYLE));
                            this.getFromClipboard();
                            this.superInsertString(this.getLength(), this.yank, this.getStyle(InternalTextPane.COMMAND_STYLE));
                            break block15;
                        }
                        this.insertString(InternalTextPane.this.getCaretPosition(), "\t", this.getStyle(InternalTextPane.COMMAND_STYLE));
                    }
                    catch (Exception e) {
                        ExceptionWindow.getExceptionWindow(e);
                    }
                }
            }

            public void cancel() {
                try {
                    this.multilining = 0;
                    this.multiline = null;
                    this.superInsertString(this.getLength(), "\n", this.getStyle(InternalTextPane.COMMAND_STYLE));
                    this.superInsertString(this.getLength(), InternalTextPane.this.getEnvironment("PS1"), this.getStyle(InternalTextPane.PROMPT_STYLE));
                    InternalTextPane.this.moveEnd();
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void delete() {
                try {
                    this.remove(InternalTextPane.this.getCaretPosition(), 1);
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void clear() {
                try {
                    this.clearCommandLine();
                    this.CLEARING = true;
                    this.replace(0, this.getLength(), this.multiline != null ? InternalTextPane.this.getEnvironment("PS2") : InternalTextPane.this.getEnvironment("PS1"), this.getStyle(InternalTextPane.PROMPT_STYLE));
                    this.CLEARING = false;
                    this.pasteBuffer();
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void clearCommandLine() {
                int start = this.getCommandLineStartOffset();
                int end = this.getCommandLineEndOffset();
                try {
                    this.yank = this.getText(start, end - start);
                    this.addToClipboard(this.yank);
                    this.remove(start, end - start);
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            public void pasteBuffer() {
                try {
                    this.getFromClipboard();
                    this.insertString(InternalTextPane.this.getCaretPosition(), this.yank, this.getStyle(InternalTextPane.COMMAND_STYLE));
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }

            private boolean isOffsetOnCommandLine(int offset) {
                int start = this.getCommandLineStartOffset();
                return offset >= start && offset <= this.getLength();
            }

            protected int getCommandLineEndOffset() {
                return this.getCommandLineEndOffset(this.getLength()) - 1;
            }

            protected int getCommandLineEndOffset(int offset) {
                return this.getParagraphElement(offset).getEndOffset();
            }

            protected int getCommandLineStartOffset() {
                return this.getCommandLineStartOffset(this.getLength());
            }

            protected int getCommandLineStartOffset(int offset) {
                return this.getParagraphElement(offset).getStartOffset() + InternalTextPane.this.getEnvironment("PS1").length();
            }

            protected int getWordStartOffset(int offset) throws BadLocationException {
                int start = this.getCommandLineStartOffset(offset);
                String text = this.getText(start, offset - start).trim();
                return start + Math.max(0, text.lastIndexOf(" ") + 1);
            }

            private int getOffsetOnCommandLine(int offset) {
                if (!this.isOffsetOnCommandLine(offset)) {
                    offset = this.getLength();
                    InternalTextPane.this.move(offset);
                }
                return offset;
            }

            private void printOutErr() {
                if (Guess.outHandle != null) {
                    try {
                        while (Guess.outHandle.ready()) {
                            this.superInsertString(this.getLength(), Guess.outHandle.readLine() + "\n", this.getStyle(InternalTextPane.ANSWER_STYLE));
                        }
                    }
                    catch (Exception ex) {
                        ExceptionWindow.getExceptionWindow(ex);
                    }
                }
                if (Guess.errHandle != null) {
                    try {
                        while (Guess.errHandle.ready()) {
                            if (InternalTextPane.this.demoMode) continue;
                            this.superInsertString(this.getLength(), Guess.errHandle.readLine() + "\n", this.getStyle(InternalTextPane.ERROR_STYLE));
                        }
                    }
                    catch (Exception ex) {
                        ExceptionWindow.getExceptionWindow(ex);
                    }
                }
            }

            @Override
            public void insertString(int offset, String text, AttributeSet a) throws BadLocationException {
                this.printOutErr();
                offset = this.getOffsetOnCommandLine(offset);
                String command = null;
                int aftercommand = 0;
                int end = text.indexOf(10);
                if (end > -1) {
                    block36: {
                        InternalTextPane.this.moveEnd();
                        this.superInsertString(this.getCommandLineEndOffset(), "\n", this.getStyle(InternalTextPane.COMMAND_STYLE));
                        int start = this.getCommandLineStartOffset(offset);
                        int length = this.getCommandLineEndOffset() - start - 1;
                        command = this.getText(start, length);
                        if (command.trim().startsWith("./")) {
                            String name = command.trim();
                            name = name.substring(name.indexOf("./") + 2);
                            String path = null;
                            StringTokenizer tokens = new StringTokenizer(InternalTextPane.this.getEnvironment("PATH"), InternalTextPane.this.getEnvironment("PATH_SEPARATOR"));
                            CompletionFilenameFilter filter = new CompletionFilenameFilter(name);
                            block8: while (path == null && tokens.hasMoreElements()) {
                                try {
                                    File dir = new File(tokens.nextToken());
                                    if (!dir.isDirectory()) continue;
                                    String[] files = dir.list(filter);
                                    for (int index = 0; index < files.length; ++index) {
                                        if (!files[index].equals(name)) continue;
                                        path = new File(dir, name).getPath();
                                        continue block8;
                                    }
                                }
                                catch (Exception e) {
                                }
                            }
                            if (path == null) {
                                path = name;
                            }
                            String original = command.substring(0, command.indexOf("./"));
                            command = new StringBuffer(original).append("execfile('").append(path).append("')").toString();
                        }
                        if (command.trim().endsWith(":")) {
                            ++this.multilining;
                            if (this.multiline == null) {
                                this.multiline = new StringBuffer(command).append('\n');
                                if (command.length() > 0) {
                                    this.addHistoryItem(command);
                                }
                            } else {
                                if (command.indexOf("else") > -1 || command.indexOf("elif") > -1 || command.indexOf("except") > -1 || command.indexOf("finally") > -1) {
                                    --this.multilining;
                                }
                                if (command.length() > 0) {
                                    this.addHistoryItem(command);
                                }
                                this.multiline.append(command).append('\n');
                            }
                            this.superInsertString(this.getLength(), InternalTextPane.this.getEnvironment("PS2"), this.getStyle(InternalTextPane.PROMPT_STYLE));
                            this.printOutErr();
                            return;
                        }
                        if (this.multilining > 0) {
                            this.multiline.append(command).append("\n");
                            if (command.length() > 0) {
                                this.addHistoryItem(command);
                            }
                            if (command.trim().equals("pass") || !command.startsWith("\t") || command.length() == 0) {
                                --this.multilining;
                                if (this.multilining > 0) {
                                    this.superInsertString(this.getLength(), InternalTextPane.this.getEnvironment("PS2"), this.getStyle(InternalTextPane.PROMPT_STYLE));
                                    this.printOutErr();
                                    return;
                                }
                                command = this.multiline.toString();
                                this.multiline = null;
                            } else {
                                this.superInsertString(this.getLength(), InternalTextPane.this.getEnvironment("PS2"), this.getStyle(InternalTextPane.PROMPT_STYLE));
                                this.printOutErr();
                                return;
                            }
                        }
                        if (command.trim().length() > 0) {
                            try {
                                DocumentWriter buffer;
                                block35: {
                                    StatusBar.setStatus("");
                                    if (command.equals("quit")) {
                                        Guess.shutdown();
                                    }
                                    this.addHistoryItem(command);
                                    aftercommand = this.getLength();
                                    Tracker.setLocation(this.getLength());
                                    buffer = new DocumentWriter(this, this.getStyle(InternalTextPane.ANSWER_STYLE));
                                    InternalTextPane.this.jython.setOut(buffer);
                                    try {
                                        PyObject oval = InternalTextPane.this.jython.eval(command);
                                        InternalTextPane.this.jython.set("_", (Object)oval);
                                        if (oval instanceof PyFunction) {
                                            InternalTextPane.this.jython.set("_", InternalTextPane.this.jython.eval("apply(_, ())"));
                                        }
                                        if (LabNotebook.getNotebook() != null) {
                                            LabNotebook.getNotebook().addText(command, oval);
                                        }
                                        InternalTextPane.this.jython.exec("if _ != None: print _");
                                    }
                                    catch (PySyntaxError e) {
                                        try {
                                            InternalTextPane.this.jython.exec(command);
                                            if (LabNotebook.getNotebook() != null) {
                                                LabNotebook.getNotebook().addText(command, null);
                                            }
                                        }
                                        catch (Throwable e2) {
                                            String es;
                                            if (InternalTextPane.this.demoMode) break block35;
                                            if (e2 instanceof PyException) {
                                                es = ((PyException)e2).userFriendlyString();
                                                ExceptionWindow.getExceptionWindow(e2);
                                                TextPaneIntervalNode tin = Tracker.addNode(this.getLength(), es.length(), e2);
                                                if (tin != null) {
                                                    tin.setStyle(2);
                                                }
                                                this.superInsertString(this.getLength(), es + "\n", this.getStyle(InternalTextPane.ERROR_STYLE));
                                                break block35;
                                            }
                                            es = e2.toString();
                                            ExceptionWindow.getExceptionWindow(e2);
                                            TextPaneIntervalNode tin = Tracker.addNode(this.getLength(), es.length(), e2);
                                            if (tin != null) {
                                                tin.setStyle(2);
                                            }
                                            this.superInsertString(this.getLength(), es + "\n", this.getStyle(InternalTextPane.ERROR_STYLE));
                                            StatusBar.setErrorStatus("Use Help->Error Log for more details");
                                        }
                                    }
                                }
                                buffer.close();
                            }
                            catch (Exception e) {
                                if (InternalTextPane.this.demoMode) break block36;
                                String es = e.toString();
                                ExceptionWindow.getExceptionWindow(e);
                                TextPaneIntervalNode tin = Tracker.addNode(this.getLength(), es.length(), e);
                                if (tin != null) {
                                    tin.setStyle(2);
                                }
                                this.superInsertString(this.getLength(), es + "\n", this.getStyle(InternalTextPane.ERROR_STYLE));
                                StatusBar.setErrorStatus("Use Help->Error Log for more details");
                            }
                        }
                    }
                    this.superInsertString(this.getLength(), InternalTextPane.this.getEnvironment("PS1"), this.getStyle(InternalTextPane.PROMPT_STYLE));
                } else {
                    this.superInsertString(offset, text, this.getStyle(InternalTextPane.COMMAND_STYLE));
                }
                if (command != null) {
                    InternalTextPane.this.addToIntervals(command, aftercommand - command.length());
                }
                Tracker.getRecentNodes().clear();
                this.printOutErr();
            }

            private void superInsertString(int offset, String text, AttributeSet a) throws BadLocationException {
                super.insertString(offset, text, a);
            }

            public void superReplace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                super.remove(offset, length);
                super.insertString(offset, text, attrs);
            }

            public void superSetCharacterAttributes(int offset, int length, AttributeSet attrs, boolean replace) throws BadLocationException {
                super.setCharacterAttributes(offset, length, attrs, replace);
            }

            @Override
            public void remove(int offset, int length) throws BadLocationException {
                if (this.isOffsetOnCommandLine(offset) || this.CLEARING) {
                    super.remove(offset, length);
                }
            }
        }
    }

    class PyFunctionWrapper {
        public String name = null;

        public PyFunctionWrapper(PyFunction func, String name) {
            this.name = name;
        }
    }
}

