/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.jung.JungVisFactory;
import com.hp.hpl.guess.piccolo.PFactory;
import com.hp.hpl.guess.prefuse.PrefuseFactory;
import com.hp.hpl.guess.tg.TGFactory;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ConvexHull;
import com.hp.hpl.guess.ui.DumbFactory;
import com.hp.hpl.guess.ui.EdgeListener;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.NodeListener;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.python.core.PyInstance;
import org.python.core.PySequence;

public abstract class VisFactory {
    private static VisFactory singleton = null;
    public static final int PICCOLO = 1;
    public static final int PREFUSE = 2;
    public static final int TOUCHGRAPH = 3;
    public static final int NOVIS = 4;
    public static final int JUNG = 5;
    private static int uiMode = 1;
    public static final int RECTANGLE = 1;
    public static final int ELLIPSE = 2;
    public static final int ROUNDRECTANGLE = 3;
    public static final int TEXT_RECTANGLE = 4;
    public static final int TEXT_ELLIPSE = 5;
    public static final int TEXT_ROUNDRECTANGLE = 6;
    public static final int IMAGE = 7;
    public static final int RECTANGLE3D = 8;
    public static final int ELLIPSE3D = 9;
    public static final int ROUNDRECTANGLE3D = 10;
    public static final int USER = 4;
    private boolean directed = false;

    public static void shutdown() {
        singleton = null;
    }

    public static void setFactory(int type) {
        if (singleton != null) {
            throw new Error("VisFactory.setFactory() called twice");
        }
        singleton = type == 1 ? new PFactory() : (type == 3 ? new TGFactory() : (type == 2 ? new PrefuseFactory() : (type == 5 ? new JungVisFactory() : new DumbFactory())));
        uiMode = type;
    }

    public static VisFactory getFactory() {
        if (singleton == null) {
            VisFactory.setFactory(1);
        }
        return singleton;
    }

    public static int getUIMode() {
        return uiMode;
    }

    public abstract FrameListener getDisplay();

    public abstract NodeListener generateNode(Node var1);

    public abstract NodeListener generateNode(int var1, double var2, double var4, double var6, double var8, Color var10, Node var11);

    public abstract EdgeListener generateEdge(Edge var1);

    public abstract void remove(Node var1);

    public abstract void remove(Edge var1);

    public abstract void add(Node var1);

    public abstract void add(Edge var1);

    public void runNow() {
    }

    public boolean getDirected() {
        return this.directed;
    }

    public void setDirected(boolean dir) {
        this.directed = dir;
    }

    public ConvexHull createConvexHull(PySequence seq, String c) {
        Vector<Node> v = new Vector<Node>();
        for (int i = 0; i < seq.__len__(); ++i) {
            Node element = (Node)((PyInstance)seq.__finditem__(i)).__tojava__(Node.class);
            v.add(element);
        }
        return this.createConvexHull(v, Colors.getColor(c, Color.red));
    }

    public ConvexHull createConvexHull(Collection s, Color c) {
        return null;
    }

    public void removeConvexHull(ConvexHull c) {
    }

    public void removeConvexHulls(PySequence seq) {
        for (int i = 0; i < seq.__len__(); ++i) {
            this.removeConvexHull((ConvexHull)((PyInstance)seq.__finditem__(i)).__tojava__(ConvexHull.class));
        }
    }

    public Collection getConvexHulls() {
        return new HashSet();
    }
}

