/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui.slider;

import com.hp.hpl.guess.ui.slider.MultiSliderUI;
import java.awt.Color;
import javax.accessibility.AccessibleState;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;

public class MultiSlider
extends JSlider {
    private static final String uiClassID = "MultiSliderUI";
    private BoundedRangeModel[] sliderModels;
    private boolean bounded = false;
    private Color currentThumbColor = Color.red;
    private transient boolean useEndPoints = false;
    private transient int valueBeforeStateChange;

    public MultiSlider(int orientation, int min, int max, int val1, int val2) {
        this.checkOrientation(orientation);
        this.orientation = orientation;
        this.setNumberOfThumbs(min, max, new int[]{val1, val2});
    }

    public MultiSlider(int orientation, int min, int max) {
        this.checkOrientation(orientation);
        this.orientation = orientation;
        this.setNumberOfThumbs(min, max, 2);
    }

    public MultiSlider() {
        this(0, 0, 100);
    }

    public MultiSlider(int orientation) {
        this(orientation, 0, 100);
    }

    public MultiSlider(int min, int max) {
        this(0, min, max);
    }

    public void setCurrentThumbColor(Color c) {
        this.currentThumbColor = c;
    }

    public Color getCurrentThumbColor() {
        return this.currentThumbColor;
    }

    public int getTrackBuffer() {
        return ((MultiSliderUI)this.ui).getTrackBuffer();
    }

    private void checkOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    @Override
    public void updateUI() {
        this.updateLabelUIs();
        MultiSliderUI ui = new MultiSliderUI();
        if (this.sliderModels != null) {
            ui.setThumbCount(this.sliderModels.length);
        }
        this.setUI(ui);
    }

    public int getNumberOfThumbs() {
        return this.sliderModels.length;
    }

    private void setNumberOfThumbs(int min, int max, int num, boolean useEndPoints) {
        int[] values = this.createDefaultValues(min, max, num, useEndPoints);
        this.setNumberOfThumbs(min, max, values);
    }

    private void setNumberOfThumbs(int min, int max, int num) {
        this.setNumberOfThumbs(min, max, num, false);
    }

    private void setNumberOfThumbs(int min, int max, int[] values) {
        if (values == null || values.length < 1) {
            values = new int[]{50};
        }
        int num = values.length;
        this.sliderModels = new BoundedRangeModel[num];
        for (int i = 0; i < num; ++i) {
            this.sliderModels[i] = new DefaultBoundedRangeModel(values[i], 0, min, max);
            this.sliderModels[i].addChangeListener(this.changeListener);
        }
        this.updateUI();
    }

    private void setNumberOfThumbs(int num) {
        this.setNumberOfThumbs(num, false);
    }

    private void setNumberOfThumbs(int num, boolean useEndPoints) {
        if (this.getNumberOfThumbs() != num) {
            this.setNumberOfThumbs(this.getMinimum(), this.getMaximum(), num, useEndPoints);
        }
    }

    private void setNumberOfThumbs(int[] values) {
        this.setNumberOfThumbs(this.getMinimum(), this.getMaximum(), values);
    }

    private int[] createDefaultValues(int min, int max, int num_of_values, boolean useEndPoints) {
        int[] values = new int[num_of_values];
        int range = max - min;
        if (!useEndPoints) {
            int step = range / (num_of_values + 1);
            for (int i = 0; i < num_of_values; ++i) {
                values[i] = min + (i + 1) * step;
            }
        } else {
            if (num_of_values < 1) {
                return new int[0];
            }
            values[0] = this.getMinimum();
            values[num_of_values - 1] = this.getMaximum();
            int[] def = this.createDefaultValues(this.getMinimum(), this.getMaximum(), num_of_values - 2, false);
            for (int i = 0; i < def.length; ++i) {
                values[i + 1] = def[i];
            }
        }
        return values;
    }

    public int getCurrentThumbIndex() {
        return ((MultiSliderUI)this.ui).getCurrentIndex();
    }

    @Override
    public BoundedRangeModel getModel() {
        return this.getModelAt(this.getCurrentThumbIndex());
    }

    public BoundedRangeModel getModelAt(int index) {
        if (this.sliderModels == null || index >= this.sliderModels.length) {
            return null;
        }
        return this.sliderModels[index];
    }

    public BoundedRangeModel[] getModels() {
        return this.sliderModels;
    }

    @Override
    public void setModel(BoundedRangeModel newModel) {
        this.setModelAt(this.getCurrentThumbIndex(), newModel);
    }

    public void setModelAt(int index, BoundedRangeModel newModel) {
        BoundedRangeModel oldModel = this.getModelAt(index);
        if (oldModel != null) {
            oldModel.removeChangeListener(this.changeListener);
        }
        this.sliderModels[index] = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.changeListener);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", oldModel == null ? null : new Integer(oldModel.getValue()), newModel == null ? null : new Integer(newModel.getValue()));
            }
        }
        this.firePropertyChange("model", oldModel, this.sliderModels[index]);
    }

    @Override
    public void setMinimum(int minimum) {
        int count = this.getNumberOfThumbs();
        int oldMin = this.getModel().getMinimum();
        for (int i = 0; i < count; ++i) {
            this.getModelAt(i).setMinimum(minimum);
        }
        this.firePropertyChange("minimum", new Integer(oldMin), new Integer(minimum));
    }

    @Override
    public void setMaximum(int maximum) {
        int count = this.getNumberOfThumbs();
        int oldMax = this.getModel().getMaximum();
        for (int i = 0; i < count; ++i) {
            this.getModelAt(i).setMaximum(maximum);
        }
        this.firePropertyChange("maximum", new Integer(oldMax), new Integer(maximum));
    }

    @Override
    public int getValue() {
        return this.getValueAt(this.getCurrentThumbIndex());
    }

    public int getValueAt(int index) {
        return this.getModelAt(index).getValue();
    }

    @Override
    public void setValue(int n) {
        this.setValueAt(this.getCurrentThumbIndex(), n);
    }

    public void setValueAt(int index, int n) {
        BoundedRangeModel m = this.getModelAt(index);
        int oldValue = m.getValue();
        m.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(oldValue), new Integer(m.getValue()));
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        boolean result = false;
        int count = this.getNumberOfThumbs();
        for (int i = 0; i < count; ++i) {
            result = result || this.getValueIsAdjustingAt(i);
        }
        return result;
    }

    public boolean getValueIsAdjustingAt(int index) {
        return this.getModelAt(index).getValueIsAdjusting();
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.setValueIsAdjustingAt(this.getCurrentThumbIndex(), b);
    }

    public void setValueIsAdjustingAt(int index, boolean b) {
        BoundedRangeModel m = this.getModelAt(index);
        boolean oldValue = m.getValueIsAdjusting();
        m.setValueIsAdjusting(b);
        if (oldValue != b && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", oldValue ? AccessibleState.BUSY : null, b ? AccessibleState.BUSY : null);
        }
    }

    @Override
    public void setExtent(int extent) {
        int count = this.getNumberOfThumbs();
        for (int i = 0; i < count; ++i) {
            this.getModelAt(i).setExtent(extent);
        }
    }

    public void setBounded(boolean b) {
        this.bounded = b;
    }

    public boolean isBounded() {
        return this.bounded;
    }

    public int getValueBeforeStateChange() {
        return this.valueBeforeStateChange;
    }

    void setValueBeforeStateChange(int v) {
        this.valueBeforeStateChange = v;
    }
}

