/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.ui.slider;

import com.hp.hpl.guess.ui.slider.MultiSlider;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalSliderUI;

class MultiSliderUI
extends MetalSliderUI {
    private Rectangle[] thumbRects = null;
    private int thumbCount;
    private transient int currentIndex = 0;
    private transient boolean isDragging;
    private transient int[] minmaxIndices = new int[2];

    public static ComponentUI createUI(JComponent b) {
        return new MultiSliderUI();
    }

    int getTrackBuffer() {
        return this.trackBuffer;
    }

    public void setThumbCount(int count) {
        this.thumbCount = count;
    }

    protected int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void installUI(JComponent c) {
        this.thumbRects = new Rectangle[this.thumbCount];
        for (int i = 0; i < this.thumbCount; ++i) {
            this.thumbRects[i] = new Rectangle();
        }
        this.currentIndex = 0;
        if (this.thumbCount > 0) {
            this.thumbRect = this.thumbRects[this.currentIndex];
        }
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        for (int i = 0; i < this.thumbCount; ++i) {
            this.thumbRects[i] = null;
        }
        this.thumbRects = null;
    }

    @Override
    protected void installListeners(JSlider slider) {
        slider.addMouseListener(this.trackListener);
        slider.addMouseMotionListener(this.trackListener);
        slider.addFocusListener(this.focusListener);
        slider.addComponentListener(this.componentListener);
        slider.addPropertyChangeListener(this.propertyChangeListener);
        for (int i = 0; i < this.thumbCount; ++i) {
            ((MultiSlider)slider).getModelAt(i).addChangeListener(this.changeListener);
        }
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        slider.removeMouseListener(this.trackListener);
        slider.removeMouseMotionListener(this.trackListener);
        slider.removeFocusListener(this.focusListener);
        slider.removeComponentListener(this.componentListener);
        slider.removePropertyChangeListener(this.propertyChangeListener);
        for (int i = 0; i < this.thumbCount; ++i) {
            BoundedRangeModel model = ((MultiSlider)slider).getModelAt(i);
            if (model == null) continue;
            model.removeChangeListener(this.changeListener);
        }
    }

    @Override
    protected void calculateThumbSize() {
        Dimension size = this.getThumbSize();
        for (int i = 0; i < this.thumbCount; ++i) {
            this.thumbRects[i].setSize(size.width, size.height);
        }
        this.thumbRect.setSize(size.width, size.height);
    }

    @Override
    protected void calculateThumbLocation() {
        MultiSlider slider = (MultiSlider)this.slider;
        int majorTickSpacing = slider.getMajorTickSpacing();
        int minorTickSpacing = slider.getMinorTickSpacing();
        int tickSpacing = 0;
        if (minorTickSpacing > 0) {
            tickSpacing = minorTickSpacing;
        } else if (majorTickSpacing > 0) {
            tickSpacing = majorTickSpacing;
        }
        for (int i = 0; i < this.thumbCount; ++i) {
            int valuePosition;
            if (slider.getSnapToTicks()) {
                int sliderValue;
                int snappedValue = sliderValue = slider.getValueAt(i);
                if (tickSpacing != 0) {
                    if ((sliderValue - slider.getMinimum()) % tickSpacing != 0) {
                        float temp = (float)(sliderValue - slider.getMinimum()) / (float)tickSpacing;
                        int whichTick = Math.round(temp);
                        snappedValue = slider.getMinimum() + whichTick * tickSpacing;
                    }
                    if (snappedValue != sliderValue) {
                        slider.setValueAt(i, snappedValue);
                    }
                }
            }
            if (slider.getOrientation() == 0) {
                valuePosition = this.xPositionForValue(slider.getValueAt(i));
                this.thumbRects[i].x = valuePosition - this.thumbRects[i].width / 2;
                this.thumbRects[i].y = this.trackRect.y;
                continue;
            }
            valuePosition = this.yPositionForValue(slider.getValueAt(i));
            this.thumbRects[i].x = this.trackRect.x;
            this.thumbRects[i].y = valuePosition - this.thumbRects[i].height / 2;
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = g.getClipBounds();
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(g);
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        if (this.slider.hasFocus() && clip.intersects(this.focusRect)) {
            this.paintFocus(g);
        }
        for (int i = 0; i < this.thumbCount; ++i) {
            if (i == this.currentIndex || !clip.intersects(this.thumbRects[i])) continue;
            this.thumbRect = this.thumbRects[i];
            this.paintThumb(g);
        }
        if (clip.intersects(this.thumbRects[this.currentIndex])) {
            this.thumbRect = this.thumbRects[this.currentIndex];
            this.paintThumb(g);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        super.paintThumb(g);
    }

    @Override
    public void paintTrack(Graphics g) {
        super.paintTrack(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int oldValue = ((MultiSlider)this.slider).getValueAt(this.currentIndex);
            int blockIncrement = this.slider.getMaximum() / 10;
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            ((MultiSlider)this.slider).setValueAt(this.currentIndex, oldValue + delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int oldValue = ((MultiSlider)this.slider).getValueAt(this.currentIndex);
            int delta = 1 * (direction > 0 ? 1 : -1);
            ((MultiSlider)this.slider).setValueAt(this.currentIndex, oldValue + delta);
        }
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new MultiTrackListener();
    }

    static class SharedActionScroller
    extends AbstractAction {
        int _dir;
        boolean _block;

        public SharedActionScroller(int dir, boolean block) {
            this._dir = dir;
            this._block = block;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSlider slider = (JSlider)e.getSource();
            MultiSliderUI ui = (MultiSliderUI)slider.getUI();
            if (this._dir == -1 || this._dir == 1) {
                int realDir = this._dir;
                if (slider.getInverted()) {
                    int n = realDir = this._dir == -1 ? 1 : -1;
                }
                if (this._block) {
                    ui.scrollByBlock(realDir);
                } else {
                    ui.scrollByUnit(realDir);
                }
            } else if (slider.getInverted()) {
                if (this._dir == -2) {
                    ((MultiSlider)slider).setValueAt(ui.currentIndex, slider.getMaximum());
                } else if (this._dir == 2) {
                    ((MultiSlider)slider).setValueAt(ui.currentIndex, slider.getMinimum());
                }
            } else if (this._dir == -2) {
                ((MultiSlider)slider).setValueAt(ui.currentIndex, slider.getMinimum());
            } else if (this._dir == 2) {
                ((MultiSlider)slider).setValueAt(ui.currentIndex, slider.getMaximum());
            }
        }
    }

    class MultiTrackListener
    extends BasicSliderUI.TrackListener {
        int _trackTop;
        int _trackBottom;
        int _trackLeft;
        int _trackRight;
        private transient int[] firstXY;

        MultiTrackListener() {
            super(MultiSliderUI.this);
            this.firstXY = new int[2];
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int[] neighbours = new int[2];
            boolean bounded = ((MultiSlider)MultiSliderUI.this.slider).isBounded();
            if (!MultiSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            this.firstXY[0] = this.currentMouseX;
            this.firstXY[1] = this.currentMouseY;
            MultiSliderUI.this.slider.requestFocus();
            ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[0] = -1;
            ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[1] = -1;
            for (int i = 0; i < MultiSliderUI.this.thumbCount; ++i) {
                if (!MultiSliderUI.this.thumbRects[i].contains(this.currentMouseX, this.currentMouseY)) continue;
                if (MultiSliderUI.this.minmaxIndices[0] == -1) {
                    ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[0] = i;
                    MultiSliderUI.this.currentIndex = i;
                }
                if (MultiSliderUI.this.minmaxIndices[1] < i) {
                    ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[1] = i;
                }
                switch (MultiSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].x;
                    }
                }
                MultiSliderUI.this.isDragging = true;
                MultiSliderUI.this.thumbRect = MultiSliderUI.this.thumbRects[i];
                if (bounded) {
                    neighbours[0] = i - 1 < 0 ? -1 : i - 1;
                    neighbours[1] = i + 1 >= MultiSliderUI.this.thumbCount ? -1 : i + 1;
                } else {
                    MultiSliderUI.this.currentIndex = i;
                    ((MultiSlider)MultiSliderUI.this.slider).setValueIsAdjustingAt(i, true);
                    neighbours[0] = -1;
                    neighbours[1] = -1;
                }
                this.setThumbBounds(neighbours);
            }
            if (MultiSliderUI.this.minmaxIndices[0] > -1) {
                return;
            }
            MultiSliderUI.this.currentIndex = this.findClosest(this.currentMouseX, this.currentMouseY, neighbours, -1);
            MultiSliderUI.this.thumbRect = MultiSliderUI.this.thumbRects[MultiSliderUI.this.currentIndex];
            MultiSliderUI.this.isDragging = false;
            ((MultiSlider)MultiSliderUI.this.slider).setValueIsAdjustingAt(MultiSliderUI.this.currentIndex, true);
            Dimension sbSize = MultiSliderUI.this.slider.getSize();
            int direction = 1;
            switch (MultiSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int scrollbarCenter;
                    if (MultiSliderUI.this.thumbRect.isEmpty()) {
                        scrollbarCenter = sbSize.height / 2;
                        if (!MultiSliderUI.this.drawInverted()) {
                            direction = this.currentMouseY < scrollbarCenter ? 1 : -1;
                            break;
                        }
                        direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((MultiSliderUI)MultiSliderUI.this).thumbRect.y;
                    if (!MultiSliderUI.this.drawInverted()) {
                        direction = this.currentMouseY < thumbY ? 1 : -1;
                        break;
                    }
                    direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    int scrollbarCenter;
                    if (MultiSliderUI.this.thumbRect.isEmpty()) {
                        scrollbarCenter = sbSize.width / 2;
                        if (!MultiSliderUI.this.drawInverted()) {
                            direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                            break;
                        }
                        direction = this.currentMouseX < scrollbarCenter ? 1 : -1;
                        break;
                    }
                    int thumbX = ((MultiSliderUI)MultiSliderUI.this).thumbRect.x;
                    direction = !MultiSliderUI.this.drawInverted() ? (this.currentMouseX < thumbX ? -1 : 1) : (this.currentMouseX < thumbX ? 1 : -1);
                }
            }
            MultiSliderUI.this.scrollDueToClickInTrack(direction);
            Rectangle r = MultiSliderUI.this.thumbRect;
            if (!r.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(direction)) {
                MultiSliderUI.this.scrollTimer.stop();
                MultiSliderUI.this.scrollListener.setDirection(direction);
                MultiSliderUI.this.scrollTimer.start();
            }
        }

        private void setThumbBounds(int[] neighbours) {
            int halfThumbWidth = ((MultiSliderUI)MultiSliderUI.this).thumbRect.width / 2;
            int halfThumbHeight = ((MultiSliderUI)MultiSliderUI.this).thumbRect.height / 2;
            switch (MultiSliderUI.this.slider.getOrientation()) {
                case 1: {
                    this._trackTop = neighbours[1] == -1 ? ((MultiSliderUI)MultiSliderUI.this).trackRect.y : ((MultiSliderUI)MultiSliderUI.this).thumbRects[neighbours[1]].y + halfThumbHeight;
                    this._trackBottom = neighbours[0] == -1 ? ((MultiSliderUI)MultiSliderUI.this).trackRect.y + (((MultiSliderUI)MultiSliderUI.this).trackRect.height - 1) : ((MultiSliderUI)MultiSliderUI.this).thumbRects[neighbours[0]].y + halfThumbHeight;
                    break;
                }
                case 0: {
                    this._trackLeft = neighbours[0] == -1 ? ((MultiSliderUI)MultiSliderUI.this).trackRect.x : ((MultiSliderUI)MultiSliderUI.this).thumbRects[neighbours[0]].x + halfThumbWidth;
                    this._trackRight = neighbours[1] == -1 ? ((MultiSliderUI)MultiSliderUI.this).trackRect.x + (((MultiSliderUI)MultiSliderUI.this).trackRect.width - 1) : ((MultiSliderUI)MultiSliderUI.this).thumbRects[neighbours[1]].x + halfThumbWidth;
                }
            }
        }

        private int findClosest(int x, int y, int[] neighbours, int excluded) {
            int orientation = MultiSliderUI.this.slider.getOrientation();
            int rightmin = Integer.MAX_VALUE;
            int leftmin = -2147483647;
            int dx = 0;
            int dxw = 0;
            int dy = 0;
            int dyh = 0;
            neighbours[0] = -1;
            neighbours[1] = -1;
            block4: for (int i = 0; i < MultiSliderUI.this.thumbCount; ++i) {
                if (i == excluded) continue;
                switch (orientation) {
                    case 1: {
                        dy = ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].y - y;
                        dyh = ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].y + ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].height - y;
                        if (dyh <= 0 && dyh > leftmin) {
                            leftmin = dyh;
                            neighbours[0] = i;
                        }
                        if (dy < 0 || dy > rightmin) continue block4;
                        rightmin = dy;
                        neighbours[1] = i;
                        continue block4;
                    }
                    case 0: {
                        dx = ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].x - x;
                        dxw = ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].x + ((MultiSliderUI)MultiSliderUI.this).thumbRects[i].width - x;
                        if (dxw <= 0 && dxw >= leftmin) {
                            leftmin = dxw;
                            neighbours[0] = i;
                        }
                        if (dx < 0 || dx >= rightmin) continue block4;
                        rightmin = dx;
                        neighbours[1] = i;
                    }
                }
            }
            int closest = Math.abs(leftmin) <= Math.abs(rightmin) ? neighbours[0] : neighbours[1];
            return closest == -1 ? 0 : closest;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ((MultiSlider)MultiSliderUI.this.slider).setValueBeforeStateChange(((MultiSlider)MultiSliderUI.this.slider).getValueAt(MultiSliderUI.this.currentIndex));
            int thumbMiddle = 0;
            boolean bounded = ((MultiSlider)MultiSliderUI.this.slider).isBounded();
            if (!MultiSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!MultiSliderUI.this.isDragging) {
                return;
            }
            switch (MultiSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((MultiSliderUI)MultiSliderUI.this).thumbRect.height / 2;
                    int thumbTop = e.getY() - this.offset;
                    if (bounded) {
                        int[] neighbours = new int[2];
                        int idx = -1;
                        int diff = e.getY() - this.firstXY[1];
                        idx = e.getY() - this.firstXY[1] > 0 ? MultiSliderUI.this.minmaxIndices[0] : MultiSliderUI.this.minmaxIndices[1];
                        int n = idx;
                        ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[1] = n;
                        ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[0] = n;
                        if (idx == -1) break;
                        neighbours[0] = idx - 1 < 0 ? -1 : idx - 1;
                        neighbours[1] = idx + 1 >= MultiSliderUI.this.thumbCount ? -1 : idx + 1;
                        MultiSliderUI.this.thumbRect = MultiSliderUI.this.thumbRects[idx];
                        MultiSliderUI.this.currentIndex = idx;
                        ((MultiSlider)MultiSliderUI.this.slider).setValueIsAdjustingAt(idx, true);
                        this.setThumbBounds(neighbours);
                    }
                    thumbTop = Math.max(thumbTop, this._trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, this._trackBottom - halfThumbHeight);
                    MultiSliderUI.this.setThumbLocation(((MultiSliderUI)MultiSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    ((MultiSlider)MultiSliderUI.this.slider).setValueAt(MultiSliderUI.this.currentIndex, MultiSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((MultiSliderUI)MultiSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    if (bounded) {
                        int[] neighbours = new int[2];
                        int idx = -1;
                        idx = e.getX() - this.firstXY[0] <= 0 ? MultiSliderUI.this.minmaxIndices[0] : MultiSliderUI.this.minmaxIndices[1];
                        int n = idx;
                        ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[1] = n;
                        ((MultiSliderUI)MultiSliderUI.this).minmaxIndices[0] = n;
                        if (idx == -1) break;
                        neighbours[0] = idx - 1 < 0 ? -1 : idx - 1;
                        neighbours[1] = idx + 1 >= MultiSliderUI.this.thumbCount ? -1 : idx + 1;
                        MultiSliderUI.this.thumbRect = MultiSliderUI.this.thumbRects[idx];
                        MultiSliderUI.this.currentIndex = idx;
                        ((MultiSlider)MultiSliderUI.this.slider).setValueIsAdjustingAt(idx, true);
                        this.setThumbBounds(neighbours);
                    }
                    thumbLeft = Math.max(thumbLeft, this._trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, this._trackRight - halfThumbWidth);
                    MultiSliderUI.this.setThumbLocation(thumbLeft, ((MultiSliderUI)MultiSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    ((MultiSlider)MultiSliderUI.this.slider).setValueAt(MultiSliderUI.this.currentIndex, MultiSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!MultiSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            MultiSliderUI.this.scrollTimer.stop();
            if (MultiSliderUI.this.slider.getSnapToTicks()) {
                MultiSliderUI.this.isDragging = false;
                ((MultiSlider)MultiSliderUI.this.slider).setValueIsAdjustingAt(MultiSliderUI.this.currentIndex, false);
            } else {
                ((MultiSlider)MultiSliderUI.this.slider).setValueIsAdjustingAt(MultiSliderUI.this.currentIndex, false);
                MultiSliderUI.this.isDragging = false;
            }
            MultiSliderUI.this.slider.repaint();
        }
    }
}

