/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.util;

import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.ui.Colors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public abstract class VisualUtils {
    private static Random r = new Random();

    public static void colorize(Graph g, Field column) {
        Collection c = g.groupBy(column);
        for (Collection c2 : c) {
            Iterator it2 = c2.iterator();
            String col = Colors.randomColor();
            while (it2.hasNext()) {
                GraphElement ge = (GraphElement)it2.next();
                ge.__setattr__("color", col);
            }
        }
    }

    public static void resizeRandom(Graph g, Field column, double min, double max) {
        Collection c = g.groupBy(column);
        for (Collection c2 : c) {
            Iterator it2 = c2.iterator();
            double size = min + r.nextDouble() * (max - min);
            while (it2.hasNext()) {
                GraphElement ge = (GraphElement)it2.next();
                if (column.getType() == 1) {
                    ge.__setattr__("size", new Double(size));
                    continue;
                }
                if (column.getType() != 2) continue;
                ge.__setattr__("width", new Double(size));
            }
        }
    }

    public static void resizeLinear(Graph g, Field column, double min, double max) {
        Collection c = g.groupAndSortBy(column);
        double increment = (max - min) / (double)c.size();
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Collection c2 = (Collection)it.next();
            Iterator it2 = c2.iterator();
            double size = min + increment * (double)i;
            ++i;
            while (it2.hasNext()) {
                GraphElement ge = (GraphElement)it2.next();
                if (column.getType() == 1) {
                    ge.__setattr__("size", new Double(size));
                    continue;
                }
                if (column.getType() != 2) continue;
                ge.__setattr__("width", new Double(size));
            }
        }
    }

    public static void colorize(Graph g, Field column, Color start, Color end) {
        Collection c = g.groupAndSortBy(column);
        if (c.size() <= 0) {
            System.out.println("No groupings");
            return;
        }
        ArrayList al = Colors.generateColors(start, end, c.size());
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Collection c2 = (Collection)it.next();
            Iterator it2 = c2.iterator();
            String col = (String)al.get(i);
            ++i;
            while (it2.hasNext()) {
                GraphElement ge = (GraphElement)it2.next();
                ge.__setattr__("color", col);
            }
        }
    }

    public static void colorize(Graph g, Field column, Color start, Color middle, Color end) {
        Collection c = g.groupAndSortBy(column);
        if (c.size() <= 0) {
            System.out.println("No groupings");
            return;
        }
        ArrayList al = Colors.generateColors(start, middle, end, c.size());
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Collection c2 = (Collection)it.next();
            Iterator it2 = c2.iterator();
            String col = (String)al.get(i);
            ++i;
            while (it2.hasNext()) {
                GraphElement ge = (GraphElement)it2.next();
                ge.__setattr__("color", col);
            }
        }
    }
}

