/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.util.intervals;

import com.hp.hpl.guess.util.AnnoHashSet;
import com.hp.hpl.guess.util.AnnoVector;
import java.io.Serializable;
import org.python.core.PyInstance;
import org.python.core.PyList;

public class IntervalNode
implements Serializable {
    private Object proxyObj = null;
    private int max = 0;
    private int min = 0;
    protected int high = 0;
    protected int low = 0;
    private IntervalNode right;
    private IntervalNode left;
    protected IntervalNode p;
    protected boolean color = true;
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected static final IntervalNode nullIntervalNode = new IntervalNode();

    public final Object getProxy() {
        return this.proxyObj;
    }

    public String getAnnotation() {
        if (this.proxyObj != null) {
            Object t = this.proxyObj;
            if (this.proxyObj instanceof PyInstance) {
                t = ((PyInstance)t).__tojava__(Object.class);
            } else if (this.proxyObj instanceof PyList) {
                return ((PyList)this.proxyObj).annotation;
            }
            if (t instanceof AnnoHashSet) {
                return ((AnnoHashSet)t).annotation;
            }
            if (t instanceof AnnoVector) {
                return ((AnnoVector)t).annotation;
            }
        }
        return null;
    }

    public IntervalNode(int low, int high, Object proxy) {
        if (high < low) {
            int lowtemp = low;
            low = high;
            high = lowtemp;
        }
        this.low = low;
        this.high = high;
        this.max = high;
        this.min = low;
        this.right = nullIntervalNode;
        this.left = nullIntervalNode;
        this.p = nullIntervalNode;
        this.proxyObj = proxy;
    }

    public IntervalNode(int low, int high) {
        this(low, high, null);
    }

    protected IntervalNode() {
        this.low = -1;
        this.high = -1;
        this.max = -1;
        this.min = -1;
        this.right = this;
        this.left = this;
        this.p = this;
    }

    public String toString() {
        return this.low + " " + this.high + " " + this.proxyObj;
    }

    protected final boolean contains(int low2, int high2) {
        return this.low <= low2 && this.high >= high2;
    }

    protected final boolean isContained(int low2, int high2) {
        return this.low >= low2 && this.high <= high2;
    }

    protected final boolean overlaps(int low2, int high2) {
        return high2 >= this.low && low2 <= this.high;
    }

    protected final boolean exactMatch(int low2, int high2) {
        return low2 == this.low && high2 == this.high;
    }

    protected final void setRight(IntervalNode x) {
        this.right = x;
        this.setMax();
        this.setMin();
    }

    protected final void setLeft(IntervalNode x) {
        this.left = x;
        this.setMax();
        this.setMin();
    }

    protected final IntervalNode getRight() {
        return this.right;
    }

    protected final IntervalNode getLeft() {
        return this.left;
    }

    protected final IntervalNode getP() {
        return this.p;
    }

    protected final void setP(IntervalNode x) {
        this.p = x;
        this.setMax();
        this.setMin();
    }

    protected final int getMax() {
        return this.max;
    }

    protected final void setMax() {
        int prevmax = this.max;
        int i1 = this.high;
        int i2 = this.left.max;
        int i3 = this.right.max;
        this.max = i1 >= i2 && i1 >= i3 ? i1 : (i2 >= i1 && i2 >= i3 ? i2 : i3);
        if (this.p != nullIntervalNode && prevmax != this.max) {
            this.p.setMax();
        }
    }

    protected final int getMin() {
        return this.min;
    }

    protected final void setMin() {
        int prevmin = this.min;
        int i1 = this.low;
        int i2 = this.left.min;
        int i3 = this.right.min;
        if (i2 == -1) {
            i2 = i1;
        }
        if (i3 == -1) {
            i3 = i1;
        }
        this.min = i1 <= i2 && i1 <= i3 ? i1 : (i2 <= i1 && i2 <= i3 ? i2 : i3);
        if (this.p != nullIntervalNode && prevmin != this.min) {
            this.p.setMin();
        }
    }

    protected final IntervalNode treeMin() {
        IntervalNode x = this;
        while (x.left != nullIntervalNode) {
            x = x.left;
        }
        return x;
    }

    public final void copyValues(IntervalNode y) {
        this.low = y.low;
        this.high = y.high;
        this.setMax();
        this.setMin();
        this.color = y.color;
    }

    protected final IntervalNode treeMax() {
        IntervalNode x = this;
        while (x.right != nullIntervalNode) {
            x = x.right;
        }
        return x;
    }

    public final int getHigh() {
        return this.high;
    }

    public final int getLow() {
        return this.low;
    }
}

